/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.jaams.jaams_weaponry.entity.AxeProjectileEntity;
import net.jaams.jaams_weaponry.util.ModTags;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.jaams.jaams_weaponry.weapons.CleaverItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Mod.EventBusSubscriber
public class AxeBehavior {
    private static final double AXE_THROW_PROBABILITY = 0.5;
    private static final long AXE_BASE_THROW_COOLDOWN = 100L;
    private static final long AXE_INITIAL_COOLDOWN_MIN = 40L;
    private static final long AXE_INITIAL_COOLDOWN_MAX = 80L;
    private static final long AXE_PAUSE_AFTER_THROW = 30L;
    private static final float AXE_BASE_PROJECTILE_SPEED = 0.6f;
    private static final float AXE_PROJECTILE_INACCURACY = 1.0f;
    private static final double AXE_BASE_MIN_THROW_DISTANCE = 8.0;
    private static final double AXE_BASE_MAX_THROW_DISTANCE = 25.0;
    private static final double AXE_DISTANCE_VARIATION = 0.4;
    private static final double AXE_MIN_DOT_PRODUCT = 0.8;
    private static final double AXE_PROJECTILE_Y_OFFSET = -0.2;
    private static final int TRAJECTORY_CHECK_STEPS = 10;
    private static final float SPEED_SCALE_FACTOR = 0.04f;
    private static final long COOLDOWN_SCALE_FACTOR = 6L;
    private static final float CRITICAL_CHANCE = 0.05f;
    private static final Map<UUID, Long> AXE_LAST_THROW_TIME = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Long> AXE_TARGET_ACQUIRED_TIME = new ConcurrentHashMap<UUID, Long>();

    @SubscribeEvent
    public static void onAxeEntityUpdate(LivingEvent.LivingTickEvent event) {
        double maxThrowDistance;
        Mob mob;
        LivingEntity entity;
        block11: {
            block10: {
                entity = event.getEntity();
                if (entity.m_9236_().f_46443_ || !entity.m_6084_() || !(entity instanceof Mob)) break block10;
                mob = (Mob)entity;
                if (!(entity instanceof Player)) break block11;
            }
            return;
        }
        Level level = entity.m_9236_();
        ItemStack axeItem = ModUtils.getItemInEitherHand(entity, stack -> stack != null && stack.m_204117_(ModTags.AXES));
        if (axeItem == null || axeItem.m_41619_() || axeItem.m_41773_() >= axeItem.m_41776_() - 1) {
            return;
        }
        long currentTime = level.m_46467_();
        LivingEntity target = mob.m_5448_();
        RandomSource random = level.m_213780_();
        UUID entityUUID = entity.m_20148_();
        if (target == null || !target.m_6084_()) {
            AXE_TARGET_ACQUIRED_TIME.remove(entityUUID);
            return;
        }
        AXE_TARGET_ACQUIRED_TIME.computeIfAbsent(entityUUID, k -> currentTime);
        long timeSinceTargetAcquired = currentTime - AXE_TARGET_ACQUIRED_TIME.getOrDefault(entityUUID, currentTime);
        long initialCooldown = 40L + (long)random.m_188503_(41);
        if (timeSinceTargetAcquired < initialCooldown) {
            return;
        }
        if (random.m_188500_() >= 0.5 || currentTime - AXE_LAST_THROW_TIME.getOrDefault(entityUUID, 0L) < 100L + (long)random.m_188503_(20)) {
            return;
        }
        if (ModUtils.hasRestrictedEffect(entity)) {
            return;
        }
        double minThrowDistance = 8.0 * (0.6 + random.m_188500_() * 2.0 * 0.4);
        if (!AxeBehavior.canThrowAtTarget(entity, target, level, minThrowDistance, maxThrowDistance = 25.0 * (0.6 + random.m_188500_() * 2.0 * 0.4))) {
            if (currentTime > AXE_LAST_THROW_TIME.getOrDefault(entityUUID, 0L)) {
                mob.m_21573_().m_26569_();
            }
            return;
        }
        double distanceToTarget = entity.m_20270_((Entity)target);
        float scaledProjectileSpeed = 0.6f + (float)(distanceToTarget * (double)0.04f);
        long scaledCooldown = 100L + (long)(distanceToTarget * 6.0) + (long)random.m_188503_(20);
        AxeBehavior.throwAxe(entity, axeItem, target, mob, level, scaledProjectileSpeed);
        AXE_LAST_THROW_TIME.put(entityUUID, currentTime + 30L + scaledCooldown);
        mob.m_21573_().m_26573_();
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && !((entity = (LivingEntity)entity2) instanceof Player)) {
            AXE_LAST_THROW_TIME.remove(entity.m_20148_());
            AXE_TARGET_ACQUIRED_TIME.remove(entity.m_20148_());
        }
    }

    private static boolean canThrowAtTarget(LivingEntity entity, LivingEntity target, Level level, double minThrowDistance, double maxThrowDistance) {
        Vec3 entityLookDirection;
        if (target == null || !target.m_6084_()) {
            return false;
        }
        double distanceToTarget = entity.m_20270_((Entity)target);
        if (distanceToTarget < minThrowDistance || distanceToTarget > maxThrowDistance) {
            return false;
        }
        Vec3 directionToTarget = new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20188_() - entity.m_20188_(), target.m_20189_() - entity.m_20189_()).m_82541_();
        double angle = directionToTarget.m_82526_(entityLookDirection = entity.m_20154_().m_82541_());
        if (angle <= 0.8) {
            return false;
        }
        return AxeBehavior.simulateProjectilePath(entity, target, level, directionToTarget);
    }

    private static boolean simulateProjectilePath(LivingEntity entity, LivingEntity target, Level level, Vec3 direction) {
        Vec3 currentPos = new Vec3(entity.m_20185_() + direction.f_82479_, entity.m_20188_() + -0.2, entity.m_20189_() + direction.f_82481_);
        Vec3 targetPos = target.m_146892_();
        double totalDistance = currentPos.m_82554_(targetPos);
        double stepSize = totalDistance / 10.0;
        for (int i = 1; i <= 10; ++i) {
            double t = (double)i * stepSize;
            Vec3 checkPos = currentPos.m_82549_(direction.m_82490_(t));
            ClipContext clipContext = new ClipContext(currentPos, checkPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
            if (level.m_45547_(clipContext).m_6662_() != HitResult.Type.MISS) {
                return false;
            }
            AABB boundingBox = new AABB(checkPos.f_82479_ - 0.5, checkPos.f_82480_ - 0.5, checkPos.f_82481_ - 0.5, checkPos.f_82479_ + 0.5, checkPos.f_82480_ + 0.5, checkPos.f_82481_ + 0.5);
            List entitiesInPath = level.m_6249_((Entity)entity, boundingBox, e -> e.m_6084_() && e instanceof LivingEntity && e != entity && e != target);
            if (!entitiesInPath.isEmpty()) {
                return false;
            }
            if (checkPos.m_82554_(targetPos) < 0.5) {
                return true;
            }
            currentPos = checkPos;
        }
        ClipContext finalCheck = new ClipContext(currentPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        if (level.m_45547_(finalCheck).m_6662_() != HitResult.Type.MISS) {
            return false;
        }
        AABB finalBoundingBox = new AABB(currentPos.f_82479_ - 0.5, currentPos.f_82480_ - 0.5, currentPos.f_82481_ - 0.5, targetPos.f_82479_ + 0.5, targetPos.f_82480_ + 0.5, targetPos.f_82481_ + 0.5);
        List finalEntitiesInPath = level.m_6249_((Entity)entity, finalBoundingBox, e -> e.m_6084_() && e instanceof LivingEntity && e != entity && e != target);
        return finalEntitiesInPath.isEmpty();
    }

    private static void throwAxe(LivingEntity entity, ItemStack axeItem, LivingEntity target, Mob mob, Level level, float projectileSpeed) {
        InteractionHand hand = axeItem == entity.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        entity.m_21011_(hand, true);
        boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)axeItem) > 0;
        int pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)axeItem);
        int projectileCount = hasMultishot ? 3 : 1;
        float[] shotPitches = CleaverItem.generateShotPitches(level.m_213780_(), projectileCount);
        Vec3 direction = new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20188_() - entity.m_20188_(), target.m_20189_() - entity.m_20189_()).m_82541_();
        float adjustedSpeed = projectileSpeed;
        for (int i = 0; i < projectileCount; ++i) {
            AxeProjectileEntity projectile = new AxeProjectileEntity(level, entity, axeItem.m_41777_());
            projectile.m_5602_((Entity)entity);
            projectile.setPiercingLevel(projectile.getPiercingLevel() + pierceLevel);
            double posX = entity.m_20185_() + direction.f_82479_;
            double posY = entity.m_20188_() + -0.2;
            double posZ = entity.m_20189_() + direction.f_82481_;
            projectile.m_6034_(posX, posY, posZ);
            if (level.m_213780_().m_188501_() < 0.05f) {
                projectile.setCritical(true);
            }
            if (hasMultishot) {
                AbstractArrow.Pickup pickup = projectile.f_36705_ = i == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED;
                if (i != 0) {
                    projectile.getPersistentData().m_128379_("IsMultishotClone", true);
                }
                float spreadAngle = 10.0f;
                float rotation = i == 0 ? 0.0f : (i == 1 ? -spreadAngle : spreadAngle);
                Vec3 upVector = entity.m_20289_(1.0f);
                Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis(rotation * (float)Math.PI / 180.0f, (float)upVector.f_82479_, (float)upVector.f_82480_, (float)upVector.f_82481_);
                Vector3f rotatedVector = new Vector3f((float)direction.f_82479_, (float)direction.f_82480_, (float)direction.f_82481_).rotate((Quaternionfc)rotationQuaternion);
                projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), adjustedSpeed, 1.0f);
            } else {
                projectile.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, adjustedSpeed, 1.0f);
            }
            projectile.setWeaponItem(axeItem.m_41777_());
            level.m_7967_((Entity)projectile);
            SoundEvent shootSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:axe_throw"));
            level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), shootSound != null ? shootSound : SoundEvents.f_12520_, SoundSource.HOSTILE, 1.0f, shotPitches[i]);
        }
        if (axeItem.m_41613_() > 0) {
            axeItem.m_41774_(1);
        }
    }
}

