/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.jaams.jaams_weaponry.entity.DynamiteProjectileEntity;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class DynamiteBehavior {
    private static final double DYNAMITE_EXPLOSION_PROBABILITY = 0.2;
    private static final double DYNAMITE_THROW_PROBABILITY = 0.5;
    private static final long DYNAMITE_BASE_THROW_COOLDOWN = 60L;
    private static final long DYNAMITE_PAUSE_AFTER_THROW = 20L;
    private static final float DYNAMITE_BASE_PROJECTILE_SPEED = 1.0f;
    private static final float DYNAMITE_PROJECTILE_INACCURACY = 0.5f;
    private static final double DYNAMITE_BASE_MIN_THROW_DISTANCE = 6.0;
    private static final double DYNAMITE_BASE_MAX_THROW_DISTANCE = 16.0;
    private static final double DYNAMITE_DISTANCE_VARIATION = 0.15;
    private static final double DYNAMITE_MIN_DOT_PRODUCT = 0.5;
    private static final double DYNAMITE_PROJECTILE_Y_OFFSET = -0.1;
    private static final int TRAJECTORY_CHECK_STEPS = 10;
    private static final float SPEED_SCALE_FACTOR = 0.05f;
    private static final long COOLDOWN_SCALE_FACTOR = 5L;
    private static final float CRITICAL_CHANCE = 0.05f;
    private static final Map<UUID, Long> DYNAMITE_LAST_THROW_TIME = new ConcurrentHashMap<UUID, Long>();

    @SubscribeEvent
    public static void onDynamiteEntityUpdate(LivingEvent.LivingTickEvent event) {
        double maxThrowDistance;
        RandomSource random;
        double minThrowDistance;
        Mob mob;
        LivingEntity entity;
        block8: {
            block7: {
                entity = event.getEntity();
                if (entity.m_9236_().f_46443_ || !entity.m_6084_() || !(entity instanceof Mob)) break block7;
                mob = (Mob)entity;
                if (!(entity instanceof Player)) break block8;
            }
            return;
        }
        DynamiteBehavior.avoidNearbyDynamite(entity, mob);
        Level level = entity.m_9236_();
        ItemStack dynamiteItem = ModUtils.getItemInEitherHand(entity, stack -> stack != null && stack.m_41720_() == JaamsWeaponryModItems.DYNAMITE.get());
        if (dynamiteItem == null || dynamiteItem.m_41619_()) {
            return;
        }
        long currentTime = level.m_46467_();
        if (level.m_213780_().m_188500_() >= 0.5 || currentTime - DYNAMITE_LAST_THROW_TIME.getOrDefault(entity.m_20148_(), 0L) < 60L || ModUtils.hasRestrictedEffect(entity)) {
            return;
        }
        LivingEntity target = mob.m_5448_();
        if (!DynamiteBehavior.canThrowAtTarget(entity, target, level, minThrowDistance = 6.0 * (0.85 + (random = level.m_213780_()).m_188500_() * 2.0 * 0.15), maxThrowDistance = 16.0 * (0.85 + random.m_188500_() * 2.0 * 0.15))) {
            if (currentTime > DYNAMITE_LAST_THROW_TIME.getOrDefault(entity.m_20148_(), 0L)) {
                mob.m_21573_().m_26569_();
            }
            return;
        }
        double distanceToTarget = entity.m_20270_((Entity)target);
        float scaledProjectileSpeed = 1.0f + (float)(distanceToTarget * (double)0.05f);
        long scaledCooldown = 60L + (long)(distanceToTarget * 5.0);
        DynamiteBehavior.throwDynamite(entity, dynamiteItem, target, mob, level, scaledProjectileSpeed);
        DYNAMITE_LAST_THROW_TIME.put(entity.m_20148_(), currentTime + 20L + scaledCooldown);
        mob.m_21573_().m_26573_();
    }

    @SubscribeEvent
    public static void onAttackWithDynamite(LivingAttackEvent event) {
        LivingEntity attacker;
        block5: {
            block4: {
                Entity entity = event.getSource().m_7639_();
                if (!(entity instanceof LivingEntity)) break block4;
                attacker = (LivingEntity)entity;
                if (!attacker.m_9236_().f_46443_ && !(attacker instanceof Player)) break block5;
            }
            return;
        }
        ItemStack mainHandItem = ModUtils.getItemInMainHand(attacker, (Item)JaamsWeaponryModItems.DYNAMITE.get());
        if (!mainHandItem.m_41619_() && attacker.m_9236_().m_213780_().m_188500_() < 0.2) {
            ModUtils.triggerExplosion(attacker);
            mainHandItem.m_41774_(1);
        }
    }

    @SubscribeEvent
    public static void onDynamiteEntityHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_ || event.getSource().m_7639_() == null || entity.m_9236_().m_213780_().m_188500_() >= 0.2) {
            return;
        }
        ItemStack dynamiteItem = ModUtils.getItemInEitherHand(entity, (Item)JaamsWeaponryModItems.DYNAMITE.get());
        if (!dynamiteItem.m_41619_()) {
            ModUtils.triggerExplosion(entity);
            dynamiteItem.m_41774_(1);
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && !((entity = (LivingEntity)entity2) instanceof Player)) {
            DYNAMITE_LAST_THROW_TIME.remove(entity.m_20148_());
        }
    }

    private static void avoidNearbyDynamite(LivingEntity entity, Mob mob) {
        for (DynamiteProjectileEntity dynamite : entity.m_9236_().m_45976_(DynamiteProjectileEntity.class, entity.m_20191_().m_82400_(6.0))) {
            if (dynamite.m_19749_() != entity) continue;
            Vec3 awayFromDynamite = entity.m_20182_().m_82546_(dynamite.m_20182_()).m_82541_().m_82490_(1.5);
            mob.m_21573_().m_26519_(entity.m_20185_() + awayFromDynamite.f_82479_, entity.m_20186_(), entity.m_20189_() + awayFromDynamite.f_82481_, 1.2);
            return;
        }
    }

    private static boolean canThrowAtTarget(LivingEntity entity, LivingEntity target, Level level, double minThrowDistance, double maxThrowDistance) {
        Vec3 entityLookDirection;
        if (target == null || !target.m_6084_()) {
            return false;
        }
        double distanceToTarget = entity.m_20270_((Entity)target);
        if (distanceToTarget < minThrowDistance || distanceToTarget > maxThrowDistance) {
            return false;
        }
        Vec3 directionToTarget = new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20188_() - entity.m_20188_(), target.m_20189_() - entity.m_20189_()).m_82541_();
        double angle = directionToTarget.m_82526_(entityLookDirection = entity.m_20154_().m_82541_());
        if (angle <= 0.5) {
            return false;
        }
        return DynamiteBehavior.simulateProjectilePath(entity, target, level, directionToTarget);
    }

    private static boolean simulateProjectilePath(LivingEntity entity, LivingEntity target, Level level, Vec3 direction) {
        Vec3 currentPos = new Vec3(entity.m_20185_() + direction.f_82479_, entity.m_20188_() + -0.1, entity.m_20189_() + direction.f_82481_);
        Vec3 targetPos = target.m_146892_();
        double totalDistance = currentPos.m_82554_(targetPos);
        double stepSize = totalDistance / 10.0;
        for (int i = 1; i <= 10; ++i) {
            double t = (double)i * stepSize;
            Vec3 checkPos = currentPos.m_82549_(direction.m_82490_(t));
            ClipContext clipContext = new ClipContext(currentPos, checkPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
            if (level.m_45547_(clipContext).m_6662_() != HitResult.Type.MISS) {
                return false;
            }
            if (checkPos.m_82554_(targetPos) < 0.5) {
                return true;
            }
            currentPos = checkPos;
        }
        ClipContext finalCheck = new ClipContext(currentPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return level.m_45547_(finalCheck).m_6662_() == HitResult.Type.MISS;
    }

    private static void throwDynamite(LivingEntity entity, ItemStack dynamiteItem, LivingEntity target, Mob mob, Level level, float projectileSpeed) {
        InteractionHand hand = dynamiteItem == entity.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        entity.m_21011_(hand, true);
        DynamiteProjectileEntity projectile = new DynamiteProjectileEntity((EntityType<? extends DynamiteProjectileEntity>)((EntityType)JaamsWeaponryModEntities.DYNAMITE_PROJECTILE.get()), entity, level);
        projectile.m_5602_((Entity)entity);
        Vec3 direction = new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20188_() - entity.m_20188_(), target.m_20189_() - entity.m_20189_()).m_82541_();
        projectile.m_6034_(entity.m_20185_() + direction.f_82479_, entity.m_20188_() + -0.1, entity.m_20189_() + direction.f_82481_);
        projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, projectileSpeed, 0.5f);
        level.m_7967_((Entity)projectile);
        if (dynamiteItem.m_41613_() > 0) {
            dynamiteItem.m_41774_(1);
        }
        SoundEvent shootSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:dynamite_fired"));
        level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), shootSound != null ? shootSound : SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

