/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import net.jaams.jaams_weaponry.item.GauntletItem;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GauntletBehavior {
    private static final float CRITICAL_CHANCE = 0.05f;

    @SubscribeEvent
    public static void onGauntletEntityAttack(LivingAttackEvent event) {
        Mob mob;
        LivingEntity target;
        block13: {
            block12: {
                Entity attacker = event.getSource().m_7639_();
                target = event.getEntity();
                if (!(attacker instanceof Mob)) break block12;
                mob = (Mob)attacker;
                if (target instanceof LivingEntity) break block13;
            }
            return;
        }
        LivingEntity entity = target;
        ItemStack gauntletItem = mob.m_21205_();
        Item item = gauntletItem.m_41720_();
        if (!(item instanceof GauntletItem)) {
            return;
        }
        GauntletItem gauntlet = (GauntletItem)item;
        Level level = entity.m_9236_();
        if (!level.f_46443_) {
            boolean isCritical = level.f_46441_.m_188501_() < 0.05f;
            ModUtils.playSound((Entity)entity, "jaams_weaponry:gauntlet_hit", SoundSource.HOSTILE, 0.7f, 1.0f);
            if (ModUtils.isEntityInBattleMode((Entity)entity)) {
                double deltaZ;
                double deltaX = mob.m_20185_() - entity.m_20185_();
                double distance = Math.sqrt(deltaX * deltaX + (deltaZ = mob.m_20189_() - entity.m_20189_()) * deltaZ);
                if (distance > 0.0) {
                    deltaX /= distance;
                    deltaZ /= distance;
                }
                float knockbackForce = 0.5f;
                if (isCritical) {
                    knockbackForce += 0.5f;
                }
                if (knockbackForce > 0.0f) {
                    entity.m_20334_(deltaX * (double)knockbackForce, 0.2, deltaZ * (double)knockbackForce);
                    entity.f_19864_ = true;
                }
            } else {
                float knockbackForce = 0.5f;
                if (isCritical) {
                    knockbackForce += 0.25f;
                }
                entity.m_147240_((double)knockbackForce, mob.m_20185_() - entity.m_20185_(), mob.m_20189_() - entity.m_20189_());
            }
        }
    }
}

