/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.jaams.jaams_weaponry.entity.GiantShurikenProjectileEntity;
import net.jaams.jaams_weaponry.handler.mechanics.SweepAttackHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.item.GiantShurikenItem;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Mod.EventBusSubscriber
public class GiantShurikenBehavior {
    private static final double GIANT_SHURIKEN_THROW_PROBABILITY = 0.5;
    private static final long GIANT_SHURIKEN_BASE_THROW_COOLDOWN = 60L;
    private static final long GIANT_SHURIKEN_PAUSE_AFTER_THROW = 20L;
    private static final float GIANT_SHURIKEN_BASE_PROJECTILE_SPEED = 0.9f;
    private static final float GIANT_SHURIKEN_PROJECTILE_INACCURACY = 1.0f;
    private static final double GIANT_SHURIKEN_BASE_MIN_THROW_DISTANCE = 6.0;
    private static final double GIANT_SHURIKEN_BASE_MAX_THROW_DISTANCE = 29.0;
    private static final double GIANT_SHURIKEN_DISTANCE_VARIATION = 0.15;
    private static final double GIANT_SHURIKEN_MIN_DOT_PRODUCT = 0.5;
    private static final double GIANT_SHURIKEN_PROJECTILE_Y_OFFSET = -0.1;
    private static final int TRAJECTORY_CHECK_STEPS = 10;
    private static final float SPEED_SCALE_FACTOR = 0.05f;
    private static final long COOLDOWN_SCALE_FACTOR = 5L;
    private static final float CRITICAL_CHANCE = 0.05f;
    private static final Map<UUID, Long> GIANT_SHURIKEN_LAST_THROW_TIME = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onGiantShurikenEntityUpdate(LivingEvent.LivingTickEvent event) {
        double maxThrowDistance;
        RandomSource random;
        double minThrowDistance;
        Mob mob;
        LivingEntity entity;
        block8: {
            block7: {
                entity = event.getEntity();
                if (entity.m_9236_().f_46443_ || !entity.m_6084_() || !(entity instanceof Mob)) break block7;
                mob = (Mob)entity;
                if (!(entity instanceof Player)) break block8;
            }
            return;
        }
        Level level = entity.m_9236_();
        ItemStack giantShurikenItem = ModUtils.getItemInEitherHand(entity, stack -> stack != null && stack.m_41720_() == JaamsWeaponryModItems.GIANT_SHURIKEN.get());
        if (giantShurikenItem == null || giantShurikenItem.m_41619_() || giantShurikenItem.m_41773_() >= giantShurikenItem.m_41776_() - 1) {
            return;
        }
        long currentTime = level.m_46467_();
        if (level.m_213780_().m_188500_() >= 0.5 || currentTime - GIANT_SHURIKEN_LAST_THROW_TIME.getOrDefault(entity.m_20148_(), 0L) < 60L || ModUtils.hasRestrictedEffect(entity)) {
            return;
        }
        LivingEntity target = mob.m_5448_();
        if (!GiantShurikenBehavior.canThrowAtTarget(entity, target, level, minThrowDistance = 6.0 * (0.85 + (random = level.m_213780_()).m_188500_() * 2.0 * 0.15), maxThrowDistance = 29.0 * (0.85 + random.m_188500_() * 2.0 * 0.15))) {
            if (currentTime > GIANT_SHURIKEN_LAST_THROW_TIME.getOrDefault(entity.m_20148_(), 0L)) {
                mob.m_21573_().m_26569_();
            }
            return;
        }
        double distanceToTarget = entity.m_20270_((Entity)target);
        float scaledProjectileSpeed = 0.9f + (float)(distanceToTarget * (double)0.05f);
        long scaledCooldown = 60L + (long)(distanceToTarget * 5.0);
        GiantShurikenBehavior.throwGiantShuriken(entity, giantShurikenItem, target, mob, level, scaledProjectileSpeed);
        GIANT_SHURIKEN_LAST_THROW_TIME.put(entity.m_20148_(), currentTime + 20L + scaledCooldown);
        mob.m_21573_().m_26573_();
    }

    @SubscribeEvent
    public static void onGiantShurikenEntityAttack(LivingAttackEvent event) {
        LivingEntity livingTarget;
        Mob mob;
        block6: {
            block5: {
                Entity attacker = event.getSource().m_7639_();
                LivingEntity target = event.getEntity();
                if (!(attacker instanceof Mob)) break block5;
                mob = (Mob)attacker;
                if (!(target instanceof LivingEntity)) break block5;
                livingTarget = target;
                if (!(attacker instanceof Player)) break block6;
            }
            return;
        }
        ItemStack giantShurikenItem = mob.m_21205_();
        if (!(giantShurikenItem.m_41720_() instanceof GiantShurikenItem)) {
            return;
        }
        if (mob.m_21205_() == giantShurikenItem || mob.m_21206_() == giantShurikenItem) {
            SweepAttackHandler.performSweepAttack(giantShurikenItem, livingTarget, (LivingEntity)mob, 1.5f, 0.5f, 1, true, SoundEvents.f_12317_, (ParticleOptions)ParticleTypes.f_123766_, nearby -> SweepAttackHandler.isValidSweepTarget(nearby, livingTarget, (LivingEntity)mob, mob.m_20154_()));
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && !((entity = (LivingEntity)entity2) instanceof Player)) {
            GIANT_SHURIKEN_LAST_THROW_TIME.remove(entity.m_20148_());
        }
    }

    private static boolean canThrowAtTarget(LivingEntity entity, LivingEntity target, Level level, double minThrowDistance, double maxThrowDistance) {
        Vec3 entityLookDirection;
        if (target == null || !target.m_6084_()) {
            return false;
        }
        double distanceToTarget = entity.m_20270_((Entity)target);
        if (distanceToTarget < minThrowDistance || distanceToTarget > maxThrowDistance) {
            return false;
        }
        Vec3 directionToTarget = new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20188_() - entity.m_20188_(), target.m_20189_() - entity.m_20189_()).m_82541_();
        double angle = directionToTarget.m_82526_(entityLookDirection = entity.m_20154_().m_82541_());
        if (angle <= 0.5) {
            return false;
        }
        return GiantShurikenBehavior.simulateProjectilePath(entity, target, level, directionToTarget);
    }

    private static boolean simulateProjectilePath(LivingEntity entity, LivingEntity target, Level level, Vec3 direction) {
        Vec3 currentPos = new Vec3(entity.m_20185_() + direction.f_82479_, entity.m_20188_() + -0.1, entity.m_20189_() + direction.f_82481_);
        Vec3 targetPos = target.m_146892_();
        double totalDistance = currentPos.m_82554_(targetPos);
        double stepSize = totalDistance / 10.0;
        for (int i = 1; i <= 10; ++i) {
            double t = (double)i * stepSize;
            Vec3 checkPos = currentPos.m_82549_(direction.m_82490_(t));
            ClipContext clipContext = new ClipContext(currentPos, checkPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
            if (level.m_45547_(clipContext).m_6662_() != HitResult.Type.MISS) {
                return false;
            }
            if (checkPos.m_82554_(targetPos) < 0.5) {
                return true;
            }
            currentPos = checkPos;
        }
        ClipContext finalCheck = new ClipContext(currentPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return level.m_45547_(finalCheck).m_6662_() == HitResult.Type.MISS;
    }

    private static void throwGiantShuriken(LivingEntity entity, ItemStack giantShurikenItem, LivingEntity target, Mob mob, Level level, float projectileSpeed) {
        InteractionHand hand = giantShurikenItem == entity.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        entity.m_21011_(hand, true);
        boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)giantShurikenItem) > 0;
        int pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)giantShurikenItem);
        int projectileCount = hasMultishot ? 3 : 1;
        float[] shotPitches = GiantShurikenItem.generateShotPitches(level.m_213780_(), projectileCount);
        Vec3 direction = new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20188_() - entity.m_20188_(), target.m_20189_() - entity.m_20189_()).m_82541_();
        float adjustedSpeed = projectileSpeed;
        for (int i = 0; i < projectileCount; ++i) {
            GiantShurikenProjectileEntity projectile = new GiantShurikenProjectileEntity(level, entity, giantShurikenItem.m_41777_());
            projectile.m_5602_((Entity)entity);
            projectile.setPiercingLevel(projectile.getPiercingLevel() + pierceLevel);
            double posX = entity.m_20185_() + direction.f_82479_;
            double posY = entity.m_20188_() + -0.1;
            double posZ = entity.m_20189_() + direction.f_82481_;
            projectile.m_6034_(posX, posY, posZ);
            if (level.m_213780_().m_188501_() < 0.05f) {
                projectile.setCritical(true);
            }
            if (hasMultishot) {
                AbstractArrow.Pickup pickup = projectile.f_36705_ = i == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED;
                if (i != 0) {
                    projectile.getPersistentData().m_128379_("IsMultishotClone", true);
                }
                float spreadAngle = 10.0f;
                float rotation = i == 0 ? 0.0f : (i == 1 ? -spreadAngle : spreadAngle);
                Vec3 upVector = entity.m_20289_(1.0f);
                Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis(rotation * (float)Math.PI / 180.0f, (float)upVector.f_82479_, (float)upVector.f_82480_, (float)upVector.f_82481_);
                Vector3f rotatedVector = new Vector3f((float)direction.f_82479_, (float)direction.f_82480_, (float)direction.f_82481_).rotate((Quaternionfc)rotationQuaternion);
                projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), adjustedSpeed, 1.0f);
            } else {
                projectile.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, adjustedSpeed, 1.0f);
            }
            projectile.setWeaponItem(giantShurikenItem.m_41777_());
            level.m_7967_((Entity)projectile);
            SoundEvent shootSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:giant_shuriken_throw"));
            level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), shootSound != null ? shootSound : SoundEvents.f_12520_, SoundSource.HOSTILE, 1.0f, shotPitches[i]);
        }
        if (giantShurikenItem.m_41613_() > 0) {
            giantShurikenItem.m_41774_(1);
        }
        float recoilDistance = 0.6f;
        ModUtils.applyRecoil((LivingEntity)mob, recoilDistance, 0.3f, 0.4f);
    }
}

