/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import net.jaams.jaams_weaponry.handler.mechanics.BreakingHandler;
import net.jaams.jaams_weaponry.weapons.GreatswordItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GreatswordBehavior {
    private static final float CRITICAL_CHANCE = 0.05f;

    @SubscribeEvent
    public static void onGreatswordEntityAttack(LivingAttackEvent event) {
        Mob mob;
        LivingEntity target;
        block10: {
            block9: {
                Entity attacker = event.getSource().m_7639_();
                target = event.getEntity();
                if (!(attacker instanceof Mob)) break block9;
                mob = (Mob)attacker;
                if (target instanceof LivingEntity) break block10;
            }
            return;
        }
        LivingEntity entity = target;
        ItemStack greatswordItem = mob.m_21205_();
        Item item = greatswordItem.m_41720_();
        if (!(item instanceof GreatswordItem)) {
            return;
        }
        GreatswordItem greatsword = (GreatswordItem)item;
        Level level = entity.m_9236_();
        if (!level.f_46443_) {
            boolean isFullyCharged = true;
            boolean isCritical = level.f_46441_.m_188501_() < 0.05f;
            CompoundTag nbt = greatswordItem.m_41784_();
            int hits = nbt.m_128451_(GreatswordItem.getNbtHitsKey());
            float currentDamageMod = nbt.m_128457_(GreatswordItem.getNbtDamageModKey());
            if (isFullyCharged) {
                float knockbackForce = 0.2f + (float)(++hits) * 0.2f;
                entity.m_147240_((double)knockbackForce, mob.m_20185_() - entity.m_20185_(), mob.m_20189_() - entity.m_20189_());
                float damageChance = 0.3f + (float)hits * 0.3f;
                int damageAmount = 4 + hits * 4;
                if (level.f_46441_.m_188501_() < damageChance) {
                    BreakingHandler.damageHeldItem(entity, damageAmount);
                }
            }
            if (hits >= 3) {
                hits = 0;
                currentDamageMod = 0.0f;
            } else {
                currentDamageMod += 2.5f;
            }
            nbt.m_128405_(GreatswordItem.getNbtHitsKey(), hits);
            nbt.m_128350_(GreatswordItem.getNbtDamageModKey(), currentDamageMod);
            greatswordItem.m_41751_(nbt);
        }
    }
}

