/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import net.jaams.jaams_weaponry.handler.mechanics.BackstabHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HoeBehavior {
    private static final float BACKSTAB_MULTIPLIER_NORMAL = 2.5f;
    private static final float BACKSTAB_MULTIPLIER_SNEAKING = 3.0f;
    private static final float BACKSTAB_MULTIPLIER_INVISIBLE = 3.5f;
    private static final float BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE = 4.0f;
    private static final float BACKSTAB_DURABILITY_PENALTY = 5.0f;
    private static final float WEAKNESS_CHANCE = 0.0f;
    private static final int WEAKNESS_DURATION = 60;
    private static final int WEAKNESS_LEVEL = 1;
    private static final float DARKNESS_BONUS = 1.5f;
    private static final float MOVING_TARGET_PENALTY = 0.5f;
    private static final double BACKSTAB_MAX_DISTANCE = 2.0;
    private static final double BACKSTAB_MAX_ANGLE = Math.toRadians(45.0);
    private static final float CRITICAL_CHANCE = 0.05f;

    @SubscribeEvent
    public static void onHoeEntityAttack(LivingAttackEvent event) {
        Mob mob;
        LivingEntity target;
        block7: {
            block6: {
                Entity attacker = event.getSource().m_7639_();
                target = event.getEntity();
                if (!(attacker instanceof Mob)) break block6;
                mob = (Mob)attacker;
                if (target instanceof LivingEntity) break block7;
            }
            return;
        }
        LivingEntity entity = target;
        ItemStack hoeItem = mob.m_21205_();
        Item item = hoeItem.m_41720_();
        if (!(item instanceof HoeItem)) {
            return;
        }
        HoeItem hoe = (HoeItem)item;
        Level level = entity.m_9236_();
        if (!level.f_46443_) {
            boolean isCritical;
            boolean isBackstab = BackstabHandler.isBackstab((LivingEntity)mob, entity, 2.0, BACKSTAB_MAX_ANGLE);
            float backstabMultiplier = isBackstab ? BackstabHandler.calculateBackstabMultiplier((LivingEntity)mob, entity, level, 2.5f, 3.0f, 3.5f, 4.0f, 1.5f, 0.5f) : 1.0f;
            boolean bl = isCritical = level.f_46441_.m_188501_() < 0.05f;
            if (isBackstab) {
                BackstabHandler.performBackstab((LivingEntity)mob, entity, hoeItem, level, 5.0f, 0.0f, 60, 1, 2.5f, 3.0f, 3.5f, 4.0f, 1.5f, 0.5f);
            }
        }
    }
}

