/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import net.jaams.jaams_weaponry.handler.mechanics.BreakingHandler;
import net.jaams.jaams_weaponry.util.ModTags;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PickaxeBehavior {
    private static final int ARMOR_DAMAGE_AMOUNT = 6;
    private static final float BASE_ARMOR_DAMAGE_CHANCE = 0.5f;
    private static final float CRIT_ARMOR_DAMAGE_CHANCE = 0.75f;
    private static final int DURABILITY_PENALTY = 1;
    private static final int PARTICLE_COUNT = 5;
    private static final float CRITICAL_CHANCE = 0.05f;

    @SubscribeEvent
    public static void onPickaxeEntityAttack(LivingAttackEvent event) {
        Mob mob;
        LivingEntity target;
        Entity attacker;
        block8: {
            block7: {
                attacker = event.getSource().m_7639_();
                target = event.getEntity();
                if (!(attacker instanceof Mob)) break block7;
                mob = (Mob)attacker;
                if (target instanceof LivingEntity) break block8;
            }
            return;
        }
        LivingEntity entity = target;
        Level level = attacker.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        ItemStack weapon = mob.m_21205_();
        if (!weapon.m_204117_(ModTags.PICKAXES)) {
            return;
        }
        boolean isFullyCharged = true;
        boolean isCritical = level.f_46441_.m_188501_() < 0.05f;
        float armorDamageChance = isCritical ? 0.75f : 0.5f;
        boolean damageApplied = false;
        if (level.f_46441_.m_188501_() < armorDamageChance) {
            BreakingHandler.damageArmorPieces(entity, 6, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
            damageApplied = true;
        }
        if (damageApplied && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            weapon.m_41622_(1, (LivingEntity)mob, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            PickaxeBehavior.spawnItemParticles(serverLevel, weapon, entity);
        }
    }

    private static void spawnItemParticles(ServerLevel serverLevel, ItemStack itemStack, LivingEntity entity) {
        for (int i = 0; i < 5; ++i) {
            double xOffset = entity.m_20185_() + (serverLevel.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_();
            double yOffset = entity.m_20186_() + (double)entity.m_20206_() * 0.5 + (serverLevel.f_46441_.m_188500_() - 0.5) * (double)entity.m_20206_() * 0.5;
            double zOffset = entity.m_20189_() + (serverLevel.f_46441_.m_188500_() - 0.5) * (double)entity.m_20205_();
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), xOffset, yOffset, zOffset, 1, 0.1, 0.1, 0.1, 0.05);
        }
    }
}

