/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import net.jaams.jaams_weaponry.item.RoyalSwordItem;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RoyalSwordBehavior {
    private static final float CRITICAL_CHANCE = 0.05f;

    @SubscribeEvent
    public static void onRoyalSwordEntityAttack(LivingAttackEvent event) {
        Mob mob;
        LivingEntity target;
        block17: {
            block16: {
                Entity attacker = event.getSource().m_7639_();
                target = event.getEntity();
                if (!(attacker instanceof Mob)) break block16;
                mob = (Mob)attacker;
                if (target instanceof LivingEntity) break block17;
            }
            return;
        }
        LivingEntity entity = target;
        ItemStack royalSwordItem = mob.m_21205_();
        Item item = royalSwordItem.m_41720_();
        if (!(item instanceof RoyalSwordItem)) {
            return;
        }
        RoyalSwordItem royalSword = (RoyalSwordItem)item;
        Level level = entity.m_9236_();
        if (!level.f_46443_) {
            boolean isFullyCharged = true;
            boolean isCritical = level.f_46441_.m_188501_() < 0.05f;
            float baseDamage = (float)mob.m_21133_(Attributes.f_22281_);
            float totalMultiplier = 1.0f;
            boolean isArmed = ModUtils.isEntityArmed(entity);
            boolean isAggressive = RoyalSwordBehavior.isMobAggressive(entity, (LivingEntity)mob);
            if (isArmed) {
                totalMultiplier *= 1.0f + RoyalSwordItem.ARMED_BONUS_MULTIPLIER;
            }
            if (isAggressive) {
                totalMultiplier *= 1.0f + RoyalSwordItem.AGGRESSIVE_BONUS_MULTIPLIER;
            }
            float bonusDamage = baseDamage * (totalMultiplier - 1.0f);
            ModUtils.applyBonusDamage((LivingEntity)mob, entity, royalSwordItem, bonusDamage);
            if (isArmed && level.f_46441_.m_188501_() < 0.6f) {
                ItemStack mainHandItem = entity.m_21205_();
                ItemStack offHandItem = entity.m_21206_();
                if (ModUtils.isItemWeapon(mainHandItem)) {
                    mainHandItem.m_41622_(6, entity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
                }
                if (ModUtils.isItemWeapon(offHandItem)) {
                    offHandItem.m_41622_(6, entity, e -> e.m_21166_(EquipmentSlot.OFFHAND));
                }
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (isArmed && isAggressive) {
                    serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12313_, SoundSource.HOSTILE, 1.0f, 0.9f);
                } else if (isArmed) {
                    serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12316_, SoundSource.HOSTILE, 1.0f, 1.0f);
                } else if (isAggressive) {
                    serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12313_, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
            }
        }
    }

    private static boolean isMobAggressive(LivingEntity entity, LivingEntity attacker) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob.m_5448_() == attacker;
        }
        return false;
    }
}

