/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import net.jaams.jaams_weaponry.handler.mechanics.PullTowardsHandler;
import net.jaams.jaams_weaponry.item.RusticWhipItem;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RusticWhipBehavior {
    private static final float CRITICAL_CHANCE = 0.05f;

    @SubscribeEvent
    public static void onRusticWhipEntityAttack(LivingAttackEvent event) {
        Mob mob;
        LivingEntity target;
        block8: {
            block7: {
                Entity attacker = event.getSource().m_7639_();
                target = event.getEntity();
                if (!(attacker instanceof Mob)) break block7;
                mob = (Mob)attacker;
                if (target instanceof LivingEntity) break block8;
            }
            return;
        }
        LivingEntity entity = target;
        ItemStack whipItem = mob.m_21205_();
        Item item = whipItem.m_41720_();
        if (!(item instanceof RusticWhipItem)) {
            return;
        }
        RusticWhipItem whip = (RusticWhipItem)item;
        Level level = entity.m_9236_();
        if (!level.f_46443_) {
            boolean isCritical = level.f_46441_.m_188501_() < 0.05f;
            boolean isSneaking = mob.m_6144_();
            ModUtils.playSound((Entity)entity, "jaams_weaponry:whip_hit");
            ModUtils.cancelDamage(entity, (LivingEntity)mob);
            PullTowardsHandler.pullEnemyTowardsPlayer(entity, (LivingEntity)mob, 1.0f, whipItem, 2.5f, 6.0f, 0.8, 0.6f, 0.1, 0.5f, 0.3f, 0.75f, 0);
            float baseDisarmChance = isSneaking ? 0.25f : 0.15f;
            float disarmChance = isCritical ? baseDisarmChance * 1.5f : baseDisarmChance;
            whip.handleDisarm(entity, (LivingEntity)mob, whipItem, disarmChance);
            float baseDismountChance = isSneaking ? 0.3f : 0.15f;
            float dismountChance = isCritical ? baseDismountChance * 2.0f : baseDismountChance;
            whip.handleDismount(entity, (LivingEntity)mob, whipItem, dismountChance);
            Level level2 = entity.m_9236_();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                if (entity.m_5842_()) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 4, 0.1, 0.1, 0.1, 0.0);
                }
            }
        }
    }
}

