/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.guns.shoot.ScattergunShoot;
import net.jaams.jaams_weaponry.guns.util.GunUtils;
import net.jaams.jaams_weaponry.handler.guns.GunActionsHandler;
import net.jaams.jaams_weaponry.handler.guns.GunSoundHandler;
import net.jaams.jaams_weaponry.handler.guns.GunStorageHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEnchantments;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.jaams.jaams_weaponry.weapons.GunBaseItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_weaponry")
public class ScattergunBehavior {
    private static final double SCATTERGUN_SHOOT_PROBABILITY = 0.5;
    private static final long SCATTERGUN_PAUSE_AFTER_SHOOT = 35L;
    private static final double SCATTERGUN_MIN_SHOOT_DISTANCE = 2.0;
    private static final double SCATTERGUN_MAX_SHOOT_DISTANCE = 35.0;
    private static final double SCATTERGUN_DISTANCE_VARIATION = 0.1;
    private static final double SCATTERGUN_MIN_DOT_PRODUCT = 0.5;
    private static final float SCATTERGUN_PROJECTILE_Y_OFFSET = -0.1f;
    private static final int TRAJECTORY_CHECK_STEPS = 10;
    private static final long EMPTY_SOUND_COOLDOWN = 80L;
    private static final Map<UUID, Long> SCATTERGUN_LAST_SHOOT_TIME = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Long> SCATTERGUN_LAST_EMPTY_SOUND_TIME = new ConcurrentHashMap<UUID, Long>();

    @SubscribeEvent
    public static void onScattergunEntityUpdate(LivingEvent.LivingTickEvent event) {
        double maxShootDistance;
        RandomSource random;
        double minShootDistance;
        Mob mob;
        LivingEntity entity;
        block13: {
            block12: {
                entity = event.getEntity();
                if (entity.m_9236_().f_46443_ || !entity.m_6084_() || !(entity instanceof Mob)) break block12;
                mob = (Mob)entity;
                if (!(entity instanceof Player)) break block13;
            }
            return;
        }
        Level level = entity.m_9236_();
        ItemStack scattergunItem = ModUtils.getItemInEitherHand(entity, stack -> stack != null && stack.m_41720_() instanceof GunBaseItem && stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("jaams_weaponry:scatterguns"))));
        if (scattergunItem == null || scattergunItem.m_41619_() || scattergunItem.m_41773_() >= scattergunItem.m_41776_() - 1) {
            return;
        }
        long currentTime = level.m_46467_();
        if (level.m_213780_().m_188500_() >= 0.5 || (double)(currentTime - SCATTERGUN_LAST_SHOOT_TIME.getOrDefault(entity.m_20148_(), 0L)) < 50.0 || ModUtils.hasRestrictedEffect(entity)) {
            return;
        }
        LivingEntity target = mob.m_5448_();
        if (!ScattergunBehavior.canShootAtTarget(entity, target, level, minShootDistance = 2.0 * (0.9 + (random = level.m_213780_()).m_188500_() * 2.0 * 0.1), maxShootDistance = 35.0 * (0.9 + random.m_188500_() * 2.0 * 0.1))) {
            if (currentTime > SCATTERGUN_LAST_SHOOT_TIME.getOrDefault(entity.m_20148_(), 0L)) {
                mob.m_21573_().m_26569_();
            }
            return;
        }
        boolean fromGun = (Boolean)JaamsWeaponryCommonConfiguration.AMMOFROMGUN.get();
        boolean fromHand = (Boolean)JaamsWeaponryCommonConfiguration.AMMOFROMHAND.get();
        boolean mobsNeedAmmo = (Boolean)JaamsWeaponryCommonConfiguration.MOBSNEEDAMMO.get();
        ItemStack bulletItem = ScattergunBehavior.getBulletForScattergun(entity, scattergunItem, fromGun, fromHand);
        if (bulletItem.m_41619_()) {
            if (mobsNeedAmmo) {
                if (currentTime - SCATTERGUN_LAST_EMPTY_SOUND_TIME.getOrDefault(entity.m_20148_(), 0L) >= 80L) {
                    InteractionHand hand = scattergunItem == entity.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                    entity.m_21011_(hand, true);
                    GunSoundHandler.playScattergunEmptySound((LevelAccessor)level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (Entity)entity, scattergunItem);
                    SCATTERGUN_LAST_EMPTY_SOUND_TIME.put(entity.m_20148_(), currentTime);
                }
                return;
            }
            InteractionHand hand = scattergunItem == entity.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            entity.m_21011_(hand, true);
            ItemStack defaultBullet = entity instanceof Piglin || entity instanceof ZombifiedPiglin || entity instanceof PiglinBrute ? new ItemStack((ItemLike)JaamsWeaponryModItems.FIRE_BULLET.get()) : new ItemStack((ItemLike)JaamsWeaponryModItems.BULLET.get());
            ScattergunBehavior.shootScattergun(entity, scattergunItem, defaultBullet, target, mob, level, false, false);
            SCATTERGUN_LAST_SHOOT_TIME.put(entity.m_20148_(), currentTime + 35L + 50L);
            mob.m_21573_().m_26573_();
            return;
        }
        if (bulletItem.m_41613_() < 2) {
            if (currentTime - SCATTERGUN_LAST_EMPTY_SOUND_TIME.getOrDefault(entity.m_20148_(), 0L) >= 80L) {
                InteractionHand hand = scattergunItem == entity.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                entity.m_21011_(hand, true);
                GunSoundHandler.playScattergunOneBulletSound((LevelAccessor)level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (Entity)entity, scattergunItem);
                SCATTERGUN_LAST_EMPTY_SOUND_TIME.put(entity.m_20148_(), currentTime);
            }
            return;
        }
        double distanceToTarget = entity.m_20270_((Entity)target);
        long scaledCooldown = 50L + (long)(distanceToTarget * 2.0);
        ScattergunBehavior.shootScattergun(entity, scattergunItem, bulletItem, target, mob, level, fromGun, fromHand);
        SCATTERGUN_LAST_SHOOT_TIME.put(entity.m_20148_(), currentTime + 35L + scaledCooldown);
        mob.m_21573_().m_26573_();
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && !((entity = (LivingEntity)entity2) instanceof Player)) {
            SCATTERGUN_LAST_SHOOT_TIME.remove(entity.m_20148_());
            SCATTERGUN_LAST_EMPTY_SOUND_TIME.remove(entity.m_20148_());
        }
    }

    private static boolean canShootAtTarget(LivingEntity entity, LivingEntity target, Level level, double minShootDistance, double maxShootDistance) {
        Vec3 entityLookDirection;
        if (target == null || !target.m_6084_()) {
            return false;
        }
        double distanceToTarget = entity.m_20270_((Entity)target);
        if (distanceToTarget < minShootDistance || distanceToTarget > maxShootDistance) {
            return false;
        }
        Vec3 directionToTarget = new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20188_() - entity.m_20188_(), target.m_20189_() - entity.m_20189_()).m_82541_();
        double angle = directionToTarget.m_82526_(entityLookDirection = entity.m_20154_().m_82541_());
        if (angle <= 0.5) {
            return false;
        }
        return ScattergunBehavior.simulateProjectilePath(entity, target, level, directionToTarget);
    }

    private static boolean simulateProjectilePath(LivingEntity entity, LivingEntity target, Level level, Vec3 direction) {
        Vec3 currentPos = new Vec3(entity.m_20185_() + direction.f_82479_, entity.m_20188_() + (double)-0.1f, entity.m_20189_() + direction.f_82481_);
        Vec3 targetPos = target.m_146892_();
        double totalDistance = currentPos.m_82554_(targetPos);
        double stepSize = totalDistance / 10.0;
        for (int i = 1; i <= 10; ++i) {
            double t = (double)i * stepSize;
            Vec3 checkPos = currentPos.m_82549_(direction.m_82490_(t));
            ClipContext clipContext = new ClipContext(currentPos, checkPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
            if (level.m_45547_(clipContext).m_6662_() != HitResult.Type.MISS) {
                return false;
            }
            if (checkPos.m_82554_(targetPos) < 0.5) {
                return true;
            }
            currentPos = checkPos;
        }
        ClipContext finalCheck = new ClipContext(currentPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return level.m_45547_(finalCheck).m_6662_() == HitResult.Type.MISS;
    }

    private static ItemStack getBulletForScattergun(LivingEntity entity, ItemStack scattergunItem, boolean fromGun, boolean fromHand) {
        ItemStack offHandItem;
        ItemStack bulletFromGun;
        ItemStack itemStack = bulletFromGun = fromGun ? GunUtils.getBulletFromGun(scattergunItem, false) : ItemStack.f_41583_;
        if (!bulletFromGun.m_41619_()) {
            return bulletFromGun;
        }
        ItemStack itemStack2 = offHandItem = fromHand ? entity.m_21206_() : ItemStack.f_41583_;
        if (!offHandItem.m_41619_() && offHandItem.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("jaams_weaponry:bullets")))) {
            return offHandItem;
        }
        return ItemStack.f_41583_;
    }

    private static void shootScattergun(LivingEntity entity, ItemStack scattergunItem, ItemStack bulletItem, LivingEntity target, Mob mob, Level level, boolean fromGun, boolean fromHand) {
        String messageKey;
        double inaccuracy;
        double speed;
        int piercing;
        double knockback;
        double damage;
        EntityType projectileType;
        InteractionHand hand = scattergunItem == entity.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        entity.m_21011_(hand, true);
        double muzzle = GunUtils.getItemStack(scattergunItem, 0).m_41720_() == ScattergunShoot.MUZZLE_ATTACHMENT ? 1.5 : 0.0;
        double magazineModifier = GunUtils.getItemStack(scattergunItem, 2).m_41720_() == ScattergunShoot.MAGAZINE_ATTACHMENT ? 2.0 : 1.0;
        double cooldown = 50.0;
        if (bulletItem.m_41720_() == JaamsWeaponryModItems.BULLET.get()) {
            projectileType = (EntityType)JaamsWeaponryModEntities.BULLET_PROJECTILE.get();
            damage = 6.0;
            knockback = 0.5;
            piercing = 0;
            speed = 4.5;
            inaccuracy = 0.0;
            messageKey = "message.gun.bullets";
        } else if (bulletItem.m_41720_() == JaamsWeaponryModItems.FIRE_BULLET.get()) {
            projectileType = (EntityType)JaamsWeaponryModEntities.FIRE_BULLET_PROJECTILE.get();
            damage = 6.0;
            knockback = 0.5;
            piercing = 0;
            speed = 4.5;
            inaccuracy = 0.0;
            messageKey = "message.gun.fire_bullets";
        } else if (bulletItem.m_41720_() == JaamsWeaponryModItems.HEAVY_BULLET.get()) {
            projectileType = (EntityType)JaamsWeaponryModEntities.HEAVY_BULLET_PROJECTILE.get();
            damage = 10.0;
            knockback = 1.0;
            piercing = 0;
            speed = 2.2;
            inaccuracy = 0.0;
            cooldown += 20.0;
            messageKey = "message.gun.heavy_bullets";
        } else if (bulletItem.m_41720_() == JaamsWeaponryModItems.GLOWING_BULLET.get()) {
            projectileType = (EntityType)JaamsWeaponryModEntities.GLOWING_BULLET_PROJECTILE.get();
            damage = 5.0;
            knockback = 0.5;
            piercing = 0;
            speed = 4.5;
            inaccuracy = 0.0;
            messageKey = "message.gun.glowing_bullets";
        } else if (bulletItem.m_41720_() == JaamsWeaponryModItems.ECHO_BULLET.get()) {
            projectileType = (EntityType)JaamsWeaponryModEntities.ECHO_BULLET_PROJECTILE.get();
            damage = 5.0;
            knockback = 0.5;
            piercing = 0;
            speed = 4.5;
            inaccuracy = 0.0;
            messageKey = "message.gun.echo_bullets";
        } else if (bulletItem.m_41720_() == JaamsWeaponryModItems.SHARP_BULLET.get()) {
            projectileType = (EntityType)JaamsWeaponryModEntities.SHARP_BULLET_PROJECTILE.get();
            damage = 5.0;
            knockback = 0.2;
            piercing = 3;
            speed = 4.5;
            inaccuracy = 0.0;
            messageKey = "message.gun.sharp_bullets";
        } else {
            return;
        }
        GunActionsHandler.handleGunShot((LevelAccessor)level, (Entity)entity, scattergunItem, 1.2f, 1.2f);
        int cooldownTicks = (int)(cooldown / magazineModifier);
        GunUtils.shootProjectilesAndSound((LevelAccessor)level, (Entity)entity, scattergunItem, muzzle, speed, (EntityType<? extends AbstractArrow>)projectileType, damage, knockback, piercing, inaccuracy, 2, 5.0f, GunSoundHandler::playScattergunAttachmentSound);
        boolean consumeAmmo = true;
        int ghostClipLevel = scattergunItem.getEnchantmentLevel((Enchantment)JaamsWeaponryModEnchantments.GHOST_CLIP.get());
        if (ghostClipLevel > 0) {
            double noConsumeChance = 0.15 * (double)ghostClipLevel;
            if (level.m_213780_().m_188500_() < noConsumeChance) {
                consumeAmmo = false;
            }
        }
        if (consumeAmmo) {
            if (fromGun && bulletItem == GunUtils.getBulletFromGun(scattergunItem, false)) {
                GunStorageHandler.handleScattergun(scattergunItem);
            } else if (fromHand && bulletItem == entity.m_21206_()) {
                bulletItem.m_41774_(2);
                cooldownTicks += 20;
            }
        }
        GunUtils.updateGunState((LevelAccessor)level, (Entity)entity, scattergunItem, messageKey, 0.15);
        GunUtils.applyPhysicalRecoil((LivingEntity)mob, scattergunItem, 0.8f, 0.6f, 0.45f);
    }
}

