/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.jaams.jaams_weaponry.entity.ShurikenProjectileEntity;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.item.ShurikenItem;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class ShurikenBehavior {
    private static final double SHURIKEN_THROW_PROBABILITY = 0.5;
    private static final long SHURIKEN_BASE_THROW_COOLDOWN = 60L;
    private static final long SHURIKEN_PAUSE_AFTER_THROW = 20L;
    private static final float SHURIKEN_BASE_PROJECTILE_SPEED = 2.0f;
    private static final float SHURIKEN_PROJECTILE_INACCURACY = 1.0f;
    private static final double SHURIKEN_BASE_MIN_THROW_DISTANCE = 6.0;
    private static final double SHURIKEN_BASE_MAX_THROW_DISTANCE = 29.0;
    private static final double SHURIKEN_DISTANCE_VARIATION = 0.15;
    private static final double SHURIKEN_MIN_DOT_PRODUCT = 0.5;
    private static final double SHURIKEN_PROJECTILE_Y_OFFSET = -0.1;
    private static final int TRAJECTORY_CHECK_STEPS = 10;
    private static final float SPEED_SCALE_FACTOR = 0.05f;
    private static final long COOLDOWN_SCALE_FACTOR = 5L;
    private static final float CRITICAL_CHANCE = 0.05f;
    private static final Map<UUID, Long> SHURIKEN_LAST_THROW_TIME = new ConcurrentHashMap<UUID, Long>();

    @SubscribeEvent
    public static void onShurikenEntityUpdate(LivingEvent.LivingTickEvent event) {
        double maxThrowDistance;
        RandomSource random;
        double minThrowDistance;
        Mob mob;
        LivingEntity entity;
        block8: {
            block7: {
                entity = event.getEntity();
                if (entity.m_9236_().f_46443_ || !entity.m_6084_() || !(entity instanceof Mob)) break block7;
                mob = (Mob)entity;
                if (!(entity instanceof Player)) break block8;
            }
            return;
        }
        Level level = entity.m_9236_();
        ItemStack shurikenItem = ModUtils.getItemInEitherHand(entity, stack -> stack != null && stack.m_41720_() == JaamsWeaponryModItems.SHURIKEN.get());
        if (shurikenItem == null || shurikenItem.m_41619_()) {
            return;
        }
        long currentTime = level.m_46467_();
        if (level.m_213780_().m_188500_() >= 0.5 || currentTime - SHURIKEN_LAST_THROW_TIME.getOrDefault(entity.m_20148_(), 0L) < 60L || ModUtils.hasRestrictedEffect(entity)) {
            return;
        }
        LivingEntity target = mob.m_5448_();
        if (!ShurikenBehavior.canThrowAtTarget(entity, target, level, minThrowDistance = 6.0 * (0.85 + (random = level.m_213780_()).m_188500_() * 2.0 * 0.15), maxThrowDistance = 29.0 * (0.85 + random.m_188500_() * 2.0 * 0.15))) {
            if (currentTime > SHURIKEN_LAST_THROW_TIME.getOrDefault(entity.m_20148_(), 0L)) {
                mob.m_21573_().m_26569_();
            }
            return;
        }
        double distanceToTarget = entity.m_20270_((Entity)target);
        float scaledProjectileSpeed = 2.0f + (float)(distanceToTarget * (double)0.05f);
        long scaledCooldown = 60L + (long)(distanceToTarget * 5.0);
        ShurikenBehavior.throwShuriken(entity, shurikenItem, target, mob, level, scaledProjectileSpeed);
        SHURIKEN_LAST_THROW_TIME.put(entity.m_20148_(), currentTime + 20L + scaledCooldown);
        mob.m_21573_().m_26573_();
    }

    @SubscribeEvent
    public static void onShurikenEntityAttack(LivingAttackEvent event) {
        Mob mob;
        block5: {
            block4: {
                Entity attacker = event.getSource().m_7639_();
                LivingEntity target = event.getEntity();
                if (!(attacker instanceof Mob)) break block4;
                mob = (Mob)attacker;
                if (target instanceof LivingEntity && !(attacker instanceof Player)) break block5;
            }
            return;
        }
        ItemStack shurikenItem = mob.m_21205_();
        if (!(shurikenItem.m_41720_() instanceof ShurikenItem)) {
            return;
        }
        ModUtils.handleItemBreak(shurikenItem, (LivingEntity)mob, 0.3f, 5, "minecraft:item.shield.break");
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && !((entity = (LivingEntity)entity2) instanceof Player)) {
            SHURIKEN_LAST_THROW_TIME.remove(entity.m_20148_());
        }
    }

    private static boolean canThrowAtTarget(LivingEntity entity, LivingEntity target, Level level, double minThrowDistance, double maxThrowDistance) {
        Vec3 entityLookDirection;
        if (target == null || !target.m_6084_()) {
            return false;
        }
        double distanceToTarget = entity.m_20270_((Entity)target);
        if (distanceToTarget < minThrowDistance || distanceToTarget > maxThrowDistance) {
            return false;
        }
        Vec3 directionToTarget = new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20188_() - entity.m_20188_(), target.m_20189_() - entity.m_20189_()).m_82541_();
        double angle = directionToTarget.m_82526_(entityLookDirection = entity.m_20154_().m_82541_());
        if (angle <= 0.5) {
            return false;
        }
        return ShurikenBehavior.simulateProjectilePath(entity, target, level, directionToTarget);
    }

    private static boolean simulateProjectilePath(LivingEntity entity, LivingEntity target, Level level, Vec3 direction) {
        Vec3 currentPos = new Vec3(entity.m_20185_() + direction.f_82479_, entity.m_20188_() + -0.1, entity.m_20189_() + direction.f_82481_);
        Vec3 targetPos = target.m_146892_();
        double totalDistance = currentPos.m_82554_(targetPos);
        double stepSize = totalDistance / 10.0;
        for (int i = 1; i <= 10; ++i) {
            double t = (double)i * stepSize;
            Vec3 checkPos = currentPos.m_82549_(direction.m_82490_(t));
            ClipContext clipContext = new ClipContext(currentPos, checkPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
            if (level.m_45547_(clipContext).m_6662_() != HitResult.Type.MISS) {
                return false;
            }
            if (checkPos.m_82554_(targetPos) < 0.5) {
                return true;
            }
            currentPos = checkPos;
        }
        ClipContext finalCheck = new ClipContext(currentPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return level.m_45547_(finalCheck).m_6662_() == HitResult.Type.MISS;
    }

    private static void throwShuriken(LivingEntity entity, ItemStack shurikenItem, LivingEntity target, Mob mob, Level level, float projectileSpeed) {
        InteractionHand hand = shurikenItem == entity.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        entity.m_21011_(hand, true);
        ShurikenProjectileEntity projectile = new ShurikenProjectileEntity((EntityType<? extends ShurikenProjectileEntity>)((EntityType)JaamsWeaponryModEntities.SHURIKEN_PROJECTILE.get()), entity, level, shurikenItem.m_41777_());
        projectile.m_5602_((Entity)entity);
        Vec3 direction = new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20188_() - entity.m_20188_(), target.m_20189_() - entity.m_20189_()).m_82541_();
        projectile.m_6034_(entity.m_20185_() + direction.f_82479_, entity.m_20188_() + -0.1, entity.m_20189_() + direction.f_82481_);
        projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, projectileSpeed, 1.0f);
        if (level.m_213780_().m_188501_() < 0.05f) {
            projectile.setCritical(true);
        }
        level.m_7967_((Entity)projectile);
        if (shurikenItem.m_41613_() > 0) {
            shurikenItem.m_41774_(1);
        }
        SoundEvent shootSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:shuriken_throw"));
        level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), shootSound != null ? shootSound : SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

