/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.jaams.jaams_weaponry.entity.SlingshotProjectileEntity;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModSounds;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.jaams.jaams_weaponry.weapons.SlingshotItem;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Mod.EventBusSubscriber
public class SlingshotBehavior {
    private static final double SLINGSHOT_THROW_PROBABILITY = 0.75;
    private static final long SLINGSHOT_BASE_THROW_COOLDOWN = 30L;
    private static final long SLINGSHOT_PAUSE_AFTER_THROW = 20L;
    private static final double SLINGSHOT_BASE_MIN_THROW_DISTANCE = 0.5;
    private static final double SLINGSHOT_BASE_MAX_THROW_DISTANCE = 20.0;
    private static final double SLINGSHOT_DISTANCE_VARIATION = 0.15;
    private static final double SLINGSHOT_MIN_DOT_PRODUCT = 0.5;
    private static final double SLINGSHOT_PROJECTILE_Y_OFFSET = -0.1;
    private static final int TRAJECTORY_CHECK_STEPS = 10;
    private static final float SLINGSHOT_BASE_PROJECTILE_SPEED = 0.5f;
    private static final float SLINGSHOT_MAX_PROJECTILE_SPEED = 2.5f;
    private static final float SPEED_SCALE_FACTOR = 0.05f;
    private static final long COOLDOWN_SCALE_FACTOR = 5L;
    private static final Map<UUID, Long> SLINGSHOT_LAST_THROW_TIME = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Integer> SLINGSHOT_CHARGE_TIME = new ConcurrentHashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onSlingshotEntityUpdate(LivingEvent.LivingTickEvent event) {
        double maxThrowDistance;
        double minThrowDistance;
        ItemStack ammo;
        Mob mob;
        LivingEntity entity;
        block11: {
            block10: {
                entity = event.getEntity();
                if (entity.m_9236_().f_46443_ || !entity.m_6084_() || !(entity instanceof Mob)) break block10;
                mob = (Mob)entity;
                if (!(entity instanceof Player)) break block11;
            }
            return;
        }
        Level level = entity.m_9236_();
        ItemStack slingshotItem = ModUtils.getItemInEitherHand(entity, stack -> stack != null && stack.m_41720_() instanceof SlingshotItem);
        if (slingshotItem == null || slingshotItem.m_41619_()) {
            return;
        }
        long currentTime = level.m_46467_();
        UUID entityUUID = entity.m_20148_();
        SlingshotItem slingshot = (SlingshotItem)slingshotItem.m_41720_();
        if (!slingshot.isAmmoItem(ammo = entity.m_21120_(InteractionHand.OFF_HAND))) {
            ammo = entity instanceof Piglin || entity instanceof PiglinBrute || entity instanceof ZombifiedPiglin ? new ItemStack((ItemLike)Items.f_42755_) : slingshot.getDefaultCreativeAmmo();
        }
        if (ammo.m_41619_() || level.m_213780_().m_188500_() >= 0.75 || currentTime - SLINGSHOT_LAST_THROW_TIME.getOrDefault(entityUUID, 0L) < 30L) {
            return;
        }
        LivingEntity target = mob.m_5448_();
        if (!SlingshotBehavior.canThrowAtTarget(entity, target, level, minThrowDistance = 0.5 * (0.85 + level.m_213780_().m_188500_() * 2.0 * 0.15), maxThrowDistance = 20.0 * (0.85 + level.m_213780_().m_188500_() * 2.0 * 0.15))) {
            if (currentTime > SLINGSHOT_LAST_THROW_TIME.getOrDefault(entityUUID, 0L)) {
                mob.m_21573_().m_26569_();
            }
            return;
        }
        int chargeTime = SLINGSHOT_CHARGE_TIME.getOrDefault(entityUUID, 0);
        if (chargeTime == 0) {
            entity.m_6672_(InteractionHand.MAIN_HAND);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)JaamsWeaponryModSounds.SLINGSHOT_LOAD.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        SLINGSHOT_CHARGE_TIME.put(entityUUID, ++chargeTime);
        if (chargeTime >= 20) {
            double distanceToTarget = entity.m_20270_((Entity)target);
            float power = SlingshotItem.getPowerForTime(chargeTime);
            float scaledProjectileSpeed = 0.5f + 2.0f * power + (float)(distanceToTarget * (double)0.05f);
            long scaledCooldown = 30L + (long)(distanceToTarget * 5.0);
            SlingshotBehavior.throwSlingshot(entity, slingshotItem, ammo, target, mob, level, scaledProjectileSpeed, slingshot);
            SLINGSHOT_LAST_THROW_TIME.put(entityUUID, currentTime + 20L + scaledCooldown);
            SLINGSHOT_CHARGE_TIME.remove(entityUUID);
            mob.m_21573_().m_26573_();
            entity.m_5810_();
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && !((entity = (LivingEntity)entity2) instanceof Player)) {
            SLINGSHOT_LAST_THROW_TIME.remove(entity.m_20148_());
            SLINGSHOT_CHARGE_TIME.remove(entity.m_20148_());
        }
    }

    private static boolean canThrowAtTarget(LivingEntity entity, LivingEntity target, Level level, double minThrowDistance, double maxThrowDistance) {
        Vec3 entityLookDirection;
        if (target == null || !target.m_6084_()) {
            return false;
        }
        double distanceToTarget = entity.m_20270_((Entity)target);
        if (distanceToTarget < minThrowDistance || distanceToTarget > maxThrowDistance) {
            return false;
        }
        Vec3 directionToTarget = new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20188_() - entity.m_20188_(), target.m_20189_() - entity.m_20189_()).m_82541_();
        double angle = directionToTarget.m_82526_(entityLookDirection = entity.m_20154_().m_82541_());
        if (angle <= 0.5) {
            return false;
        }
        return SlingshotBehavior.simulateProjectilePath(entity, target, level, directionToTarget);
    }

    private static boolean simulateProjectilePath(LivingEntity entity, LivingEntity target, Level level, Vec3 direction) {
        Vec3 currentPos = new Vec3(entity.m_20185_() + direction.f_82479_, entity.m_20188_() + -0.1, entity.m_20189_() + direction.f_82481_);
        Vec3 targetPos = target.m_146892_();
        double totalDistance = currentPos.m_82554_(targetPos);
        double stepSize = totalDistance / 10.0;
        for (int i = 1; i <= 10; ++i) {
            double t = (double)i * stepSize;
            Vec3 checkPos = currentPos.m_82549_(direction.m_82490_(t));
            ClipContext clipContext = new ClipContext(currentPos, checkPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
            if (level.m_45547_(clipContext).m_6662_() != HitResult.Type.MISS) {
                return false;
            }
            if (checkPos.m_82554_(targetPos) < 0.5) {
                return true;
            }
            currentPos = checkPos;
        }
        ClipContext finalCheck = new ClipContext(currentPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        return level.m_45547_(finalCheck).m_6662_() == HitResult.Type.MISS;
    }

    private static void throwSlingshot(LivingEntity entity, ItemStack slingshotItem, ItemStack ammo, LivingEntity target, Mob mob, Level level, float projectileSpeed, SlingshotItem slingshot) {
        InteractionHand hand = slingshotItem == entity.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        entity.m_21011_(hand, true);
        boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)slingshotItem) > 0;
        int projectileCount = hasMultishot ? 3 : 1;
        float[] shotPitches = SlingshotItem.generateShotPitches(level.m_213780_(), projectileCount);
        for (int i = 0; i < projectileCount; ++i) {
            int pierceLevel;
            int flameLevel;
            int punchLevel;
            SlingshotProjectileEntity projectile = slingshot.createProjectile(level, entity);
            projectile.m_5602_((Entity)entity);
            Vec3 direction = new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20188_() - entity.m_20188_(), target.m_20189_() - entity.m_20189_()).m_82541_();
            projectile.m_6034_(entity.m_20185_() + direction.f_82479_, entity.m_20188_() + -0.1, entity.m_20189_() + direction.f_82481_);
            if (hasMultishot) {
                float spreadAngle = 10.0f;
                float rotation = i == 0 ? 0.0f : (i == 1 ? -spreadAngle : spreadAngle);
                Vec3 upVector = entity.m_20289_(1.0f);
                Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis((double)(rotation * (float)Math.PI / 180.0f), upVector.f_82479_, upVector.f_82480_, upVector.f_82481_);
                Vector3f rotatedVector = direction.m_252839_().rotate((Quaternionfc)rotationQuaternion);
                projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), projectileSpeed, 1.0f);
                projectile.getPersistentData().m_128379_("CanPlaceBlock", i == 0);
                AbstractArrow.Pickup pickup = projectile.f_36705_ = i == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED;
                if (i != 0) {
                    projectile.getPersistentData().m_128379_("BreakOnBlockHit", true);
                }
            } else {
                projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, projectileSpeed, 1.0f);
                projectile.getPersistentData().m_128379_("CanPlaceBlock", true);
                projectile.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            }
            float damage = slingshot.getProjectileDamage(ammo);
            if (level.m_213780_().m_188501_() < 0.05f) {
                projectile.setCritical(true);
                damage += 2.0f;
            }
            projectile.setBlockDamage(damage);
            projectile.setBlockItem(ammo.m_41777_());
            projectile.setBlockKnockback(0.5f);
            int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)slingshotItem);
            if (powerLevel > 0) {
                projectile.setBlockDamage(damage += (float)powerLevel * 0.5f + 0.5f);
            }
            if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)slingshotItem)) > 0) {
                projectile.setBlockKnockback(0.5f + (float)punchLevel * 0.3f);
            }
            if ((flameLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)slingshotItem)) > 0) {
                projectile.m_20254_(60);
            }
            if ((pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)slingshotItem)) > 0) {
                projectile.setPiercingLevel(pierceLevel);
            }
            level.m_7967_((Entity)projectile);
            level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), (SoundEvent)JaamsWeaponryModSounds.SLINGSHOT_SHOOT.get(), SoundSource.HOSTILE, 1.0f, shotPitches[i]);
        }
    }
}

