/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.jaams.jaams_weaponry.handler.events.AttackTrackerHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.item.SmokeBombItem;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SmokeBombBehavior {
    private static final float SMOKE_BOMB_USE_PROBABILITY = 0.3f;
    private static final float SMOKE_BOMB_ATTACK_PROBABILITY = 0.5f;
    private static final float SMOKE_BOMB_HURT_PROBABILITY = 0.5f;
    private static final float SMOKE_BOMB_BLINDNESS_PROBABILITY = 0.5f;
    private static final int SMOKE_BOMB_COOLDOWN = 200;
    private static final int SMOKE_BOMB_PARTICLE_COUNT = 80;
    private static final float SMOKE_BOMB_PARTICLE_RANGE = 2.5f;
    private static final float CRITICAL_CHANCE = 0.05f;
    private static final Map<UUID, Integer> SMOKE_BOMB_COOLDOWN_MAP = new ConcurrentHashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onSmokeBombEntityUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity target;
        int adjustedCooldown;
        LivingEntity entity = event.getEntity();
        if (!entity.m_6084_() || entity.m_9236_().f_46443_ || entity instanceof Player) {
            if (!entity.m_6084_()) {
                SMOKE_BOMB_COOLDOWN_MAP.remove(entity.m_20148_());
            }
            return;
        }
        UUID entityId = entity.m_20148_();
        int currentCooldown = SMOKE_BOMB_COOLDOWN_MAP.getOrDefault(entityId, 0);
        int n = adjustedCooldown = (double)entity.m_21223_() < (double)entity.m_21233_() * 0.3 ? 100 : 200;
        if (currentCooldown > 0) {
            SMOKE_BOMB_COOLDOWN_MAP.put(entityId, currentCooldown - 1);
            return;
        }
        LivingEntity livingEntity = target = entity instanceof Mob ? ((Mob)entity).m_5448_() : null;
        if (target == null) {
            return;
        }
        float adjustedProbability = SmokeBombBehavior.calculateSmokeBombProbability(entity, target, entityId);
        if (entity.m_9236_().m_213780_().m_188501_() > adjustedProbability) {
            return;
        }
        ItemStack smokeBombItem = ModUtils.getItemInEitherHand(entity, (Item)JaamsWeaponryModItems.SMOKE_BOMB.get());
        if (smokeBombItem == null || smokeBombItem.m_41619_()) {
            return;
        }
        if (ModUtils.hasRestrictedEffect(entity)) {
            return;
        }
        InteractionHand hand = smokeBombItem == entity.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        SmokeBombBehavior.useSmokeBomb(entity, smokeBombItem, hand);
        SMOKE_BOMB_COOLDOWN_MAP.put(entityId, adjustedCooldown);
    }

    @SubscribeEvent
    public static void onAttackWithSmokeBomb(LivingAttackEvent event) {
        LivingEntity attacker;
        block5: {
            block4: {
                Entity entity = event.getSource().m_7639_();
                if (!(entity instanceof LivingEntity)) break block4;
                attacker = (LivingEntity)entity;
                if (!attacker.m_9236_().f_46443_ && !(attacker instanceof Player)) break block5;
            }
            return;
        }
        ItemStack mainHandItem = ModUtils.getItemInMainHand(attacker, (Item)JaamsWeaponryModItems.SMOKE_BOMB.get());
        if (!mainHandItem.m_41619_() && attacker.m_9236_().m_213780_().m_188501_() <= 0.5f) {
            SmokeBombBehavior.useSmokeBomb(attacker, mainHandItem, InteractionHand.MAIN_HAND);
        }
    }

    @SubscribeEvent
    public static void onSmokeBombEntityHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_ || entity instanceof Player || event.getSource().m_7639_() == null || entity.m_9236_().m_213780_().m_188501_() > 0.5f) {
            return;
        }
        ItemStack smokeBombItem = ModUtils.getItemInEitherHand(entity, (Item)JaamsWeaponryModItems.SMOKE_BOMB.get());
        if (!smokeBombItem.m_41619_()) {
            InteractionHand hand = smokeBombItem == entity.m_21205_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            SmokeBombBehavior.useSmokeBomb(entity, smokeBombItem, hand);
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && !((entity = (LivingEntity)entity2) instanceof Player)) {
            SMOKE_BOMB_COOLDOWN_MAP.remove(entity.m_20148_());
        }
    }

    private static float calculateSmokeBombProbability(LivingEntity entity, LivingEntity target, UUID entityId) {
        float probability = 0.3f;
        if ((double)entity.m_21223_() < (double)entity.m_21233_() * 0.3) {
            probability = 0.8f;
        } else if ((double)entity.m_20270_((Entity)target) < 1.5) {
            probability = 0.6f;
        }
        if (AttackTrackerHandler.getAndClearRecentAttack(entityId)) {
            probability += 0.2f;
        }
        return probability;
    }

    private static void useSmokeBomb(LivingEntity entity, ItemStack smokeBombItem, InteractionHand hand) {
        entity.m_6674_(hand);
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        Vec3 center = new Vec3(x, y, z);
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SmokeBombBehavior.spawnSmokeParticles(serverLevel, entity, x, y, z);
        }
        SmokeBombItem.applyDynamicPush((Entity)entity, 1.5f, 0.8f);
        ModUtils.playSound((Entity)entity, "jaams_weaponry:smoke_bomb", SoundSource.AMBIENT);
        SmokeBombBehavior.applyBlindnessToNearbyEntities(entity, center);
        smokeBombItem.m_41774_(1);
    }

    private static void spawnSmokeParticles(ServerLevel serverLevel, LivingEntity entity, double x, double y, double z) {
        SimpleParticleType particle = entity.m_5842_() ? ParticleTypes.f_123795_ : ParticleTypes.f_123755_;
        int particleCount = entity.m_5842_() ? 160 : 80;
        for (int i = 0; i < particleCount; ++i) {
            double xOffset = (serverLevel.m_213780_().m_188500_() - 0.5) * 2.5;
            double yOffset = (serverLevel.m_213780_().m_188500_() - 0.5) * 2.5;
            double zOffset = (serverLevel.m_213780_().m_188500_() - 0.5) * 2.5;
            serverLevel.m_8767_((ParticleOptions)particle, x + xOffset, y + yOffset, z + zOffset, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void applyBlindnessToNearbyEntities(LivingEntity entity, Vec3 center) {
        List nearbyEntities = entity.m_9236_().m_6443_(LivingEntity.class, new AABB(center, center).m_82400_(2.5), e -> e != entity);
        for (LivingEntity nearbyEntity : nearbyEntities) {
            if (!(entity.m_9236_().m_213780_().m_188501_() <= 0.5f)) continue;
            nearbyEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 1, false, false, true));
        }
    }
}

