/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.behavior.weapons;

import net.jaams.jaams_weaponry.handler.mechanics.BreakingHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.item.WarPickItem;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WarPickBehavior {
    private static final float CRITICAL_CHANCE = 0.05f;

    @SubscribeEvent
    public static void onWarPickEntityAttack(LivingAttackEvent event) {
        Entity sourceEntity = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        if (!(sourceEntity instanceof Mob)) {
            return;
        }
        Mob attacker = (Mob)sourceEntity;
        Level level = attacker.m_9236_();
        if (level.f_46443_) {
            return;
        }
        ItemStack warPickItem = attacker.m_21205_();
        if (!(warPickItem.m_41720_() instanceof WarPickItem)) {
            return;
        }
        boolean isFullyCharged = true;
        boolean isCritical = level.f_46441_.m_188501_() < 0.05f;
        float armorDamageChance = isCritical ? 0.95f : 0.8f;
        float heldItemDamageChance = isCritical ? 0.85f : 0.6f;
        boolean damageApplied = false;
        if (level.f_46441_.m_188501_() < armorDamageChance) {
            BreakingHandler.damageArmorPieces(target, 6, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
            damageApplied = true;
        }
        if (level.f_46441_.m_188501_() < heldItemDamageChance) {
            BreakingHandler.damageHeldItem(target, 6);
            damageApplied = true;
        }
        if (damageApplied) {
            warPickItem.m_41622_(3, (LivingEntity)attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
        if (warPickItem.m_41773_() > warPickItem.m_41776_() / 2 && level.f_46441_.m_188501_() < 0.3f) {
            BreakingHandler.damageArmorPieces(target, 18, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
            BreakingHandler.damageHeldItem(target, 18);
            ModUtils.handleItemBreak(warPickItem, (LivingEntity)attacker, 1.0f, 6, "minecraft:item.shield.break");
            Item sharpStone = (Item)JaamsWeaponryModItems.SHARP_STONE.get();
            int dropAmount = 1 + level.f_46441_.m_188503_(2);
            ItemStack dropStack = new ItemStack((ItemLike)sharpStone, dropAmount);
            Vec3 dropPos = attacker.m_20182_().m_82520_(0.0, (double)(attacker.m_20206_() / 2.0f), 0.0);
            ItemEntity dropEntity = new ItemEntity(level, dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, dropStack);
            dropEntity.m_32060_();
            level.m_7967_((Entity)dropEntity);
        }
        ModUtils.playSound((Entity)target, "jaams_weaponry:war_pick_hit", SoundSource.HOSTILE, 1.0f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ModUtils.spawnItemParticlesInFront((LivingEntity)attacker, warPickItem, 6, 1.0f, true);
        }
    }
}

