/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.capability;

import net.jaams.jaams_weaponry.JaamsWeaponryMod;
import net.jaams.jaams_weaponry.capability.aberration.AberrationProvider;
import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.capability.animation.AnimationProvider;
import net.jaams.jaams_weaponry.capability.dualwield.DualWieldProvider;
import net.jaams.jaams_weaponry.packets.AberrationPacket;
import net.jaams.jaams_weaponry.packets.AmountPacket;
import net.jaams.jaams_weaponry.packets.AnimationPacket;
import net.jaams.jaams_weaponry.packets.DualWieldPacket;
import net.jaams.jaams_weaponry.util.ModEnums;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="jaams_weaponry", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityEvents {
    @SubscribeEvent
    public static void onCapabilityPlayerTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (!player.m_9236_().f_46443_) {
                player.getCapability(AberrationProvider.ABERRATION).ifPresent(aberration -> {
                    int duration = aberration.getDuration();
                    if (duration > 0) {
                        aberration.setDuration(duration - 1);
                        if (duration - 1 <= 0) {
                            aberration.setEffectType(ModEnums.AberrationType.NONE);
                            aberration.setIntensity(0.0);
                        }
                        JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AberrationPacket(player.m_19879_(), aberration.getEffectType(), aberration.getIntensity(), aberration.getDuration()));
                    }
                });
                player.getCapability(AnimationProvider.ANIMATION).ifPresent(animation -> {
                    int duration = animation.getDuration();
                    if (duration > 0) {
                        animation.setDuration(duration - 1);
                        if (duration - 1 <= 0) {
                            animation.setAnimation("");
                        }
                        JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AnimationPacket(player.m_19879_(), animation.getAnimation(), animation.getDuration()));
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onCapabilityEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.m_9236_().f_46443_) {
                player.getCapability(DualWieldProvider.DUAL_WIELD).ifPresent(dualWield -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new DualWieldPacket(player.m_19879_(), dualWield.isOffhandTurn())));
                player.getCapability(AberrationProvider.ABERRATION).ifPresent(aberration -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AberrationPacket(player.m_19879_(), aberration.getEffectType(), aberration.getIntensity(), aberration.getDuration())));
                player.getCapability(AnimationProvider.ANIMATION).ifPresent(animation -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AnimationPacket(player.m_19879_(), animation.getAnimation(), animation.getDuration())));
                player.getCapability(AmountProvider.AMOUNT).ifPresent(amount -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AmountPacket(player.m_19879_(), amount.getDamage())));
            }
        }
    }

    @SubscribeEvent
    public static void onCapabilityStartTracking(PlayerEvent.StartTracking event) {
        Player player;
        Entity target = event.getTarget();
        if (!target.m_9236_().f_46443_ && target instanceof Player && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            target.getCapability(DualWieldProvider.DUAL_WIELD).ifPresent(dualWield -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new DualWieldPacket(target.m_19879_(), dualWield.isOffhandTurn())));
            target.getCapability(AberrationProvider.ABERRATION).ifPresent(aberration -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AberrationPacket(target.m_19879_(), aberration.getEffectType(), aberration.getIntensity(), aberration.getDuration())));
            target.getCapability(AnimationProvider.ANIMATION).ifPresent(animation -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AnimationPacket(target.m_19879_(), animation.getAnimation(), animation.getDuration())));
            target.getCapability(AmountProvider.AMOUNT).ifPresent(amount -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AmountPacket(target.m_19879_(), amount.getDamage())));
        }
    }

    @SubscribeEvent
    public static void onCapabilityPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!player2.m_9236_().f_46443_) {
                player2.getCapability(DualWieldProvider.DUAL_WIELD).ifPresent(dualWield -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new DualWieldPacket(player2.m_19879_(), dualWield.isOffhandTurn())));
                player2.getCapability(AberrationProvider.ABERRATION).ifPresent(aberration -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AberrationPacket(player2.m_19879_(), aberration.getEffectType(), aberration.getIntensity(), aberration.getDuration())));
                player2.getCapability(AnimationProvider.ANIMATION).ifPresent(animation -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AnimationPacket(player2.m_19879_(), animation.getAnimation(), animation.getDuration())));
                player2.getCapability(AmountProvider.AMOUNT).ifPresent(amount -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AmountPacket(player2.m_19879_(), amount.getDamage())));
            }
        }
    }

    @SubscribeEvent
    public static void onCapabilityPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!player2.m_9236_().f_46443_) {
                player2.getCapability(DualWieldProvider.DUAL_WIELD).ifPresent(dualWield -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new DualWieldPacket(player2.m_19879_(), dualWield.isOffhandTurn())));
                player2.getCapability(AberrationProvider.ABERRATION).ifPresent(aberration -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AberrationPacket(player2.m_19879_(), aberration.getEffectType(), aberration.getIntensity(), aberration.getDuration())));
                player2.getCapability(AnimationProvider.ANIMATION).ifPresent(animation -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AnimationPacket(player2.m_19879_(), animation.getAnimation(), animation.getDuration())));
                player2.getCapability(AmountProvider.AMOUNT).ifPresent(amount -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AmountPacket(player2.m_19879_(), amount.getDamage())));
            }
        }
    }

    @SubscribeEvent
    public static void onCapabilityPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!player2.m_9236_().f_46443_) {
                player2.getCapability(DualWieldProvider.DUAL_WIELD).ifPresent(dualWield -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new DualWieldPacket(player2.m_19879_(), dualWield.isOffhandTurn())));
                player2.getCapability(AberrationProvider.ABERRATION).ifPresent(aberration -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AberrationPacket(player2.m_19879_(), aberration.getEffectType(), aberration.getIntensity(), aberration.getDuration())));
                player2.getCapability(AnimationProvider.ANIMATION).ifPresent(animation -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AnimationPacket(player2.m_19879_(), animation.getAnimation(), animation.getDuration())));
                player2.getCapability(AmountProvider.AMOUNT).ifPresent(amount -> JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new AmountPacket(player2.m_19879_(), amount.getDamage())));
            }
        }
    }

    @SubscribeEvent
    public static void onCapabilityPlayerClone(PlayerEvent.Clone event) {
        Player player;
        if (!event.getEntity().m_9236_().f_46443_ && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer newPlayer = (ServerPlayer)player;
            player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer original = (ServerPlayer)player;
                original.getCapability(DualWieldProvider.DUAL_WIELD).ifPresent(originalDualWield -> newPlayer.getCapability(DualWieldProvider.DUAL_WIELD).ifPresent(newDualWield -> {
                    newDualWield.deserializeNBT(originalDualWield.serializeNBT());
                    JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> newPlayer), (Object)new DualWieldPacket(newPlayer.m_19879_(), newDualWield.isOffhandTurn()));
                }));
                original.getCapability(AberrationProvider.ABERRATION).ifPresent(originalAberration -> newPlayer.getCapability(AberrationProvider.ABERRATION).ifPresent(newAberration -> {
                    newAberration.deserializeNBT(originalAberration.serializeNBT());
                    JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> newPlayer), (Object)new AberrationPacket(newPlayer.m_19879_(), newAberration.getEffectType(), newAberration.getIntensity(), newAberration.getDuration()));
                }));
                original.getCapability(AnimationProvider.ANIMATION).ifPresent(originalAnimation -> newPlayer.getCapability(AnimationProvider.ANIMATION).ifPresent(newAnimation -> {
                    newAnimation.deserializeNBT(originalAnimation.serializeNBT());
                    JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> newPlayer), (Object)new AnimationPacket(newPlayer.m_19879_(), newAnimation.getAnimation(), newAnimation.getDuration()));
                }));
                original.getCapability(AmountProvider.AMOUNT).ifPresent(originalAmount -> newPlayer.getCapability(AmountProvider.AMOUNT).ifPresent(newAmount -> {
                    newAmount.deserializeNBT(originalAmount.serializeNBT());
                    JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> newPlayer), (Object)new AmountPacket(newPlayer.m_19879_(), newAmount.getDamage()));
                }));
            }
        }
    }
}

