/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.entity.DynamiteProjectileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DynamiteProjectileRenderer
extends EntityRenderer<DynamiteProjectileEntity> {
    public DynamiteProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(DynamiteProjectileEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.m_85836_();
        float SCALE_FACTOR = ((Double)JaamsWeaponryClientConfiguration.DYNAMITESIZE.get()).floatValue();
        matrixStack.m_85841_(SCALE_FACTOR, SCALE_FACTOR, SCALE_FACTOR);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_())));
        if (!entity.hasImpacted()) {
            float baseSpinSpeed = 30.0f;
            float spinRotation = ((float)entity.getSpinTicks() + partialTicks) * baseSpinSpeed;
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(spinRotation));
        } else {
            float pitch = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(pitch + 65.0f));
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack itemStack = entity.getDynamiteItem();
        itemRenderer.m_269128_(itemStack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, matrixStack, buffer, entity.m_9236_(), entity.m_19879_());
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(DynamiteProjectileEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public boolean shouldRender(DynamiteProjectileEntity entity, Frustum frustum, double camX, double camY, double camZ) {
        return super.m_5523_((Entity)entity, frustum, camX, camY, camZ);
    }
}

