/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.entity.GiantShurikenProjectileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GiantShurikenProjectileRenderer
extends EntityRenderer<GiantShurikenProjectileEntity> {
    public GiantShurikenProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(GiantShurikenProjectileEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.m_85836_();
        float SCALE_FACTOR = ((Double)JaamsWeaponryClientConfiguration.GIANTSHURIKENSIZE.get()).floatValue();
        matrixStack.m_85841_(SCALE_FACTOR, SCALE_FACTOR, SCALE_FACTOR);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_()) + 90.0f));
        float pitch = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        float zRotation = 135.0f + pitch;
        if (pitch != 0.0f) {
            zRotation = 135.0f - pitch;
        }
        if (!entity.hasImpacted()) {
            float baseSpinSpeed;
            float spinSpeed = baseSpinSpeed = 25.0f;
            float spinRotation = ((float)entity.getSpinTicks() + partialTicks) * spinSpeed;
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(zRotation + spinRotation));
        } else {
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(zRotation));
        }
        matrixStack.m_252880_(0.0f, -0.27f, 0.0f);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        itemRenderer.m_269128_(entity.getWeaponItem(), ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, matrixStack, buffer, entity.m_9236_(), entity.m_19879_());
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(GiantShurikenProjectileEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public boolean shouldRender(GiantShurikenProjectileEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return super.m_5523_((Entity)pLivingEntity, pCamera, pCamX, pCamY, pCamZ);
    }
}

