/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.entity.RingProjectileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RingProjectileRenderer
extends EntityRenderer<RingProjectileEntity> {
    public RingProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(RingProjectileEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.m_85836_();
        float SCALE_FACTOR = ((Double)JaamsWeaponryClientConfiguration.RINGSIZE.get()).floatValue();
        matrixStack.m_85841_(SCALE_FACTOR, SCALE_FACTOR, SCALE_FACTOR);
        float spinRotation = entity.getSpinTicks() > 0 ? ((float)entity.getSpinTicks() + partialTicks) * -60.0f : entity.getLastSpinTick();
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        float pitch = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        if (pitch > 45.0f || pitch < -45.0f) {
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        }
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(spinRotation));
        matrixStack.m_252880_(0.0f, -0.195f, 0.0f);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        itemRenderer.m_269128_(entity.getWeaponItem(), ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, matrixStack, buffer, entity.m_9236_(), entity.m_19879_());
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(RingProjectileEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public boolean shouldRender(RingProjectileEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return super.m_5523_((Entity)pLivingEntity, pCamera, pCamX, pCamY, pCamZ);
    }
}

