/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.entity.TridentProjectileEntity;
import net.minecraft.client.model.TridentModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TridentProjectileRenderer
extends EntityRenderer<TridentProjectileEntity> {
    public static final ResourceLocation TRIDENT_LOCATION = new ResourceLocation("minecraft", "textures/entity/trident.png");
    private final TridentModel model;

    public TridentProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new TridentModel(context.m_174023_(ModelLayers.f_171255_));
    }

    public void render(TridentProjectileEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.m_85836_();
        float SCALE_FACTOR = ((Double)JaamsWeaponryClientConfiguration.TRIDENTSIZE.get()).floatValue();
        matrixStack.m_85841_(SCALE_FACTOR, SCALE_FACTOR, SCALE_FACTOR);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_()) - 90.0f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_()) + 90.0f));
        VertexConsumer vertexConsumer = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)this.model.m_103119_(this.getTextureLocation(entity)), (boolean)false, (boolean)entity.isFoil());
        this.model.m_7695_(matrixStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(TridentProjectileEntity entity) {
        return TRIDENT_LOCATION;
    }

    public boolean shouldRender(TridentProjectileEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return super.m_5523_((Entity)pLivingEntity, pCamera, pCamX, pCamY, pCamZ);
    }
}

