/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.components;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.jaams.jaams_weaponry.handler.events.AdvancementsHandler;
import net.jaams.jaams_weaponry.handler.events.BlockingHandler;
import net.jaams.jaams_weaponry.particles.CustomHitParticleData;
import net.jaams.jaams_weaponry.particles.SmallWaveParticleData;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public abstract class BaseBulletProjectileEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    protected static final EntityDataAccessor<Boolean> ID_AREA_DAMAGE = SynchedEntityData.m_135353_(BaseBulletProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Float> ID_AREA_DAMAGE_RADIUS = SynchedEntityData.m_135353_(BaseBulletProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> ID_AREA_DAMAGE_MULTIPLIER = SynchedEntityData.m_135353_(BaseBulletProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> ID_HAS_GRAVITY = SynchedEntityData.m_135353_(BaseBulletProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> ID_COLOR = SynchedEntityData.m_135353_(BaseBulletProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> ID_PIERCING = SynchedEntityData.m_135353_(BaseBulletProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Boolean> ID_IMPACTED = SynchedEntityData.m_135353_(BaseBulletProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int ticksInAir = 0;
    protected int ticksInGround = 0;
    protected int bubbleTime = 0;
    protected int waveParticleCount = 0;
    protected int hitCount = 0;
    protected int breakCount = 0;
    protected int noGravityTicks = 0;
    protected boolean hasGravity = true;
    protected int color = 0xFFFFFF;
    protected int pierceLevel = 0;
    protected boolean areaDamage = false;
    protected float areaDamageRadius = 0.0f;
    protected float areaDamageMultiplier = 0.5f;
    protected IntOpenHashSet piercingIgnoreEntityIds = new IntOpenHashSet();
    protected List<UUID> piercedAndKilledEntities = new ArrayList<UUID>();
    @Nullable
    protected UUID lastHitEntityId;

    public BaseBulletProjectileEntity(EntityType<? extends BaseBulletProjectileEntity> type, Level world) {
        super(type, world);
    }

    public BaseBulletProjectileEntity(EntityType<? extends BaseBulletProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public BaseBulletProjectileEntity(EntityType<? extends BaseBulletProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    protected abstract SoundEvent getHitSound();

    protected abstract SoundEvent getGroundSound();

    protected abstract void applyHitEffects(LivingEntity var1, EntityHitResult var2);

    protected abstract void applyBlockHitEffects(BlockPos var1, BlockState var2, BlockHitResult var3);

    public abstract int getMaxBreaks();

    public abstract int getMaxHits();

    public abstract int getMaxTicksInAir();

    public abstract int getMaxTicksInGround();

    public abstract void setBulletDamage(float var1);

    public abstract void setBulletKnockback(float var1);

    public abstract boolean canDisableShield(ItemStack var1, LivingEntity var2, Entity var3);

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_PIERCING, (Object)0);
        this.f_19804_.m_135372_(ID_AREA_DAMAGE, (Object)false);
        this.f_19804_.m_135372_(ID_AREA_DAMAGE_RADIUS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ID_AREA_DAMAGE_MULTIPLIER, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135372_(ID_HAS_GRAVITY, (Object)true);
        this.f_19804_.m_135372_(ID_COLOR, (Object)0xFFFFFF);
        this.f_19804_.m_135372_(ID_IMPACTED, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.lastHitEntityId != null) {
            tag.m_128362_("LastHitEntityId", this.lastHitEntityId);
        }
        tag.m_128405_("HitCount", this.hitCount);
        tag.m_128405_("breakCount", this.breakCount);
        tag.m_128344_("PiercingLevel", (byte)this.pierceLevel);
        tag.m_128385_("PiercingIgnoreEntityIds", this.piercingIgnoreEntityIds.toIntArray());
        ListTag piercedList = new ListTag();
        for (UUID uuid : this.piercedAndKilledEntities) {
            piercedList.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        tag.m_128365_("PiercedAndKilledEntities", (Tag)piercedList);
        tag.m_128379_("AreaDamage", this.areaDamage);
        tag.m_128350_("AreaDamageRadius", this.areaDamageRadius);
        tag.m_128350_("AreaDamageMultiplier", this.areaDamageMultiplier);
        tag.m_128350_("BaseBulletDamage", this.getPersistentData().m_128457_("BaseBulletDamage"));
        tag.m_128379_("HasGravity", this.hasGravity);
        tag.m_128405_("Color", this.color);
        tag.m_128350_("KnockbackStrength", this.getPersistentData().m_128457_("KnockbackStrength"));
        tag.m_128379_("Explodes", this.getPersistentData().m_128471_("Explodes"));
        tag.m_128350_("ExplosionStrength", this.getPersistentData().m_128457_("ExplosionStrength"));
        this.getPersistentData().m_128405_("HitCount", this.hitCount);
        this.getPersistentData().m_128405_("breakCount", this.breakCount);
        this.getPersistentData().m_128344_("PiercingLevel", (byte)this.pierceLevel);
        this.getPersistentData().m_128379_("AreaDamage", this.areaDamage);
        this.getPersistentData().m_128350_("AreaDamageRadius", this.areaDamageRadius);
        this.getPersistentData().m_128350_("AreaDamageMultiplier", this.areaDamageMultiplier);
        this.getPersistentData().m_128379_("HasGravity", this.hasGravity);
        this.getPersistentData().m_128405_("Color", this.color);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("LastHitEntityId")) {
            this.lastHitEntityId = tag.m_128342_("LastHitEntityId");
        }
        this.hitCount = tag.m_128451_("HitCount");
        this.breakCount = tag.m_128451_("breakCount");
        this.pierceLevel = tag.m_128445_("PiercingLevel");
        if (tag.m_128425_("PiercingIgnoreEntityIds", 11)) {
            this.piercingIgnoreEntityIds = new IntOpenHashSet(tag.m_128465_("PiercingIgnoreEntityIds"));
        }
        if (tag.m_128425_("PiercedAndKilledEntities", 9)) {
            ListTag piercedList = tag.m_128437_("PiercedAndKilledEntities", 11);
            this.piercedAndKilledEntities.clear();
            for (Tag uuidTag : piercedList) {
                UUID uuid = NbtUtils.m_129233_((Tag)uuidTag);
                this.piercedAndKilledEntities.add(uuid);
            }
        }
        this.areaDamage = tag.m_128471_("AreaDamage");
        this.areaDamageRadius = tag.m_128457_("AreaDamageRadius");
        this.areaDamageMultiplier = tag.m_128441_("AreaDamageMultiplier") ? tag.m_128457_("AreaDamageMultiplier") : 0.5f;
        this.hasGravity = tag.m_128441_("HasGravity") ? tag.m_128471_("HasGravity") : true;
        this.color = tag.m_128441_("Color") ? tag.m_128451_("Color") : 0xFFFFFF;
        this.f_19804_.m_135381_(ID_PIERCING, (Object)((byte)this.pierceLevel));
        this.f_19804_.m_135381_(ID_AREA_DAMAGE, (Object)this.areaDamage);
        this.f_19804_.m_135381_(ID_AREA_DAMAGE_RADIUS, (Object)Float.valueOf(this.areaDamageRadius));
        this.f_19804_.m_135381_(ID_AREA_DAMAGE_MULTIPLIER, (Object)Float.valueOf(this.areaDamageMultiplier));
        this.f_19804_.m_135381_(ID_HAS_GRAVITY, (Object)this.hasGravity);
        this.f_19804_.m_135381_(ID_COLOR, (Object)this.color);
        this.getPersistentData().m_128405_("HitCount", this.hitCount);
        this.getPersistentData().m_128405_("breakCount", this.breakCount);
        this.getPersistentData().m_128344_("PiercingLevel", (byte)this.pierceLevel);
        this.getPersistentData().m_128379_("AreaDamage", this.areaDamage);
        this.getPersistentData().m_128350_("AreaDamageRadius", this.areaDamageRadius);
        this.getPersistentData().m_128350_("AreaDamageMultiplier", this.areaDamageMultiplier);
        this.getPersistentData().m_128379_("HasGravity", this.hasGravity);
        this.getPersistentData().m_128405_("Color", this.color);
        this.getPersistentData().m_128350_("BaseBulletDamage", tag.m_128457_("BaseBulletDamage"));
        this.getPersistentData().m_128350_("KnockbackStrength", tag.m_128441_("KnockbackStrength") ? tag.m_128457_("KnockbackStrength") : 0.6f);
        this.getPersistentData().m_128379_("Explodes", tag.m_128471_("Explodes"));
        this.getPersistentData().m_128350_("ExplosionStrength", tag.m_128441_("ExplosionStrength") ? tag.m_128457_("ExplosionStrength") : 0.0f);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.lastHitEntityId != null);
        if (this.lastHitEntityId != null) {
            buffer.m_130077_(this.lastHitEntityId);
        }
        buffer.writeInt(this.hitCount);
        buffer.writeInt(this.breakCount);
        buffer.writeByte(this.pierceLevel);
        buffer.writeInt(this.piercingIgnoreEntityIds.size());
        IntIterator intIterator = this.piercingIgnoreEntityIds.iterator();
        while (intIterator.hasNext()) {
            int id = (Integer)intIterator.next();
            buffer.writeInt(id);
        }
        buffer.writeInt(this.piercedAndKilledEntities.size());
        for (UUID uuid : this.piercedAndKilledEntities) {
            buffer.m_130077_(uuid);
        }
        buffer.writeBoolean(this.areaDamage);
        buffer.writeFloat(this.areaDamageRadius);
        buffer.writeFloat(this.areaDamageMultiplier);
        buffer.writeFloat(this.getPersistentData().m_128457_("BaseBulletDamage"));
        buffer.writeBoolean(this.hasGravity);
        buffer.writeInt(this.color);
        buffer.writeFloat(this.getPersistentData().m_128457_("KnockbackStrength"));
        buffer.writeBoolean(this.getPersistentData().m_128471_("Explodes"));
        buffer.writeFloat(this.getPersistentData().m_128457_("ExplosionStrength"));
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        boolean hasLastHitEntityId = additionalData.isReadable() && additionalData.readBoolean();
        this.lastHitEntityId = hasLastHitEntityId && additionalData.isReadable(16) ? additionalData.m_130259_() : null;
        this.hitCount = additionalData.isReadable(4) ? additionalData.readInt() : 0;
        this.breakCount = additionalData.isReadable(4) ? additionalData.readInt() : 0;
        this.pierceLevel = additionalData.readByte();
        int piercingIgnoreCount = additionalData.readInt();
        this.piercingIgnoreEntityIds.clear();
        for (int i = 0; i < piercingIgnoreCount; ++i) {
            this.piercingIgnoreEntityIds.add(additionalData.readInt());
        }
        int piercedEntityCount = additionalData.readInt();
        this.piercedAndKilledEntities.clear();
        for (int i = 0; i < piercedEntityCount; ++i) {
            UUID uuid = additionalData.m_130259_();
            this.piercedAndKilledEntities.add(uuid);
        }
        this.areaDamage = additionalData.readBoolean();
        this.areaDamageRadius = additionalData.readFloat();
        this.areaDamageMultiplier = additionalData.readFloat();
        this.getPersistentData().m_128350_("BaseBulletDamage", additionalData.readFloat());
        this.hasGravity = additionalData.readBoolean();
        this.color = additionalData.readInt();
        this.getPersistentData().m_128350_("KnockbackStrength", additionalData.readFloat());
        this.getPersistentData().m_128379_("Explodes", additionalData.readBoolean());
        this.getPersistentData().m_128350_("ExplosionStrength", additionalData.readFloat());
        this.f_19804_.m_135381_(ID_PIERCING, (Object)((byte)this.pierceLevel));
        this.f_19804_.m_135381_(ID_AREA_DAMAGE, (Object)this.areaDamage);
        this.f_19804_.m_135381_(ID_AREA_DAMAGE_RADIUS, (Object)Float.valueOf(this.areaDamageRadius));
        this.f_19804_.m_135381_(ID_AREA_DAMAGE_MULTIPLIER, (Object)Float.valueOf(this.areaDamageMultiplier));
        this.f_19804_.m_135381_(ID_HAS_GRAVITY, (Object)this.hasGravity);
        this.f_19804_.m_135381_(ID_COLOR, (Object)this.color);
        this.getPersistentData().m_128405_("HitCount", this.hitCount);
        this.getPersistentData().m_128405_("breakCount", this.breakCount);
        this.getPersistentData().m_128344_("PiercingLevel", (byte)this.pierceLevel);
        this.getPersistentData().m_128379_("AreaDamage", this.areaDamage);
        this.getPersistentData().m_128350_("AreaDamageRadius", this.areaDamageRadius);
        this.getPersistentData().m_128350_("AreaDamageMultiplier", this.areaDamageMultiplier);
        this.getPersistentData().m_128379_("HasGravity", this.hasGravity);
        this.getPersistentData().m_128405_("Color", this.color);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (ID_PIERCING.equals(key)) {
            this.pierceLevel = ((Byte)this.f_19804_.m_135370_(ID_PIERCING)).byteValue();
            this.getPersistentData().m_128344_("PiercingLevel", (byte)this.pierceLevel);
        } else if (ID_AREA_DAMAGE.equals(key)) {
            this.areaDamage = (Boolean)this.f_19804_.m_135370_(ID_AREA_DAMAGE);
            this.getPersistentData().m_128379_("AreaDamage", this.areaDamage);
        } else if (ID_AREA_DAMAGE_RADIUS.equals(key)) {
            this.areaDamageRadius = ((Float)this.f_19804_.m_135370_(ID_AREA_DAMAGE_RADIUS)).floatValue();
            this.getPersistentData().m_128350_("AreaDamageRadius", this.areaDamageRadius);
        } else if (ID_AREA_DAMAGE_MULTIPLIER.equals(key)) {
            this.areaDamageMultiplier = ((Float)this.f_19804_.m_135370_(ID_AREA_DAMAGE_MULTIPLIER)).floatValue();
            this.getPersistentData().m_128350_("AreaDamageMultiplier", this.areaDamageMultiplier);
        } else if (ID_HAS_GRAVITY.equals(key)) {
            this.hasGravity = (Boolean)this.f_19804_.m_135370_(ID_HAS_GRAVITY);
            this.getPersistentData().m_128379_("HasGravity", this.hasGravity);
        } else if (ID_COLOR.equals(key)) {
            this.color = (Integer)this.f_19804_.m_135370_(ID_COLOR);
            this.getPersistentData().m_128405_("Color", this.color);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        boolean isSameEntity;
        if (this.m_9236_().f_46443_) return;
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) return;
        ServerLevel serverWorld = (ServerLevel)level;
        Entity entity = entityHitResult.m_82443_();
        UUID entityUUID = entity.m_20148_();
        Entity owner = this.m_19749_();
        boolean bl = isSameEntity = entityUUID != null && entityUUID.equals(this.lastHitEntityId);
        if (this.pierceLevel > 0 && this.piercingIgnoreEntityIds.contains(entity.m_19879_())) {
            return;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21254_()) {
            float damage = this.calculateDamage((Entity)livingEntity);
            DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
            if (owner instanceof LivingEntity) {
                LivingEntity ownerLivingEntity = (LivingEntity)owner;
                if (this.canDisableShield(livingEntity.m_21211_(), livingEntity, (Entity)ownerLivingEntity)) {
                    livingEntity.m_6469_(damageSource, damage);
                    this.handleBlocking(livingEntity, owner);
                    return;
                }
            }
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                if (!(owner != null && owner == player || BlockingHandler.isProlongedBlocking(player))) {
                    AdvancementsHandler.incrementCounterAndCheckAdvancement(player, "blocked_projectiles", "faster_than_speeding_bullet", 6);
                }
            }
            livingEntity.m_6469_(damageSource, damage);
            this.f_19804_.m_135381_(ID_IMPACTED, (Object)true);
            this.reverseMovementAndRotation();
            this.stopProjectile();
            return;
        }
        if (entity.m_6095_() == EntityType.f_20566_ && entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            float damage = this.calculateDamage((Entity)livingEntity);
            DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
            livingEntity.m_6469_(damageSource, damage);
            return;
        }
        if (isSameEntity && this.hitCount >= this.getMaxHits() && this.pierceLevel <= 0) {
            this.m_146870_();
            return;
        }
        if (!isSameEntity) {
            this.hitCount = 1;
            this.lastHitEntityId = entityUUID;
        } else {
            ++this.hitCount;
        }
        this.getPersistentData().m_128405_("HitCount", this.hitCount);
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
            DamageSource damageSource = this.m_269291_().m_269418_((AbstractArrow)this, (Entity)(owner != null ? owner : this));
            livingEntity.f_19802_ = 0;
            float damage = this.calculateDamage((Entity)livingEntity);
            boolean damageApplied = livingEntity.m_6469_(damageSource, damage);
            if (damageApplied) {
                this.spawnHitParticles(serverWorld);
                this.applyHitEffects(livingEntity, entityHitResult);
                this.applyKnockback(livingEntity);
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    ModUtils.applyShakeEffect((Entity)player, 1.5, 5);
                }
                if (this.areaDamage) {
                    this.applyAreaDamage(livingEntity, damage);
                }
                if (this.getPersistentData().m_128471_("Explodes")) {
                    this.triggerExplosion(serverWorld);
                    this.m_146870_();
                    return;
                }
                if (this.pierceLevel > 0) {
                    this.piercingIgnoreEntityIds.add(livingEntity.m_19879_());
                    --this.pierceLevel;
                    this.f_19804_.m_135381_(ID_PIERCING, (Object)((byte)this.pierceLevel));
                    this.getPersistentData().m_128344_("PiercingLevel", (byte)this.pierceLevel);
                    if (!livingEntity.m_6084_()) {
                        this.piercedAndKilledEntities.add(livingEntity.m_20148_());
                    }
                    if (this.pierceLevel > 0) return;
                    this.m_146870_();
                    return;
                }
                this.m_146870_();
            } else {
                this.reverseMovementAndRotation();
                this.f_19804_.m_135381_(ID_IMPACTED, (Object)true);
                this.stopProjectile();
            }
        } else {
            this.reverseMovementAndRotation();
            this.f_19804_.m_135381_(ID_IMPACTED, (Object)true);
            this.m_146870_();
        }
        this.m_5496_(this.getHitSound(), 1.0f, 1.0f);
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        boolean brokeBlock;
        BlockPos pos = blockHitResult.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        Direction hitFace = blockHitResult.m_82434_();
        boolean bl = brokeBlock = ModUtils.isProjectileBreakableBlock(state) || this.isCustomBreakableBlock(state);
        if (!brokeBlock) {
            Vec3 vec3 = blockHitResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_20256_(vec3);
            Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
            this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
            this.f_36703_ = true;
            this.f_36706_ = 3;
            this.f_19864_ = true;
            this.m_36762_(false);
            this.m_36767_((byte)0);
            this.m_36793_(false);
            this.m_36723_();
        }
        if (this.areaDamage) {
            this.applyAreaDamage(null, this.calculateDamage(null));
        }
        this.applyBlockHitEffects(pos, state, blockHitResult);
        BlockState blockstate = this.m_9236_().m_8055_(blockHitResult.m_82425_());
        blockstate.m_60669_(this.m_9236_(), blockstate, blockHitResult, (Projectile)this);
        if (!this.m_9236_().f_46443_) {
            if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
                this.spawnBlockParticles(pos);
            }
            this.tryBreakBlock(pos, state);
        }
        this.m_5496_(this.getGroundSound(), 1.0f, 1.0f);
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.m_20069_()) {
                this.setHasGravity(true);
                this.m_20242_(false);
            } else {
                this.m_20242_(!this.getHasGravity());
            }
            if (this.m_20077_()) {
                this.discardWithSmoke(serverWorld);
                return;
            }
            if (this.m_20069_()) {
                if (!this.f_36703_) {
                    ++this.bubbleTime;
                    if (this.bubbleTime >= 200) {
                        this.discardWithSmoke(serverWorld);
                        return;
                    }
                } else {
                    this.bubbleTime = 0;
                    ++this.ticksInGround;
                    if (this.ticksInGround >= this.getMaxTicksInGround() && this.getMaxTicksInGround() > 0) {
                        this.discardWithSmoke(serverWorld);
                        return;
                    }
                }
            } else if (!this.f_36703_) {
                ++this.ticksInAir;
                if (this.ticksInAir >= this.getMaxTicksInAir()) {
                    this.discardWithSmoke(serverWorld);
                    return;
                }
                if (!this.getHasGravity()) {
                    ++this.noGravityTicks;
                    if (this.noGravityTicks >= 60 || this.m_20184_().m_82556_() < 0.001) {
                        this.stopProjectile();
                    }
                }
            } else {
                ++this.ticksInGround;
                if (this.ticksInGround >= this.getMaxTicksInGround() && this.getMaxTicksInGround() > 0) {
                    this.discardWithSmoke(serverWorld);
                    return;
                }
            }
        } else if (this.m_9236_().f_46443_) {
            this.handleParticleTrail();
        }
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_271165_;
    }

    protected float m_6882_() {
        return 0.8f;
    }

    protected void handleParticleTrail() {
        if (this.m_9236_().f_46443_ && !this.f_36703_ && !this.m_20077_()) {
            if (this.ticksInAir <= 4) {
                Vec3 motion = this.m_20184_().m_82541_();
                double offset = 0.5;
                double smokeX = this.m_20185_() - motion.f_82479_ * offset;
                double smokeY = this.m_20186_() + 0.17 - motion.f_82480_ * offset;
                double smokeZ = this.m_20189_() - motion.f_82481_ * offset;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, smokeX, smokeY, smokeZ, 0.0, 0.0, 0.0);
            }
            if (this.waveParticleCount < 3 && this.ticksInAir % 4 == 0) {
                float[] rgb = this.varyRGB(this.f_19796_, this.getColor());
                Vec3 motion = this.m_20184_();
                double offsetScale = 0.1;
                double offsetX = motion.f_82479_ * offsetScale + (this.f_19796_.m_188500_() - 0.5) * 0.05;
                double offsetY = motion.f_82480_ * offsetScale + (this.f_19796_.m_188500_() - 0.5) * 0.05 + 0.2;
                double offsetZ = motion.f_82481_ * offsetScale + (this.f_19796_.m_188500_() - 0.5) * 0.05;
                SmallWaveParticleData particle = new SmallWaveParticleData(rgb[0], rgb[1], rgb[2], 0.25f);
                this.m_9236_().m_7106_((ParticleOptions)particle, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
                ++this.waveParticleCount;
            }
        }
    }

    protected void spawnHitParticles(ServerLevel serverWorld) {
        float[] rgb = this.varyRGB(serverWorld.f_46441_, this.getColor());
        float maxScale = 0.2f;
        float minScale = 0.05f;
        float size = minScale + serverWorld.f_46441_.m_188501_() * (maxScale - minScale);
        Entity owner = this.m_19749_();
        if (owner != null) {
            double distanceSqr = owner.m_20280_((Entity)this);
            double maxDistanceSqr = 64.0;
            float distanceFactor = (float)Math.min(distanceSqr / maxDistanceSqr, 1.0);
            size = minScale + (maxScale - minScale) * distanceFactor * (0.5f + serverWorld.f_46441_.m_188501_() * 0.5f);
        }
        serverWorld.m_8767_((ParticleOptions)new CustomHitParticleData(rgb[0], rgb[1], rgb[2], size), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.1, 0.1, 0.1, 0.02);
    }

    private void tryBreakBlock(BlockPos pos, BlockState state) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Level level = this.m_9236_();
        ServerLevel serverWorld = (ServerLevel)level;
        if (ModUtils.isProjectileBreakableBlock(state) || this.isCustomBreakableBlock(state)) {
            level.m_46961_(pos, false);
            ++this.breakCount;
            this.getPersistentData().m_128405_("breakCount", this.breakCount);
        }
        if (this.breakCount >= this.getMaxBreaks()) {
            this.discardWithSmoke(serverWorld);
        }
    }

    protected boolean isCustomBreakableBlock(BlockState state) {
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
        return state.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("forge:glasses"))) || state.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("forge:glass"))) || state.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("forge:glass_panes"))) || state.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("jaams_weaponry:sharpstone_can_breaks"))) || blockId.m_135815_().contains("glass") || blockId.m_135815_().contains("pane");
    }

    public void spawnBlockParticles(BlockPos pos) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        BlockState state = this.m_9236_().m_8055_(pos);
        for (ServerPlayer player : ((ServerLevel)this.m_9236_()).m_6907_()) {
            if (!(player.m_20275_(this.m_20185_(), this.m_20186_(), this.m_20189_()) < 256.0)) continue;
            ((ServerLevel)this.m_9236_()).m_8624_(player, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(pos), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6, 0.1, 0.1, 0.1, 0.05);
        }
    }

    public void reverseMovementAndRotation() {
        this.m_20256_(this.m_20184_().m_82490_(-0.1));
        this.m_146922_(this.m_146908_() + 180.0f);
        this.f_19859_ += 180.0f;
    }

    protected void handleBlocking(LivingEntity livingEntity, Entity owner) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.lastHitEntityId = livingEntity.m_20148_();
            if (!player.m_36335_().m_41519_(player.m_21211_().m_41720_())) {
                player.m_36335_().m_41524_(player.m_21211_().m_41720_(), this.getShieldDisableTicks());
            }
            player.m_5810_();
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12347_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        if (!this.getHasGravity()) {
            this.m_20242_(true);
        }
    }

    protected int getShieldDisableTicks() {
        return 100;
    }

    private void discardWithSmoke(ServerLevel serverWorld) {
        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        this.m_146870_();
    }

    protected void triggerExplosion(ServerLevel serverWorld) {
        if (this.getPersistentData().m_128471_("Explodes") && this.getPersistentData().m_128457_("ExplosionStrength") > 0.0f) {
            serverWorld.m_255391_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getPersistentData().m_128457_("ExplosionStrength"), false, Level.ExplosionInteraction.BLOCK);
            this.m_146870_();
        }
    }

    protected void applyAreaDamage(@Nullable LivingEntity hitEntity, float baseDamage) {
        if (!this.m_9236_().f_46443_ && this.areaDamage && this.areaDamageRadius > 0.0f) {
            AABB aabb = new AABB(this.m_20185_() - (double)this.areaDamageRadius, this.m_20186_() - (double)this.areaDamageRadius, this.m_20189_() - (double)this.areaDamageRadius, this.m_20185_() + (double)this.areaDamageRadius, this.m_20186_() + (double)this.areaDamageRadius, this.m_20189_() + (double)this.areaDamageRadius);
            List nearbyEntities = this.m_9236_().m_6249_((Entity)this, aabb, entity -> entity instanceof LivingEntity && entity != this.m_19749_() && entity != hitEntity);
            DamageSource damageSource = this.m_269291_().m_269418_((AbstractArrow)this, (Entity)(this.m_19749_() == null ? this : this.m_19749_()));
            for (Entity entity2 : nearbyEntities) {
                if (!(entity2 instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity2;
                float distance = (float)this.m_20182_().m_82554_(entity2.m_20182_());
                float damageMultiplier = Math.max(0.0f, 1.0f - distance / this.areaDamageRadius);
                float areaDamage = baseDamage * damageMultiplier * this.areaDamageMultiplier;
                livingEntity.m_6469_(damageSource, areaDamage);
                this.applyHitEffects(livingEntity, new EntityHitResult((Entity)livingEntity));
            }
        }
    }

    protected float calculateDamage(@Nullable Entity entity) {
        float baseDamage = this.getPersistentData().m_128441_("BaseBulletDamage") ? this.getPersistentData().m_128457_("BaseBulletDamage") : 1.0f;
        return Math.max(0.0f, baseDamage);
    }

    protected void applyKnockback(LivingEntity entity) {
        float knockbackStrength = this.getPersistentData().m_128457_("KnockbackStrength");
        Vec3 delta = this.m_20184_().m_82541_().m_82490_((double)knockbackStrength);
        entity.m_5997_(delta.f_82479_, delta.f_82480_ * 0.5, delta.f_82481_);
    }

    protected float[] hexToRGB(int hexColor) {
        if (hexColor == 0) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        return new float[]{(float)(hexColor >> 16 & 0xFF) / 255.0f, (float)(hexColor >> 8 & 0xFF) / 255.0f, (float)(hexColor & 0xFF) / 255.0f};
    }

    protected float[] varyRGB(RandomSource random, int hexColor) {
        float[] rgb = this.hexToRGB(hexColor);
        float rVariation = random.m_188501_() * 0.3f - 0.15f;
        float gVariation = random.m_188501_() * 0.3f - 0.15f;
        float bVariation = random.m_188501_() * 0.3f - 0.15f;
        return new float[]{Mth.m_14036_((float)(rgb[0] + rVariation), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(rgb[1] + gVariation), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(rgb[2] + bVariation), (float)0.0f, (float)1.0f)};
    }

    public void setPiercingLevel(int level) {
        this.pierceLevel = Math.max(0, level);
        this.f_19804_.m_135381_(ID_PIERCING, (Object)((byte)this.pierceLevel));
        this.getPersistentData().m_128344_("PiercingLevel", (byte)this.pierceLevel);
    }

    public int getPiercingLevel() {
        return this.pierceLevel;
    }

    public void m_36723_() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    public void setAreaDamage(boolean enabled, float radius, float multiplier) {
        this.areaDamage = enabled;
        this.areaDamageRadius = Math.max(0.0f, radius);
        this.areaDamageMultiplier = Math.max(0.0f, Math.min(1.0f, multiplier));
        this.f_19804_.m_135381_(ID_AREA_DAMAGE, (Object)this.areaDamage);
        this.f_19804_.m_135381_(ID_AREA_DAMAGE_RADIUS, (Object)Float.valueOf(this.areaDamageRadius));
        this.f_19804_.m_135381_(ID_AREA_DAMAGE_MULTIPLIER, (Object)Float.valueOf(this.areaDamageMultiplier));
        this.getPersistentData().m_128379_("AreaDamage", this.areaDamage);
        this.getPersistentData().m_128350_("AreaDamageRadius", this.areaDamageRadius);
        this.getPersistentData().m_128350_("AreaDamageMultiplier", this.areaDamageMultiplier);
    }

    public boolean hasAreaDamage() {
        return this.areaDamage;
    }

    public float getAreaDamageRadius() {
        return this.areaDamageRadius;
    }

    public float getAreaDamageMultiplier() {
        return this.areaDamageMultiplier;
    }

    public float getBulletDamageFromData() {
        return this.getPersistentData().m_128457_("BaseBulletDamage");
    }

    public void setHasGravity(boolean hasGravity) {
        this.hasGravity = hasGravity;
        this.f_19804_.m_135381_(ID_HAS_GRAVITY, (Object)hasGravity);
        this.getPersistentData().m_128379_("HasGravity", this.hasGravity);
        this.m_20242_(!hasGravity);
    }

    public boolean getHasGravity() {
        return (Boolean)this.f_19804_.m_135370_(ID_HAS_GRAVITY);
    }

    public void setColor(int color) {
        this.color = color;
        this.f_19804_.m_135381_(ID_COLOR, (Object)color);
        this.getPersistentData().m_128405_("Color", this.color);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(ID_COLOR);
    }

    public float getBulletKnockback() {
        return this.getPersistentData().m_128457_("KnockbackStrength");
    }

    public void setExplosion(boolean enabled, float strength) {
        this.getPersistentData().m_128379_("Explodes", enabled);
        this.getPersistentData().m_128350_("ExplosionStrength", Math.max(0.0f, strength));
    }

    public boolean hasExplosion() {
        return this.getPersistentData().m_128471_("Explodes");
    }

    public float getExplosionStrength() {
        return this.getPersistentData().m_128457_("ExplosionStrength");
    }

    private void stopProjectile() {
        this.setHasGravity(true);
        this.m_20242_(false);
    }
}

