/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.components;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public abstract class BaseStackableProjectileEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    protected static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(BaseStackableProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> ID_SPIN_TICKS = SynchedEntityData.m_135353_(BaseStackableProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> ID_IMPACTED = SynchedEntityData.m_135353_(BaseStackableProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<ItemStack> ID_WEAPON_ITEM = SynchedEntityData.m_135353_(BaseStackableProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Boolean> ID_AREA_DAMAGE = SynchedEntityData.m_135353_(BaseStackableProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Float> ID_AREA_DAMAGE_RADIUS = SynchedEntityData.m_135353_(BaseStackableProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> ID_AREA_DAMAGE_MULTIPLIER = SynchedEntityData.m_135353_(BaseStackableProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> ID_HAS_GRAVITY = SynchedEntityData.m_135353_(BaseStackableProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Byte> ID_PIERCING = SynchedEntityData.m_135353_(BaseStackableProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Boolean> ID_CRITICAL = SynchedEntityData.m_135353_(BaseStackableProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> ID_ORIGINAL_SLOT = SynchedEntityData.m_135353_(BaseStackableProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public ItemStack weaponItem;
    protected boolean dealtDamage;
    protected boolean hasHitOwner = false;
    protected int bubbleTime = 0;
    protected int multishotGroundTicks = 0;
    protected int breakCount = 0;
    protected int hitCount = 0;
    protected int life = 0;
    protected int originalSlotIndex = -1;
    protected int clientSideReturnTickCount;
    protected int pierceLevel = 0;
    protected boolean areaDamage = false;
    protected float areaDamageRadius = 0.0f;
    protected float areaDamageMultiplier = 0.5f;
    protected boolean hasGravity = true;
    protected IntOpenHashSet piercingIgnoreEntityIds = new IntOpenHashSet();
    protected List<UUID> piercedAndKilledEntities = new ArrayList<UUID>();
    @Nullable
    protected UUID lastHitEntityId;

    public abstract ItemStack getDefaultWeaponItem();

    protected abstract SoundEvent getHitSound();

    protected abstract SoundEvent getGroundSound();

    public abstract int getMaxBreaks();

    public abstract int getMaxHits();

    protected abstract void applyHitEffects(LivingEntity var1, EntityHitResult var2);

    protected abstract void applyBlockHitEffects(BlockPos var1, BlockState var2, BlockHitResult var3);

    public abstract void setWeaponDamage(float var1);

    public abstract void setWeaponKnockback(float var1);

    public abstract boolean canDisableShield(ItemStack var1, LivingEntity var2, Entity var3);

    protected abstract boolean shouldBreakOnEntityHit();

    protected abstract boolean shouldBreakOnPiercingExhausted();

    protected abstract boolean shouldBreakOnBlockHit();

    protected BaseStackableProjectileEntity(EntityType<? extends BaseStackableProjectileEntity> type, Level world) {
        super(type, world);
        this.initializeWeaponItem(null);
    }

    protected BaseStackableProjectileEntity(EntityType<? extends BaseStackableProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.initializeWeaponItem(null);
    }

    protected BaseStackableProjectileEntity(EntityType<? extends BaseStackableProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.initializeWeaponItem(null);
    }

    protected BaseStackableProjectileEntity(EntityType<? extends BaseStackableProjectileEntity> type, LivingEntity entity, Level world, ItemStack weaponItem) {
        super(type, entity, world);
        this.weaponItem = weaponItem != null && !weaponItem.m_41619_() ? weaponItem.m_41777_() : this.getDefaultWeaponItem();
        this.f_19804_.m_135381_(ID_WEAPON_ITEM, (Object)this.weaponItem);
        this.getPersistentData().m_128365_("WeaponItem", (Tag)this.weaponItem.m_41739_(new CompoundTag()));
        this.f_19804_.m_135381_(ID_CRITICAL, (Object)false);
        this.getPersistentData().m_128379_("IsCritical", false);
        this.originalSlotIndex = -1;
        this.f_19804_.m_135381_(ID_ORIGINAL_SLOT, (Object)this.originalSlotIndex);
        this.getPersistentData().m_128405_("OriginalSlotIndex", this.originalSlotIndex);
        this.updateFoilData();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
        this.f_19804_.m_135372_(ID_SPIN_TICKS, (Object)0);
        this.f_19804_.m_135372_(ID_IMPACTED, (Object)false);
        this.f_19804_.m_135372_(ID_WEAPON_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(ID_PIERCING, (Object)0);
        this.f_19804_.m_135372_(ID_AREA_DAMAGE, (Object)false);
        this.f_19804_.m_135372_(ID_AREA_DAMAGE_RADIUS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ID_AREA_DAMAGE_MULTIPLIER, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135372_(ID_HAS_GRAVITY, (Object)true);
        this.f_19804_.m_135372_(ID_CRITICAL, (Object)false);
        this.f_19804_.m_135372_(ID_ORIGINAL_SLOT, (Object)-1);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("WeaponItem", 10)) {
            this.weaponItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("WeaponItem"));
            if (this.weaponItem.m_41619_()) {
                this.weaponItem = this.getDefaultWeaponItem();
            }
        } else {
            this.weaponItem = this.getDefaultWeaponItem();
        }
        this.f_19804_.m_135381_(ID_WEAPON_ITEM, (Object)this.weaponItem);
        this.getPersistentData().m_128365_("WeaponItem", (Tag)this.weaponItem.m_41739_(new CompoundTag()));
        this.dealtDamage = tag.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_IMPACTED, (Object)tag.m_128471_("HasImpacted"));
        this.f_19804_.m_135381_(ID_SPIN_TICKS, (Object)tag.m_128451_("SpinTicks"));
        if (tag.m_128441_("LastHitEntityId")) {
            this.lastHitEntityId = tag.m_128342_("LastHitEntityId");
        }
        this.breakCount = tag.m_128451_("breakCount");
        this.hitCount = tag.m_128451_("HitCount");
        this.hasHitOwner = tag.m_128471_("HasHitOwner");
        this.pierceLevel = tag.m_128445_("PiercingLevel");
        this.areaDamage = tag.m_128471_("AreaDamage");
        this.areaDamageRadius = tag.m_128457_("AreaDamageRadius");
        this.areaDamageMultiplier = tag.m_128441_("AreaDamageMultiplier") ? tag.m_128457_("AreaDamageMultiplier") : 0.5f;
        this.hasGravity = tag.m_128441_("HasGravity") ? tag.m_128471_("HasGravity") : true;
        this.f_19804_.m_135381_(ID_CRITICAL, (Object)tag.m_128471_("IsCritical"));
        this.getPersistentData().m_128379_("IsCritical", tag.m_128471_("IsCritical"));
        this.originalSlotIndex = tag.m_128451_("OriginalSlotIndex");
        this.f_19804_.m_135381_(ID_ORIGINAL_SLOT, (Object)this.originalSlotIndex);
        if (tag.m_128425_("PiercingIgnoreEntityIds", 11)) {
            this.piercingIgnoreEntityIds = new IntOpenHashSet(tag.m_128465_("PiercingIgnoreEntityIds"));
        }
        if (tag.m_128425_("PiercedAndKilledEntities", 9)) {
            ListTag piercedList = tag.m_128437_("PiercedAndKilledEntities", 11);
            this.piercedAndKilledEntities.clear();
            for (Tag uuidTag : piercedList) {
                this.piercedAndKilledEntities.add(NbtUtils.m_129233_((Tag)uuidTag));
            }
        }
        this.getPersistentData().m_128405_("breakCount", this.breakCount);
        this.getPersistentData().m_128405_("HitCount", this.hitCount);
        this.getPersistentData().m_128379_("HasHitOwner", this.hasHitOwner);
        this.getPersistentData().m_128344_("PiercingLevel", (byte)this.pierceLevel);
        this.getPersistentData().m_128379_("AreaDamage", this.areaDamage);
        this.getPersistentData().m_128350_("AreaDamageRadius", this.areaDamageRadius);
        this.getPersistentData().m_128350_("AreaDamageMultiplier", this.areaDamageMultiplier);
        this.getPersistentData().m_128379_("HasGravity", this.hasGravity);
        this.getPersistentData().m_128350_("BaseWeaponDamage", tag.m_128457_("BaseWeaponDamage"));
        this.getPersistentData().m_128350_("WeaponKnockbackStrength", tag.m_128441_("WeaponKnockbackStrength") ? tag.m_128457_("WeaponKnockbackStrength") : 0.6f);
        this.getPersistentData().m_128405_("OriginalSlotIndex", this.originalSlotIndex);
        this.updateFoilData();
        this.f_19804_.m_135381_(ID_PIERCING, (Object)((byte)this.pierceLevel));
        this.f_19804_.m_135381_(ID_AREA_DAMAGE, (Object)this.areaDamage);
        this.f_19804_.m_135381_(ID_AREA_DAMAGE_RADIUS, (Object)Float.valueOf(this.areaDamageRadius));
        this.f_19804_.m_135381_(ID_AREA_DAMAGE_MULTIPLIER, (Object)Float.valueOf(this.areaDamageMultiplier));
        this.f_19804_.m_135381_(ID_HAS_GRAVITY, (Object)this.hasGravity);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (!this.weaponItem.m_41619_()) {
            tag.m_128365_("WeaponItem", (Tag)this.weaponItem.m_41739_(new CompoundTag()));
        }
        tag.m_128379_("DealtDamage", this.dealtDamage);
        tag.m_128379_("HasImpacted", ((Boolean)this.f_19804_.m_135370_(ID_IMPACTED)).booleanValue());
        tag.m_128405_("SpinTicks", ((Integer)this.f_19804_.m_135370_(ID_SPIN_TICKS)).intValue());
        if (this.lastHitEntityId != null) {
            tag.m_128362_("LastHitEntityId", this.lastHitEntityId);
        }
        tag.m_128405_("breakCount", this.breakCount);
        tag.m_128405_("HitCount", this.hitCount);
        tag.m_128379_("HasHitOwner", this.hasHitOwner);
        tag.m_128344_("PiercingLevel", (byte)this.pierceLevel);
        tag.m_128385_("PiercingIgnoreEntityIds", this.piercingIgnoreEntityIds.toIntArray());
        ListTag piercedList = new ListTag();
        for (UUID uuid : this.piercedAndKilledEntities) {
            piercedList.add((Object)NbtUtils.m_129226_((UUID)uuid));
        }
        tag.m_128365_("PiercedAndKilledEntities", (Tag)piercedList);
        tag.m_128379_("AreaDamage", this.areaDamage);
        tag.m_128350_("AreaDamageRadius", this.areaDamageRadius);
        tag.m_128350_("AreaDamageMultiplier", this.areaDamageMultiplier);
        tag.m_128379_("HasGravity", this.hasGravity);
        tag.m_128350_("BaseWeaponDamage", this.getPersistentData().m_128457_("BaseWeaponDamage"));
        tag.m_128350_("WeaponKnockbackStrength", this.getPersistentData().m_128457_("WeaponKnockbackStrength"));
        tag.m_128379_("IsCritical", this.isCritical());
        tag.m_128405_("OriginalSlotIndex", this.originalSlotIndex);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.weaponItem);
        buffer.writeBoolean(this.dealtDamage);
        buffer.writeBoolean(this.lastHitEntityId != null);
        if (this.lastHitEntityId != null) {
            buffer.m_130077_(this.lastHitEntityId);
        }
        buffer.writeInt(this.breakCount);
        buffer.writeInt(this.hitCount);
        buffer.writeBoolean(this.hasHitOwner);
        buffer.writeByte(this.pierceLevel);
        buffer.writeInt(this.piercingIgnoreEntityIds.size());
        IntIterator intIterator = this.piercingIgnoreEntityIds.iterator();
        while (intIterator.hasNext()) {
            int id = (Integer)intIterator.next();
            buffer.writeInt(id);
        }
        buffer.writeInt(this.piercedAndKilledEntities.size());
        for (UUID uuid : this.piercedAndKilledEntities) {
            buffer.m_130077_(uuid);
        }
        buffer.writeBoolean(this.areaDamage);
        buffer.writeFloat(this.areaDamageRadius);
        buffer.writeFloat(this.areaDamageMultiplier);
        buffer.writeBoolean(this.hasGravity);
        buffer.writeFloat(this.getPersistentData().m_128457_("BaseWeaponDamage"));
        buffer.writeFloat(this.getPersistentData().m_128457_("WeaponKnockbackStrength"));
        buffer.writeBoolean(this.isCritical());
        buffer.writeInt(this.originalSlotIndex);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.weaponItem = additionalData.m_130267_();
        this.dealtDamage = additionalData.readBoolean();
        if (additionalData.readBoolean()) {
            this.lastHitEntityId = additionalData.m_130259_();
        }
        this.breakCount = additionalData.readInt();
        this.hitCount = additionalData.readInt();
        this.hasHitOwner = additionalData.readBoolean();
        this.pierceLevel = additionalData.readByte();
        int piercingIgnoreCount = additionalData.readInt();
        this.piercingIgnoreEntityIds.clear();
        for (int i = 0; i < piercingIgnoreCount; ++i) {
            this.piercingIgnoreEntityIds.add(additionalData.readInt());
        }
        int piercedEntityCount = additionalData.readInt();
        this.piercedAndKilledEntities.clear();
        for (int i = 0; i < piercedEntityCount; ++i) {
            this.piercedAndKilledEntities.add(additionalData.m_130259_());
        }
        this.areaDamage = additionalData.readBoolean();
        this.areaDamageRadius = additionalData.readFloat();
        this.areaDamageMultiplier = additionalData.readFloat();
        this.hasGravity = additionalData.readBoolean();
        this.getPersistentData().m_128350_("BaseWeaponDamage", additionalData.readFloat());
        this.getPersistentData().m_128350_("WeaponKnockbackStrength", additionalData.readFloat());
        this.f_19804_.m_135381_(ID_CRITICAL, (Object)additionalData.readBoolean());
        this.getPersistentData().m_128379_("IsCritical", ((Boolean)this.f_19804_.m_135370_(ID_CRITICAL)).booleanValue());
        this.originalSlotIndex = additionalData.readInt();
        this.f_19804_.m_135381_(ID_ORIGINAL_SLOT, (Object)this.originalSlotIndex);
        this.getPersistentData().m_128405_("OriginalSlotIndex", this.originalSlotIndex);
        this.f_19804_.m_135381_(ID_WEAPON_ITEM, (Object)this.weaponItem);
        this.f_19804_.m_135381_(ID_PIERCING, (Object)((byte)this.pierceLevel));
        this.f_19804_.m_135381_(ID_AREA_DAMAGE, (Object)this.areaDamage);
        this.f_19804_.m_135381_(ID_AREA_DAMAGE_RADIUS, (Object)Float.valueOf(this.areaDamageRadius));
        this.f_19804_.m_135381_(ID_AREA_DAMAGE_MULTIPLIER, (Object)Float.valueOf(this.areaDamageMultiplier));
        this.f_19804_.m_135381_(ID_HAS_GRAVITY, (Object)this.hasGravity);
        this.getPersistentData().m_128365_("WeaponItem", (Tag)this.weaponItem.m_41739_(new CompoundTag()));
        this.getPersistentData().m_128405_("breakCount", this.breakCount);
        this.getPersistentData().m_128405_("HitCount", this.hitCount);
        this.getPersistentData().m_128379_("HasHitOwner", this.hasHitOwner);
        this.getPersistentData().m_128344_("PiercingLevel", (byte)this.pierceLevel);
        this.getPersistentData().m_128379_("AreaDamage", this.areaDamage);
        this.getPersistentData().m_128350_("AreaDamageRadius", this.areaDamageRadius);
        this.getPersistentData().m_128350_("AreaDamageMultiplier", this.areaDamageMultiplier);
        this.getPersistentData().m_128379_("HasGravity", this.hasGravity);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (ID_WEAPON_ITEM.equals(key)) {
            ItemStack newWeaponItem = (ItemStack)this.f_19804_.m_135370_(ID_WEAPON_ITEM);
            if (!ItemStack.m_41728_((ItemStack)this.weaponItem, (ItemStack)newWeaponItem)) {
                this.weaponItem = newWeaponItem.m_41619_() ? this.getDefaultWeaponItem() : newWeaponItem.m_41777_();
                this.updateFoilData();
                this.getPersistentData().m_128365_("WeaponItem", (Tag)this.weaponItem.m_41739_(new CompoundTag()));
            }
        } else if (ID_PIERCING.equals(key)) {
            this.pierceLevel = ((Byte)this.f_19804_.m_135370_(ID_PIERCING)).byteValue();
            this.getPersistentData().m_128344_("PiercingLevel", (byte)this.pierceLevel);
        } else if (ID_AREA_DAMAGE.equals(key)) {
            this.areaDamage = (Boolean)this.f_19804_.m_135370_(ID_AREA_DAMAGE);
            this.getPersistentData().m_128379_("AreaDamage", this.areaDamage);
        } else if (ID_AREA_DAMAGE_RADIUS.equals(key)) {
            this.areaDamageRadius = ((Float)this.f_19804_.m_135370_(ID_AREA_DAMAGE_RADIUS)).floatValue();
            this.getPersistentData().m_128350_("AreaDamageRadius", this.areaDamageRadius);
        } else if (ID_AREA_DAMAGE_MULTIPLIER.equals(key)) {
            this.areaDamageMultiplier = ((Float)this.f_19804_.m_135370_(ID_AREA_DAMAGE_MULTIPLIER)).floatValue();
            this.getPersistentData().m_128350_("AreaDamageMultiplier", this.areaDamageMultiplier);
        } else if (ID_HAS_GRAVITY.equals(key)) {
            this.hasGravity = (Boolean)this.f_19804_.m_135370_(ID_HAS_GRAVITY);
            this.getPersistentData().m_128379_("HasGravity", this.hasGravity);
        } else if (ID_CRITICAL.equals(key)) {
            this.getPersistentData().m_128379_("IsCritical", ((Boolean)this.f_19804_.m_135370_(ID_CRITICAL)).booleanValue());
        } else if (ID_ORIGINAL_SLOT.equals(key)) {
            this.originalSlotIndex = (Integer)this.f_19804_.m_135370_(ID_ORIGINAL_SLOT);
            this.getPersistentData().m_128405_("OriginalSlotIndex", this.originalSlotIndex);
        }
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        if (this.m_9236_().f_46443_ || !(this.m_9236_() instanceof ServerLevel)) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        UUID entityUUID = entity.m_20148_();
        Entity owner = this.m_19749_();
        if (entityUUID == null || owner == null) {
            return;
        }
        if (entity == owner && this.hasHitOwner) {
            return;
        }
        if (entity == owner) {
            this.hasHitOwner = true;
            this.getPersistentData().m_128379_("HasHitOwner", true);
        }
        if (this.pierceLevel > 0 && this.piercingIgnoreEntityIds.contains(entity.m_19879_())) {
            return;
        }
        boolean isSameEntity = entityUUID.equals(this.lastHitEntityId);
        if (isSameEntity && this.hitCount >= this.getMaxHits() && this.pierceLevel <= 0) {
            if (this.shouldBreakOnEntityHit()) {
                this.handleItemBreak();
            } else {
                this.m_146870_();
            }
            return;
        }
        if (!isSameEntity) {
            this.hitCount = 1;
            this.lastHitEntityId = entityUUID;
        } else {
            ++this.hitCount;
        }
        this.getPersistentData().m_128405_("HitCount", this.hitCount);
        DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float damage = this.calculateDamage((Entity)livingEntity);
            if (livingEntity.m_21254_()) {
                if (owner instanceof LivingEntity) {
                    LivingEntity ownerLivingEntity = (LivingEntity)owner;
                    if (this.canDisableShield(livingEntity.m_21211_(), livingEntity, (Entity)ownerLivingEntity)) {
                        livingEntity.m_6469_(damageSource, damage);
                        this.handleBlocking(livingEntity, owner);
                        return;
                    }
                }
                livingEntity.m_6469_(damageSource, damage);
                this.setCritical(false);
                this.reverseMovementAndRotation();
                this.stopProjectile();
                this.f_19804_.m_135381_(ID_IMPACTED, (Object)true);
                this.m_5496_(SoundEvents.f_12346_, 1.0f, 1.0f);
                if (this.shouldBreakOnEntityHit()) {
                    this.handleItemBreak();
                }
                return;
            }
            livingEntity.f_19802_ = 0;
            boolean damageApplied = livingEntity.m_6469_(damageSource, damage);
            if (damageApplied && livingEntity.m_6095_() != EntityType.f_20566_) {
                if (this.isCritical()) {
                    this.spawnCriticalEffects(livingEntity);
                }
                this.applyHitEffects(livingEntity, entityHitResult);
                this.applyKnockback(livingEntity);
                if (this.m_6060_()) {
                    livingEntity.m_20254_(5);
                }
                if (this.areaDamage) {
                    this.applyAreaDamage(livingEntity, damage);
                }
                if (this.pierceLevel > 0) {
                    this.piercingIgnoreEntityIds.add(livingEntity.m_19879_());
                    --this.pierceLevel;
                    this.f_19804_.m_135381_(ID_PIERCING, (Object)((byte)this.pierceLevel));
                    this.getPersistentData().m_128344_("PiercingLevel", (byte)this.pierceLevel);
                    if (!livingEntity.m_6084_()) {
                        this.piercedAndKilledEntities.add(livingEntity.m_20148_());
                    }
                    if (this.pierceLevel <= 0 && this.shouldBreakOnPiercingExhausted()) {
                        this.handleItemBreak();
                        return;
                    }
                } else {
                    this.dealtDamage = true;
                    this.setCritical(false);
                    if (this.shouldBreakOnEntityHit()) {
                        this.handleItemBreak();
                    }
                }
                this.m_5496_(this.getHitSound(), 1.0f, 1.0f);
            } else if (!damageApplied) {
                this.reverseMovementAndRotation();
                this.f_19804_.m_135381_(ID_IMPACTED, (Object)true);
                this.setCritical(false);
                this.stopProjectile();
                if (livingEntity.m_6095_() != EntityType.f_20566_) {
                    this.m_5496_(this.getHitSound(), 1.0f, 1.0f);
                }
            }
        } else {
            float damage = this.calculateDamage(null);
            boolean damageApplied = entity.m_6469_(damageSource, damage);
            if (damageApplied) {
                if (!entity.m_6084_()) {
                    this.piercedAndKilledEntities.add(entity.m_20148_());
                }
                if (this.pierceLevel > 0) {
                    this.piercingIgnoreEntityIds.add(entity.m_19879_());
                    --this.pierceLevel;
                    this.f_19804_.m_135381_(ID_PIERCING, (Object)((byte)this.pierceLevel));
                    this.getPersistentData().m_128344_("PiercingLevel", (byte)this.pierceLevel);
                    if (this.pierceLevel <= 0 && this.shouldBreakOnPiercingExhausted()) {
                        this.reverseMovementAndRotation();
                        return;
                    }
                } else {
                    this.dealtDamage = true;
                    this.setCritical(false);
                }
                this.m_5496_(this.getHitSound(), 1.0f, 1.0f);
            }
            if (this.pierceLevel <= 0) {
                this.reverseMovementAndRotation();
                this.f_19804_.m_135381_(ID_IMPACTED, (Object)true);
                this.setCritical(false);
            }
        }
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        BlockPos pos = blockHitResult.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        Direction hitFace = blockHitResult.m_82434_();
        Vec3 vec3 = blockHitResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
        this.f_36703_ = true;
        this.f_36706_ = 3;
        this.f_19864_ = true;
        this.m_36762_(false);
        this.m_36767_((byte)0);
        this.m_36793_(false);
        this.setCritical(false);
        this.f_19804_.m_135381_(ID_IMPACTED, (Object)true);
        this.lastHitEntityId = null;
        this.m_36723_();
        if (this.areaDamage) {
            this.applyAreaDamage(null, this.calculateDamage(null));
        }
        this.applyBlockHitEffects(pos, state, blockHitResult);
        BlockState blockstate = this.m_9236_().m_8055_(blockHitResult.m_82425_());
        blockstate.m_60669_(this.m_9236_(), blockstate, blockHitResult, (Projectile)this);
        if (!this.m_9236_().f_46443_) {
            if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
                this.spawnBlockParticles(pos);
            }
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.weaponItem) > 0) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, 0.1, 0.1, 0.1, 0.0);
            }
            this.tryBreakBlock(pos, state, hitFace);
            if (this.shouldBreakOnBlockHit()) {
                this.handleItemBreak();
            }
        }
        this.m_5496_(this.getGroundSound(), 1.0f, 1.0f);
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            this.syncPersistentDataToEntityData();
            this.m_20242_(!this.getHasGravity());
            if (this.m_20077_() && ((Boolean)JaamsWeaponryCommonConfiguration.DROPASITEMLAVA.get()).booleanValue()) {
                this.dropAsItem();
                this.m_146870_();
                return;
            }
            if (this.m_20069_()) {
                this.bubbleTime = !this.f_36703_ ? ++this.bubbleTime : 0;
            }
        }
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        if (this.f_36704_ > 1 && !((Boolean)this.f_19804_.m_135370_(ID_IMPACTED)).booleanValue()) {
            this.f_19804_.m_135381_(ID_IMPACTED, (Object)true);
        }
        if (this.f_36703_) {
            this.f_19804_.m_135381_(ID_SPIN_TICKS, (Object)0);
            if (this.isMultishotClone()) {
                ++this.multishotGroundTicks;
                if (this.multishotGroundTicks >= 15) {
                    this.handleMultishotCloneBreak();
                }
            }
        } else {
            this.f_19804_.m_135381_(ID_SPIN_TICKS, (Object)((Integer)this.f_19804_.m_135370_(ID_SPIN_TICKS) + 1));
            this.multishotGroundTicks = 0;
        }
        this.handleMobPickup();
    }

    public void m_6123_(Player player) {
        if (!this.m_9236_().f_46443_ && (this.f_36703_ || this.m_36797_()) && this.f_36706_ <= 0 && this.m_142470_(player)) {
            player.m_7938_((Entity)this, 1);
            this.m_146870_();
        }
    }

    protected boolean m_142470_(Player player) {
        switch (this.f_36705_) {
            case ALLOWED: {
                ItemStack slotStack;
                int i;
                Entity owner = this.m_19749_();
                if (owner != null) {
                    if (owner instanceof Player) {
                        if (!owner.m_20148_().equals(player.m_20148_())) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (player.m_150110_().f_35937_) {
                    return false;
                }
                ItemStack pickupItemStack = this.m_7941_().m_41777_();
                pickupItemStack.m_41764_(1);
                Inventory inventory = player.m_150109_();
                for (i = 0; i < inventory.m_6643_(); ++i) {
                    ItemStack slotStack2 = inventory.m_8020_(i);
                    if (!slotStack2.m_150930_(pickupItemStack.m_41720_()) || !ItemStack.m_150942_((ItemStack)slotStack2, (ItemStack)pickupItemStack) || slotStack2.m_41613_() >= slotStack2.m_41741_()) continue;
                    slotStack2.m_41769_(1);
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                    return true;
                }
                if (this.originalSlotIndex >= 0 && (this.originalSlotIndex <= 8 || this.originalSlotIndex == 40) && (slotStack = inventory.m_8020_(this.originalSlotIndex)).m_41619_()) {
                    inventory.m_6836_(this.originalSlotIndex, pickupItemStack);
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                    return true;
                }
                for (i = 0; i <= 8; ++i) {
                    ItemStack hotbarStack;
                    if (i == this.originalSlotIndex || !(hotbarStack = inventory.m_8020_(i)).m_41619_()) continue;
                    inventory.m_6836_(i, pickupItemStack);
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                    return true;
                }
                boolean result = inventory.m_36054_(pickupItemStack);
                if (result) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                } else if (!this.m_9236_().f_46443_) {
                    this.dropAsItem();
                }
                return result;
            }
            case CREATIVE_ONLY: {
                return player.m_150110_().f_35937_;
            }
        }
        return false;
    }

    protected ItemStack m_7941_() {
        ItemStack itemStack = this.weaponItem.m_41777_();
        itemStack.m_41764_(1);
        return itemStack;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_271165_;
    }

    public int m_6078_() {
        return 72000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    protected float m_6882_() {
        return 0.89f;
    }

    public void initializeWeaponItem(ItemStack weaponItem) {
        this.weaponItem = weaponItem != null && !weaponItem.m_41619_() ? weaponItem.m_41777_() : this.getDefaultWeaponItem();
        this.f_19804_.m_135381_(ID_WEAPON_ITEM, (Object)this.weaponItem);
        this.getPersistentData().m_128365_("WeaponItem", (Tag)this.weaponItem.m_41739_(new CompoundTag()));
        this.updateFoilData();
    }

    public void updateFoilData() {
        this.f_19804_.m_135381_(ID_FOIL, (Object)this.weaponItem.m_41790_());
    }

    protected void handleBlocking(LivingEntity livingEntity, Entity owner) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.lastHitEntityId = livingEntity.m_20148_();
            if (!player.m_36335_().m_41519_(player.m_21211_().m_41720_())) {
                player.m_36335_().m_41524_(player.m_21211_().m_41720_(), this.getShieldDisableTicks());
            }
            player.m_5810_();
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12347_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.f_19804_.m_135381_(ID_IMPACTED, (Object)true);
        this.setCritical(false);
        if (!this.getHasGravity()) {
            this.m_20242_(true);
        }
        if (this.shouldBreakOnEntityHit()) {
            this.handleItemBreak();
        }
    }

    protected int getShieldDisableTicks() {
        return 100;
    }

    public void spawnCriticalEffects(LivingEntity hitLivingEntity) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        for (int i = 0; i < 8; ++i) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, hitLivingEntity.m_20185_() + serverLevel.m_213780_().m_188583_() * 0.5, hitLivingEntity.m_20186_() + (double)hitLivingEntity.m_20206_() * 0.5 + serverLevel.m_213780_().m_188583_() * 0.5, hitLivingEntity.m_20189_() + serverLevel.m_213780_().m_188583_() * 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        serverLevel.m_6263_(null, hitLivingEntity.m_20185_(), hitLivingEntity.m_20186_(), hitLivingEntity.m_20189_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void handleItemBreak() {
        if (!this.m_9236_().f_46443_ && !this.weaponItem.m_41619_()) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.weaponItem.m_41777_()), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 5, 0.1, 0.1, 0.1, 0.05);
        }
        this.m_146870_();
    }

    public void handleMultishotCloneBreak() {
        if (!this.m_9236_().m_5776_() && !this.weaponItem.m_41619_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.weaponItem.m_41777_()), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 5, 0.1, 0.1, 0.1, 0.05);
            this.m_146870_();
        }
    }

    public void dropAsItem() {
        if (!this.m_9236_().f_46443_) {
            ItemStack itemToSpawn = this.weaponItem.m_41777_();
            itemToSpawn.m_41764_(1);
            ItemEntity entityToSpawn = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), itemToSpawn);
            entityToSpawn.m_32010_(10);
            this.m_9236_().m_7967_((Entity)entityToSpawn);
        }
    }

    protected void handleMobPickup() {
        Entity entity;
        if (this.f_36703_ && (entity = this.m_19749_()) instanceof Mob) {
            Mob mobOwner = (Mob)entity;
            double pickupRange = 1.5;
            if (this.m_20182_().m_82554_(mobOwner.m_20182_()) <= pickupRange && this.tryMobPickup((LivingEntity)mobOwner)) {
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 0.2f, 1.0f);
                }
                this.m_146870_();
            }
        }
    }

    protected boolean tryMobPickup(LivingEntity entity) {
        Mob mob;
        block10: {
            block9: {
                if (!(entity instanceof Mob)) break block9;
                mob = (Mob)entity;
                if (!this.m_213877_()) break block10;
            }
            return false;
        }
        if (this.isMultishotClone()) {
            this.playPickupSound(mob);
            this.m_146870_();
            return false;
        }
        ItemStack pickupItemStack = this.m_7941_().m_41777_();
        pickupItemStack.m_41764_(1);
        ItemStack mainHandStack = mob.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHandStack = mob.m_21120_(InteractionHand.OFF_HAND);
        if (!(mainHandStack.m_41619_() || offHandStack.m_41619_() || mainHandStack.m_150930_(pickupItemStack.m_41720_()) && mainHandStack.m_41613_() < mainHandStack.m_41741_() || offHandStack.m_150930_(pickupItemStack.m_41720_()) && offHandStack.m_41613_() < offHandStack.m_41741_())) {
            return false;
        }
        if (!mainHandStack.m_41619_() && mainHandStack.m_150930_(pickupItemStack.m_41720_()) && mainHandStack.m_41613_() < mainHandStack.m_41741_()) {
            mainHandStack.m_41769_(1);
            this.playPickupSound(mob);
            return true;
        }
        if (!offHandStack.m_41619_() && offHandStack.m_150930_(pickupItemStack.m_41720_()) && offHandStack.m_41613_() < offHandStack.m_41741_()) {
            offHandStack.m_41769_(1);
            this.playPickupSound(mob);
            return true;
        }
        if (mainHandStack.m_41619_()) {
            mob.m_21008_(InteractionHand.MAIN_HAND, pickupItemStack);
            this.playPickupSound(mob);
            return true;
        }
        if (offHandStack.m_41619_()) {
            mob.m_21008_(InteractionHand.OFF_HAND, pickupItemStack);
            this.playPickupSound(mob);
            return true;
        }
        return false;
    }

    private void playPickupSound(Mob mob) {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 0.2f, 1.0f);
        }
    }

    protected void tryBreakBlock(BlockPos pos, BlockState state, Direction hitFace) {
        if (this.m_9236_().f_46443_ || this == null) {
            return;
        }
        if (this.breakCount >= this.getMaxBreaks()) {
            return;
        }
        if (ModUtils.isProjectileBreakableBlock(state) || this.isCustomBreakableBlock(state)) {
            this.m_9236_().m_46961_(pos, true);
            ++this.breakCount;
            this.getPersistentData().m_128405_("breakCount", this.breakCount);
        }
        if (this.breakCount < this.getMaxBreaks()) {
            BlockPos adjacentPos = pos.m_121945_(hitFace);
            BlockState adjacentState = this.m_9236_().m_8055_(adjacentPos);
            if (adjacentState.m_60713_(Blocks.f_50033_)) {
                this.m_9236_().m_46961_(adjacentPos, true);
                ++this.breakCount;
                this.getPersistentData().m_128405_("breakCount", this.breakCount);
            }
        }
        if (this.breakCount >= this.getMaxBreaks()) {
            this.handleItemBreak();
        }
    }

    protected boolean isCustomBreakableBlock(BlockState state) {
        return false;
    }

    public void spawnBlockParticles(BlockPos pos) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        BlockState state = this.m_9236_().m_8055_(pos);
        for (ServerPlayer player : ((ServerLevel)this.m_9236_()).m_6907_()) {
            if (!(player.m_20275_(this.m_20185_(), this.m_20186_(), this.m_20189_()) < 256.0)) continue;
            ((ServerLevel)this.m_9236_()).m_8624_(player, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(pos), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6, 0.1, 0.1, 0.1, 0.05);
        }
    }

    protected void reverseMovementAndRotation() {
        this.m_20256_(this.m_20184_().m_82490_(-0.1));
        this.m_146922_(this.m_146908_() + 180.0f);
        this.f_19859_ += 180.0f;
    }

    protected void applyAreaDamage(@Nullable LivingEntity hitEntity, float baseDamage) {
        if (!this.m_9236_().f_46443_ && this.areaDamage && this.areaDamageRadius > 0.0f) {
            AABB aabb = new AABB(this.m_20185_() - (double)this.areaDamageRadius, this.m_20186_() - (double)this.areaDamageRadius, this.m_20189_() - (double)this.areaDamageRadius, this.m_20185_() + (double)this.areaDamageRadius, this.m_20186_() + (double)this.areaDamageRadius, this.m_20189_() + (double)this.areaDamageRadius);
            List nearbyEntities = this.m_9236_().m_6249_((Entity)this, aabb, entity -> entity instanceof LivingEntity && entity != this.m_19749_() && entity != hitEntity);
            DamageSource damageSource = this.m_269291_().m_269418_((AbstractArrow)this, (Entity)(this.m_19749_() == null ? this : this.m_19749_()));
            for (Entity entity2 : nearbyEntities) {
                if (!(entity2 instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity2;
                float distance = (float)this.m_20182_().m_82554_(entity2.m_20182_());
                float damageMultiplier = Math.max(0.0f, 1.0f - distance / this.areaDamageRadius);
                float areaDamage = baseDamage * damageMultiplier * this.areaDamageMultiplier;
                livingEntity.m_6469_(damageSource, areaDamage);
                this.applyHitEffects(livingEntity, new EntityHitResult((Entity)livingEntity));
            }
        }
    }

    protected float calculateDamage(@Nullable Entity entity) {
        float baseDamage;
        float f = baseDamage = this.getPersistentData().m_128441_("BaseWeaponDamage") ? this.getPersistentData().m_128457_("BaseWeaponDamage") : 1.0f;
        if (entity instanceof LivingEntity && this.isCritical()) {
            baseDamage *= 1.5f;
        }
        return Math.max(0.0f, baseDamage);
    }

    protected void applyKnockback(LivingEntity entity) {
        float knockbackStrength = this.getPersistentData().m_128457_("WeaponKnockbackStrength");
        Vec3 delta = this.m_20184_().m_82541_().m_82490_((double)knockbackStrength);
        entity.m_5997_(delta.f_82479_, delta.f_82480_ * 0.5, delta.f_82481_);
    }

    protected void stopProjectile() {
        this.setHasGravity(true);
        this.m_20242_(false);
    }

    public void setWeaponItem(ItemStack newWeaponItem) {
        ItemStack itemStack = this.weaponItem = newWeaponItem != null && !newWeaponItem.m_41619_() ? newWeaponItem.m_41777_() : this.getDefaultWeaponItem();
        if (!ItemStack.m_41728_((ItemStack)((ItemStack)this.f_19804_.m_135370_(ID_WEAPON_ITEM)), (ItemStack)this.weaponItem)) {
            this.f_19804_.m_135381_(ID_WEAPON_ITEM, (Object)this.weaponItem);
            this.getPersistentData().m_128365_("WeaponItem", (Tag)this.weaponItem.m_41739_(new CompoundTag()));
            this.updateFoilData();
        }
    }

    public void syncPersistentDataToEntityData() {
        boolean nbtCritical;
        ItemStack persistentItem;
        CompoundTag persistentData = this.getPersistentData();
        if (persistentData.m_128425_("WeaponItem", 10) && !ItemStack.m_41728_((ItemStack)(persistentItem = ItemStack.m_41712_((CompoundTag)persistentData.m_128469_("WeaponItem"))), (ItemStack)this.weaponItem) && !persistentItem.m_41619_()) {
            this.weaponItem = persistentItem.m_41777_();
            this.f_19804_.m_135381_(ID_WEAPON_ITEM, (Object)this.weaponItem);
            this.updateFoilData();
        }
        if (persistentData.m_128441_("breakCount")) {
            this.breakCount = persistentData.m_128451_("breakCount");
        }
        if (persistentData.m_128441_("HitCount")) {
            this.hitCount = persistentData.m_128451_("HitCount");
        }
        if (persistentData.m_128441_("HasHitOwner")) {
            this.hasHitOwner = persistentData.m_128471_("HasHitOwner");
        }
        if (persistentData.m_128441_("PiercingLevel")) {
            this.pierceLevel = persistentData.m_128445_("PiercingLevel");
            this.f_19804_.m_135381_(ID_PIERCING, (Object)((byte)this.pierceLevel));
        }
        if (persistentData.m_128441_("AreaDamage")) {
            this.areaDamage = persistentData.m_128471_("AreaDamage");
            this.f_19804_.m_135381_(ID_AREA_DAMAGE, (Object)this.areaDamage);
        }
        if (persistentData.m_128441_("AreaDamageRadius")) {
            this.areaDamageRadius = persistentData.m_128457_("AreaDamageRadius");
            this.f_19804_.m_135381_(ID_AREA_DAMAGE_RADIUS, (Object)Float.valueOf(this.areaDamageRadius));
        }
        if (persistentData.m_128441_("AreaDamageMultiplier")) {
            this.areaDamageMultiplier = persistentData.m_128457_("AreaDamageMultiplier");
            this.f_19804_.m_135381_(ID_AREA_DAMAGE_MULTIPLIER, (Object)Float.valueOf(this.areaDamageMultiplier));
        }
        if (persistentData.m_128441_("HasGravity")) {
            this.hasGravity = persistentData.m_128471_("HasGravity");
            this.f_19804_.m_135381_(ID_HAS_GRAVITY, (Object)this.hasGravity);
        }
        if (persistentData.m_128441_("IsCritical") && (nbtCritical = persistentData.m_128471_("IsCritical")) != this.isCritical()) {
            this.setCritical(nbtCritical);
        }
        if (persistentData.m_128441_("OriginalSlotIndex")) {
            this.originalSlotIndex = persistentData.m_128451_("OriginalSlotIndex");
            this.f_19804_.m_135381_(ID_ORIGINAL_SLOT, (Object)this.originalSlotIndex);
        }
    }

    public ItemStack getWeaponItem() {
        return this.weaponItem.m_41777_();
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    public boolean hasImpacted() {
        return (Boolean)this.f_19804_.m_135370_(ID_IMPACTED);
    }

    public int getSpinTicks() {
        return (Integer)this.f_19804_.m_135370_(ID_SPIN_TICKS);
    }

    public void setPiercingLevel(int level) {
        this.pierceLevel = Math.max(0, level);
        this.f_19804_.m_135381_(ID_PIERCING, (Object)((byte)this.pierceLevel));
        this.getPersistentData().m_128344_("PiercingLevel", (byte)this.pierceLevel);
    }

    public int getPiercingLevel() {
        return this.pierceLevel;
    }

    public void m_36723_() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    public void setAreaDamage(boolean enabled, float radius, float multiplier) {
        this.areaDamage = enabled;
        this.areaDamageRadius = Math.max(0.0f, radius);
        this.areaDamageMultiplier = Math.max(0.0f, Math.min(1.0f, multiplier));
        this.f_19804_.m_135381_(ID_AREA_DAMAGE, (Object)this.areaDamage);
        this.f_19804_.m_135381_(ID_AREA_DAMAGE_RADIUS, (Object)Float.valueOf(this.areaDamageRadius));
        this.f_19804_.m_135381_(ID_AREA_DAMAGE_MULTIPLIER, (Object)Float.valueOf(this.areaDamageMultiplier));
        this.getPersistentData().m_128379_("AreaDamage", this.areaDamage);
        this.getPersistentData().m_128350_("AreaDamageRadius", this.areaDamageRadius);
        this.getPersistentData().m_128350_("AreaDamageMultiplier", this.areaDamageMultiplier);
    }

    public boolean hasAreaDamage() {
        return this.areaDamage;
    }

    public float getAreaDamageRadius() {
        return this.areaDamageRadius;
    }

    public float getAreaDamageMultiplier() {
        return this.areaDamageMultiplier;
    }

    public void setHasGravity(boolean hasGravity) {
        this.hasGravity = hasGravity;
        this.f_19804_.m_135381_(ID_HAS_GRAVITY, (Object)hasGravity);
        this.getPersistentData().m_128379_("HasGravity", this.hasGravity);
        this.m_20242_(!hasGravity);
    }

    public boolean getHasGravity() {
        return (Boolean)this.f_19804_.m_135370_(ID_HAS_GRAVITY);
    }

    protected boolean isMultishotClone() {
        return this.getPersistentData().m_128471_("IsMultishotClone");
    }

    public float getWeaponDamageFromData() {
        return this.getPersistentData().m_128457_("BaseWeaponDamage");
    }

    public float getWeaponKnockback() {
        return this.getPersistentData().m_128457_("WeaponKnockbackStrength");
    }

    public void setCritical(boolean critical) {
        this.f_19804_.m_135381_(ID_CRITICAL, (Object)critical);
        this.getPersistentData().m_128379_("IsCritical", critical);
    }

    public boolean isCritical() {
        return (Boolean)this.f_19804_.m_135370_(ID_CRITICAL);
    }

    public void setOriginalSlotIndex(int slotIndex) {
        this.originalSlotIndex = slotIndex >= 0 ? slotIndex : -1;
        this.f_19804_.m_135381_(ID_ORIGINAL_SLOT, (Object)this.originalSlotIndex);
        this.getPersistentData().m_128405_("OriginalSlotIndex", this.originalSlotIndex);
    }
}

