/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.configuration;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class JaamsWeaponryCommonConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> NONDISARMABLEITEMS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DYNAMITEEXPLODE;
    public static final ForgeConfigSpec.ConfigValue<Double> DYNAMITEPOWER;
    public static final ForgeConfigSpec.ConfigValue<Double> DYNAMITETICKS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DYNAMITEBREAKBLOCKS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DROPASITEM;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DROPASITEMLAVA;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SLINGSHOTPLACEABLEBLOCKS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SHORTBOWAUTO;
    public static final ForgeConfigSpec.ConfigValue<Boolean> STAKECROSSBOWALT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> USECUSTOMTRIDENT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SLINGSHOTAMMOFROMINVENTORY;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SLINGSHOTAMMO_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SLINGSHOTAMMO_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<Boolean> INCAPABLE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DEPLETION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> KNOCKEDUP;
    public static final ForgeConfigSpec.ConfigValue<Boolean> VIGOROUSRAGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> WARRIORSGRACE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ARCHERSGRACE;
    public static final ForgeConfigSpec.ConfigValue<Double> SHARPSTONEDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> STAKEDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> SHURIKENDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> KUNAIDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> GIANTSHURIKENDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> PRONGEDKUNAIDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> BROOMDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> SPEARDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> TRIDENTDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> ROYALSPEARDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> ROYALAXEDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> AXEDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> CLEAVERDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> RINGDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Double> HUNTERSBOOMERANGDESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLEGUNINVENTORY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> AMMOFROMGUN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> AMMOFROMPLAYERINVENTORY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> AMMOFROMHAND;
    public static final ForgeConfigSpec.ConfigValue<Boolean> MOBSNEEDAMMO;
    public static final ForgeConfigSpec.ConfigValue<Boolean> RINGBONUS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CLAWBONUS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> BROADSWORDBONUS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> HAMMERBONUS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GAUNTLETBONUS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> KNUCKLESBONUS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> KAMABONUS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> TESSENBONUS;

    static {
        BUILDER.push("Effects Handler");
        INCAPABLE = BUILDER.comment("Enable or disable Incapable status effect").define("Incapable", true);
        DEPLETION = BUILDER.comment("Enable or disable Depletion status effect").define("Depletion", true);
        KNOCKEDUP = BUILDER.comment("Enable or disable Knocked Up status effect").define("Knocked Up", true);
        VIGOROUSRAGE = BUILDER.comment("Enable or disable Vigorous Rage status effect").define("Vigorous Rage", true);
        WARRIORSGRACE = BUILDER.comment("Enable or disable Warrior's Grace status effect").define("Warrior's Grace", true);
        ARCHERSGRACE = BUILDER.comment("Enable or disable Archer's Grace status effect").define("Archer's Grace", true);
        BUILDER.pop();
        BUILDER.push("Weapon Mechanics");
        NONDISARMABLEITEMS = BUILDER.comment("List of item IDs that cannot be disarmed").defineList("Non Disarmable Items", List.of(), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("Dual Hand Bonuses");
        RINGBONUS = BUILDER.comment("Enable or disable bonus for dual wielding rings").define("Ring Bonus", true);
        CLAWBONUS = BUILDER.comment("Enable or disable bonus for dual wielding claws").define("Claw Bonus", true);
        BROADSWORDBONUS = BUILDER.comment("Enable or disable bonus for dual wielding broadswords").define("Broadsword Bonus", true);
        HAMMERBONUS = BUILDER.comment("Enable or disable bonus for dual wielding hammers").define("Hammer Bonus", true);
        GAUNTLETBONUS = BUILDER.comment("Enable or disable bonus for dual wielding gauntlets").define("Gauntlet Bonus", true);
        KNUCKLESBONUS = BUILDER.comment("Enable or disable bonus for dual wielding knuckles").define("Knuckles Bonus", true);
        KAMABONUS = BUILDER.comment("Enable or disable bonus for dual wielding kamas").define("Kama Bonus", true);
        TESSENBONUS = BUILDER.comment("Enable or disable bonus for dual wielding tessen").define("Tessen Bonus", true);
        BUILDER.pop();
        BUILDER.push("Projectile Behavior");
        BUILDER.push("Dynamite Settings");
        DYNAMITEEXPLODE = BUILDER.comment("Set whether dynamite explodes when hitting an entity").define("Dynamite Explode On Hit", false);
        DYNAMITEPOWER = BUILDER.comment("Power of the dynamite explosion").defineInRange("Dynamite Power", 2.0, 1.0, 10.0);
        DYNAMITETICKS = BUILDER.comment("Dynamite explosion time in ticks when grounded").defineInRange("Dynamite Explosion Time", 40.0, 1.0, 1000.0);
        DYNAMITEBREAKBLOCKS = BUILDER.comment("Set whether dynamite can break blocks").define("Dynamite Break Blocks", false);
        BUILDER.pop();
        DROPASITEM = BUILDER.comment("Drop projectile as item when grounded (doesn't work in creative mode)").define("Projectile Drop As Item", false);
        DROPASITEMLAVA = BUILDER.comment("Drop projectile as item when touching lava (doesn't work in creative mode)").define("Projectile Drop As Item In Lava", false);
        SLINGSHOTPLACEABLEBLOCKS = BUILDER.comment("List of block item IDs that can be placed on impact by slingshot projectiles").defineList("Slingshot Placeable Blocks", List.of("minecraft:anvil"), obj -> obj instanceof String);
        BUILDER.push("Projectile Despawn Time");
        SHARPSTONEDESPAWN = BUILDER.comment("Despawn time for sharp stones").defineInRange("Sharp Stone", 800.0, 100.0, 72000.0);
        STAKEDESPAWN = BUILDER.comment("Despawn time for stakes").defineInRange("Stake", 800.0, 100.0, 72000.0);
        SHURIKENDESPAWN = BUILDER.comment("Despawn time for shurikens").defineInRange("Shuriken", 800.0, 100.0, 72000.0);
        KUNAIDESPAWN = BUILDER.comment("Despawn time for kunais").defineInRange("Kunai", 800.0, 100.0, 72000.0);
        GIANTSHURIKENDESPAWN = BUILDER.comment("Despawn time for giant shurikens").defineInRange("Giant Shuriken", 1200.0, 100.0, 72000.0);
        PRONGEDKUNAIDESPAWN = BUILDER.comment("Despawn time for pronged kunais").defineInRange("Pronged Kunai", 1200.0, 100.0, 72000.0);
        BROOMDESPAWN = BUILDER.comment("Despawn time for brooms").defineInRange("Broom", 1200.0, 100.0, 72000.0);
        SPEARDESPAWN = BUILDER.comment("Despawn time for spears").defineInRange("Spear", 1200.0, 100.0, 72000.0);
        TRIDENTDESPAWN = BUILDER.comment("Despawn time for tridents").defineInRange("Trident", 1200.0, 100.0, 72000.0);
        ROYALSPEARDESPAWN = BUILDER.comment("Despawn time for royal spears").defineInRange("Royal Spear", 1200.0, 100.0, 72000.0);
        ROYALAXEDESPAWN = BUILDER.comment("Despawn time for royal axes").defineInRange("Royal Axe", 1200.0, 100.0, 72000.0);
        AXEDESPAWN = BUILDER.comment("Despawn time for axes").defineInRange("Axe", 1200.0, 100.0, 72000.0);
        CLEAVERDESPAWN = BUILDER.comment("Despawn time for cleavers").defineInRange("Cleaver", 1200.0, 100.0, 72000.0);
        RINGDESPAWN = BUILDER.comment("Despawn time for rings").defineInRange("Ring", 1200.0, 100.0, 72000.0);
        HUNTERSBOOMERANGDESPAWN = BUILDER.comment("Despawn time for hunter's boomerang").defineInRange("Hunter's Boomerang", 1200.0, 100.0, 72000.0);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Ranged Items Handler");
        SHORTBOWAUTO = BUILDER.comment("Enable or disable automatic firing for short bows").define("Automatic Short Bow", true);
        STAKECROSSBOWALT = BUILDER.comment("Enable or disable alternative firing for stake crossbow").define("Alternative Stake Crossbow", false);
        USECUSTOMTRIDENT = BUILDER.comment("Enable or disable use custom trident behavior").define("Custom Trident Logic", true);
        BUILDER.push("Slingshot Settings");
        SLINGSHOTAMMOFROMINVENTORY = BUILDER.comment("Take ammo from the player's inventory for slingshot").define("Slingshot Can Pickup Ammo From Inventory", true);
        SLINGSHOTAMMO_WHITELIST = BUILDER.comment("List of block item IDs that are allowed as slingshot ammo").defineList("Slingshot Ammo Whitelist", List.of("minecraft:anvil"), obj -> obj instanceof String);
        SLINGSHOTAMMO_BLACKLIST = BUILDER.comment("List of block item IDs that are not allowed as slingshot ammo").defineList("Slingshot Ammo Blacklist", List.of(), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Gun System Handler");
        ENABLEGUNINVENTORY = BUILDER.comment("Enable or disable the gun inventory").define("Enable Gun Inventory", true);
        AMMOFROMGUN = BUILDER.comment("Take bullets from the gun's inventory").define("Bullet From Gun", true);
        AMMOFROMPLAYERINVENTORY = BUILDER.comment("Take bullets from the player's inventory").define("Bullet From Inventory", false);
        AMMOFROMHAND = BUILDER.comment("Take bullets from the player's hands").define("Bullet From Hand", false);
        MOBSNEEDAMMO = BUILDER.comment("Require mobs to have ammunition to shoot guns").define("Mobs Need Ammo", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

