/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.dispenser;

import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class SmokeBombDispenser
implements DispenseItemBehavior {
    public ItemStack m_6115_(BlockSource source, ItemStack stack) {
        ServerLevel level = source.m_7727_();
        BlockPos relativePos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
        Vec3 pos = new Vec3((double)relativePos.m_123341_() + 0.5, (double)relativePos.m_123342_() + 0.5, (double)relativePos.m_123343_() + 0.5);
        Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        this.applySmokeBombEffects((Level)level, pos, direction);
        stack.m_41774_(1);
        return stack;
    }

    private void applySmokeBombEffects(Level level, Vec3 pos, Direction direction) {
        this.applyBlindnessEffects(level, pos);
        this.spawnParticlesAndSound(level, pos);
        this.applyPush(level, pos, direction);
    }

    private void applyBlindnessEffects(Level level, Vec3 pos) {
        AABB effectArea = new AABB(pos.f_82479_ - 0.5, pos.f_82480_ - 0.5, pos.f_82481_ - 0.5, pos.f_82479_ + 0.5, pos.f_82480_ + 0.5, pos.f_82481_ + 0.5);
        List<Entity> nearbyEntities = level.m_45976_(Entity.class, effectArea).stream().sorted(Comparator.comparingDouble(ent -> ent.m_20238_(pos))).toList();
        for (Entity nearbyEntity : nearbyEntities) {
            if (!(nearbyEntity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)nearbyEntity;
            if (nearbyEntity instanceof Player) {
                Player player = (Player)nearbyEntity;
                if (level.f_46441_.m_188501_() < 0.5f) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 1, false, false, true));
                    continue;
                }
            }
            if (!(livingEntity instanceof Monster)) continue;
            Monster monster = (Monster)livingEntity;
            monster.m_6710_(null);
        }
    }

    private void spawnParticlesAndSound(Level level, Vec3 pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SimpleParticleType primaryParticleType = ParticleTypes.f_123755_;
            int particleCount = 120;
            serverLevel.m_8767_((ParticleOptions)primaryParticleType, pos.f_82479_, pos.f_82480_, pos.f_82481_, particleCount, 0.5, 0.5, 0.5, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_ + 0.1, pos.f_82481_, 10, 0.5, 0.5, 0.5, 0.0);
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:smoke_bomb"));
            if (sound != null) {
                serverLevel.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private void applyPush(Level level, Vec3 pos, Direction direction) {
        AABB effectArea = new AABB(pos.f_82479_ - 0.5, pos.f_82480_ - 0.5, pos.f_82481_ - 0.5, pos.f_82479_ + 0.5, pos.f_82480_ + 0.5, pos.f_82481_ + 0.5);
        List nearbyEntities = level.m_45976_(Entity.class, effectArea);
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            Vec3 pushDirection = new Vec3((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_()).m_82541_();
            double pushX = pushDirection.f_82479_ * 1.5;
            double pushZ = pushDirection.f_82481_ * 1.5;
            double pushY = (double)direction.m_122430_() <= -0.8 ? (double)0.8f : 0.0;
            Vec3 finalPush = new Vec3(pushX, pushY, pushZ);
            entity.m_20256_(finalPush);
            entity.f_19864_ = true;
        }
    }
}

