/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.dyeable;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;

public interface IDyeableItem {
    public static final String TAG_COLOR = "color";

    public int getDefaultColor();

    default public boolean hasColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128425_(TAG_COLOR, 3);
    }

    default public int getColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return this.hasColor(stack) ? tag.m_128451_(TAG_COLOR) : this.getDefaultColor();
    }

    default public void setColor(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(TAG_COLOR, color);
    }

    default public void removeColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_(TAG_COLOR);
    }

    public static boolean isDyeable(ItemStack stack) {
        return stack.m_41720_() instanceof IDyeableItem;
    }

    public static ItemStack dye(ItemStack stack, List<DyeItem> dyes) {
        ItemStack result = ItemStack.f_41583_;
        int[] combinedColors = new int[3];
        int maxColor = 0;
        int colorCount = 0;
        IDyeableItem coloredItem = null;
        if (IDyeableItem.isDyeable(stack)) {
            coloredItem = (IDyeableItem)stack.m_41720_();
            result = stack.m_41777_();
            result.m_41764_(1);
            if (coloredItem.hasColor(stack)) {
                int color = coloredItem.getColor(result);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                maxColor = (int)((float)maxColor + Math.max(r, Math.max(g, b)) * 255.0f);
                combinedColors[0] = (int)((float)combinedColors[0] + r * 255.0f);
                combinedColors[1] = (int)((float)combinedColors[1] + g * 255.0f);
                combinedColors[2] = (int)((float)combinedColors[2] + b * 255.0f);
                ++colorCount;
            }
            for (DyeItem dye : dyes) {
                float[] colorComponents = dye.m_41089_().m_41068_();
                int r = (int)(colorComponents[0] * 255.0f);
                int g = (int)(colorComponents[1] * 255.0f);
                int b = (int)(colorComponents[2] * 255.0f);
                maxColor += Math.max(r, Math.max(g, b));
                combinedColors[0] = combinedColors[0] + r;
                combinedColors[1] = combinedColors[1] + g;
                combinedColors[2] = combinedColors[2] + b;
                ++colorCount;
            }
        }
        if (coloredItem == null) {
            return ItemStack.f_41583_;
        }
        int r = combinedColors[0] / colorCount;
        int g = combinedColors[1] / colorCount;
        int b = combinedColors[2] / colorCount;
        float avgColor = (float)maxColor / (float)colorCount;
        float maxValue = Math.max(r, Math.max(g, b));
        r = (int)((float)r * avgColor / maxValue);
        g = (int)((float)g * avgColor / maxValue);
        b = (int)((float)b * avgColor / maxValue);
        int finalColor = (r << 8) + g;
        finalColor = (finalColor << 8) + b;
        coloredItem.setColor(result, finalColor);
        return result;
    }
}

