/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.entity;

import net.jaams.jaams_weaponry.components.BaseWeaponProjectileEntity;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class BroomProjectileEntity
extends BaseWeaponProjectileEntity {
    private static final int MAX_BOUNCES = 3;
    private int bounceCount = 0;

    public BroomProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends BaseWeaponProjectileEntity>)((EntityType)JaamsWeaponryModEntities.BROOM_PROJECTILE.get()), world);
        this.configureProjectileProperties();
    }

    public BroomProjectileEntity(EntityType<? extends BroomProjectileEntity> type, Level world) {
        super(type, world);
        this.configureProjectileProperties();
    }

    public BroomProjectileEntity(EntityType<? extends BroomProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.configureProjectileProperties();
    }

    public BroomProjectileEntity(EntityType<? extends BroomProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.configureProjectileProperties();
    }

    public BroomProjectileEntity(Level world, LivingEntity entity, ItemStack weaponItem) {
        super((EntityType<? extends BaseWeaponProjectileEntity>)((EntityType)JaamsWeaponryModEntities.BROOM_PROJECTILE.get()), entity, world, weaponItem);
        this.configureProjectileProperties();
    }

    protected void configureProjectileProperties() {
        this.setPiercingLevel(0);
        this.setAreaDamage(false, 0.0f, 0.0f);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)0.6f, (float)0.6f);
    }

    @Override
    public ItemStack getDefaultWeaponItem() {
        return new ItemStack((ItemLike)JaamsWeaponryModItems.BROOM.get());
    }

    @Override
    protected SoundEvent getHitSound() {
        return ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:broom_hit")) != null ? (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:broom_hit")) : SoundEvents.f_12514_;
    }

    @Override
    protected SoundEvent getGroundSound() {
        return ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:broom_ground")) != null ? (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:broom_ground")) : SoundEvents.f_12515_;
    }

    @Override
    protected SoundEvent getLoyaltySound() {
        return ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:broom_return")) != null ? (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:broom_return")) : SoundEvents.f_12516_;
    }

    @Override
    public float getWeaponBaseDamage() {
        return 2.0f;
    }

    @Override
    public int getMaxBreaks() {
        return 1;
    }

    @Override
    public int getMaxHits() {
        return 1;
    }

    @Override
    protected void applyHitEffects(LivingEntity entity, EntityHitResult hitResult) {
    }

    @Override
    protected void applyBlockHitEffects(BlockPos pos, BlockState state, BlockHitResult hitResult) {
    }

    @Override
    public void m_8060_(BlockHitResult blockHitResult) {
        BlockPos pos = blockHitResult.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        Direction hitFace = blockHitResult.m_82434_();
        Vec3 vec3 = blockHitResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
        this.f_36703_ = true;
        this.f_36706_ = 7;
        this.m_36762_(false);
        this.m_36767_((byte)0);
        this.m_36793_(false);
        BlockState blockstate = this.m_9236_().m_8055_(blockHitResult.m_82425_());
        blockstate.m_60669_(this.m_9236_(), blockstate, blockHitResult, (Projectile)this);
        if (blockHitResult.m_6662_() == HitResult.Type.BLOCK && !this.m_9236_().f_46443_) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(blockHitResult.m_82425_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 5, 0.1, 0.1, 0.1, 0.05);
            Direction hitDirection = blockHitResult.m_82434_();
            Vec3i normal = hitDirection.m_122436_();
            if (hitDirection != Direction.UP && this.bounceCount < 3) {
                Vec3 currentVelocity = this.m_20184_();
                Vec3 reverseVelocity = currentVelocity.m_82490_(-0.8);
                Vec3 smoothVelocity = currentVelocity.m_165921_(reverseVelocity, 0.4);
                this.m_20256_(smoothVelocity);
                ++this.bounceCount;
            }
        }
        this.applyBlockHitEffects(pos, state, blockHitResult);
        if (!this.m_9236_().f_46443_ && blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            this.spawnBlockParticles(pos);
        }
        if (!this.m_9236_().f_46443_ && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.weaponItem) > 0) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3, 0.1, 0.1, 0.1, 0.0);
        }
        this.m_5496_(this.getGroundSound(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    @Override
    public float calculateDamage(Entity entity) {
        LivingEntity livingEntity;
        float baseDamage = super.calculateDamage(entity);
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6336_() == MobType.f_21642_) {
            baseDamage += 2.5f;
        }
        return baseDamage;
    }

    @Override
    public void tryBreakBlock(BlockPos pos, BlockState state, Direction hitFace) {
    }

    protected void m_6901_() {
        ++this.life;
        int despawnTime = Math.max(1, (int)((Double)JaamsWeaponryCommonConfiguration.BROOMDESPAWN.get()).doubleValue());
        if (this.life >= despawnTime) {
            ItemStack itemStack;
            if (((Boolean)JaamsWeaponryCommonConfiguration.DROPASITEM.get()).booleanValue() && this.f_36705_ != AbstractArrow.Pickup.CREATIVE_ONLY) {
                this.dropAsItem();
            } else if (!this.m_9236_().f_46443_ && !(itemStack = this.weaponItem.m_41777_()).m_41619_()) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 5, 0.1, 0.1, 0.1, 0.05);
            }
            this.m_146870_();
        }
    }
}

