/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.entity;

import net.jaams.jaams_weaponry.components.BaseBulletProjectileEntity;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class BulletProjectileEntity
extends BaseBulletProjectileEntity {
    public BulletProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends BaseBulletProjectileEntity>)((EntityType)JaamsWeaponryModEntities.BULLET_PROJECTILE.get()), world);
        this.initializeProperties();
    }

    public BulletProjectileEntity(EntityType<? extends BulletProjectileEntity> type, Level world) {
        super(type, world);
        this.initializeProperties();
    }

    public BulletProjectileEntity(EntityType<? extends BulletProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.initializeProperties();
    }

    public BulletProjectileEntity(EntityType<? extends BulletProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.initializeProperties();
    }

    private void initializeProperties() {
        this.setBulletDamage(4.0f);
        this.setBulletKnockback(0.6f);
        this.setHasGravity(false);
        this.setColor(-10496);
    }

    @Override
    public void setBulletDamage(float damage) {
        this.getPersistentData().m_128350_("BaseBulletDamage", Math.max(0.0f, damage));
    }

    @Override
    public void setBulletKnockback(float strength) {
        this.getPersistentData().m_128350_("KnockbackStrength", Math.max(0.0f, strength));
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42587_);
    }

    @Override
    protected SoundEvent getHitSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:bullet_hit"));
        return sound != null ? sound : SoundEvents.f_12514_;
    }

    @Override
    protected SoundEvent getGroundSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:bullet_ground"));
        return sound != null ? sound : SoundEvents.f_12515_;
    }

    @Override
    protected void applyHitEffects(LivingEntity entity, EntityHitResult hitResult) {
    }

    @Override
    protected void applyBlockHitEffects(BlockPos pos, BlockState state, BlockHitResult hitResult) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction face = hitResult.m_82434_();
            double offset = 0.01;
            double x = (double)pos.m_123341_() + 0.5 + (double)face.m_122429_() * (0.5 + offset);
            double y = (double)pos.m_123342_() + 0.5 + (double)face.m_122430_() * (0.5 + offset);
            double z = (double)pos.m_123343_() + 0.5 + (double)face.m_122431_() * (0.5 + offset);
            ItemStack itemStack = new ItemStack((ItemLike)JaamsWeaponryModItems.BULLET.get());
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), x, y, z, 4, 0.1, 0.1, 0.1, 0.05);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 6, 0.1, 0.1, 0.1, 0.05);
        }
    }

    @Override
    public int getMaxBreaks() {
        return 3;
    }

    @Override
    public int getMaxHits() {
        return 1;
    }

    @Override
    public int getMaxTicksInAir() {
        return 20;
    }

    @Override
    public int getMaxTicksInGround() {
        return 3;
    }

    @Override
    public boolean canDisableShield(ItemStack shield, LivingEntity shieldHolder, Entity owner) {
        return false;
    }
}

