/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.entity;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.entity.BroomProjectileEntity;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class DynamiteProjectileEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    protected static final EntityDataAccessor<ItemStack> ID_DYNAMITE_ITEM = SynchedEntityData.m_135353_(DynamiteProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Boolean> ID_IMPACTED = SynchedEntityData.m_135353_(DynamiteProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> ID_TICKS_ON_GROUND = SynchedEntityData.m_135353_(DynamiteProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> ID_SPIN_TICKS = SynchedEntityData.m_135353_(DynamiteProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> ID_ORIGINAL_SLOT = SynchedEntityData.m_135353_(DynamiteProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(DynamiteProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final SoundEvent IGNITING_SOUND = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:dynamite_igniting"));
    public ItemStack dynamiteItem;
    private int bounceCount = 0;
    private int ticksInAir = 0;
    private int bubbleTime = 0;
    protected int originalSlotIndex = -1;
    private static final int maxBounces = 3;
    private static final double explosionRadius = 2.0;
    private static final float baseDamage = 0.5f;
    @Nullable
    private BlockState lastState;
    @Nullable
    private UUID lastHitEntityId;

    public DynamiteProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)JaamsWeaponryModEntities.DYNAMITE_PROJECTILE.get(), world);
        this.initializeDynamiteItem(null);
    }

    public DynamiteProjectileEntity(EntityType<? extends DynamiteProjectileEntity> type, Level world) {
        super(type, world);
        this.initializeDynamiteItem(null);
        this.m_6210_();
    }

    public DynamiteProjectileEntity(EntityType<? extends DynamiteProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.initializeDynamiteItem(null);
        this.m_6210_();
    }

    public DynamiteProjectileEntity(EntityType<? extends DynamiteProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.initializeDynamiteItem(null);
        this.m_6210_();
    }

    public DynamiteProjectileEntity(Level world, LivingEntity entity, ItemStack dynamiteItem) {
        super((EntityType)JaamsWeaponryModEntities.DYNAMITE_PROJECTILE.get(), entity, world);
        this.initializeDynamiteItem(dynamiteItem);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)0.8f, (float)0.8f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_DYNAMITE_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(ID_IMPACTED, (Object)false);
        this.f_19804_.m_135372_(ID_TICKS_ON_GROUND, (Object)0);
        this.f_19804_.m_135372_(ID_SPIN_TICKS, (Object)0);
        this.f_19804_.m_135372_(ID_ORIGINAL_SLOT, (Object)-1);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (!this.dynamiteItem.m_41619_()) {
            tag.m_128365_("DynamiteItem", (Tag)this.dynamiteItem.m_41739_(new CompoundTag()));
        }
        tag.m_128379_("Impacted", ((Boolean)this.f_19804_.m_135370_(ID_IMPACTED)).booleanValue());
        tag.m_128405_("TicksOnGround", ((Integer)this.f_19804_.m_135370_(ID_TICKS_ON_GROUND)).intValue());
        tag.m_128405_("BounceCount", this.bounceCount);
        tag.m_128405_("OriginalSlotIndex", this.originalSlotIndex);
        tag.m_128379_("Foil", ((Boolean)this.f_19804_.m_135370_(ID_FOIL)).booleanValue());
        if (this.lastHitEntityId != null) {
            tag.m_128362_("LastHitEntityId", this.lastHitEntityId);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("DynamiteItem", 10)) {
            this.dynamiteItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("DynamiteItem"));
            if (this.dynamiteItem.m_41619_()) {
                this.dynamiteItem = this.getDefaultDynamiteItem();
            }
        } else {
            this.dynamiteItem = this.getDefaultDynamiteItem();
        }
        this.f_19804_.m_135381_(ID_DYNAMITE_ITEM, (Object)this.dynamiteItem);
        this.getPersistentData().m_128365_("DynamiteItem", (Tag)this.dynamiteItem.m_41739_(new CompoundTag()));
        this.f_19804_.m_135381_(ID_IMPACTED, (Object)tag.m_128471_("Impacted"));
        this.f_19804_.m_135381_(ID_TICKS_ON_GROUND, (Object)tag.m_128451_("TicksOnGround"));
        this.bounceCount = tag.m_128451_("BounceCount");
        this.originalSlotIndex = tag.m_128451_("OriginalSlotIndex");
        this.f_19804_.m_135381_(ID_ORIGINAL_SLOT, (Object)this.originalSlotIndex);
        this.getPersistentData().m_128405_("OriginalSlotIndex", this.originalSlotIndex);
        this.f_19804_.m_135381_(ID_FOIL, (Object)tag.m_128471_("Foil"));
        if (tag.m_128403_("LastHitEntityId")) {
            this.lastHitEntityId = tag.m_128342_("LastHitEntityId");
        }
        this.updateFoilData();
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.dynamiteItem);
        buffer.writeBoolean(((Boolean)this.f_19804_.m_135370_(ID_IMPACTED)).booleanValue());
        buffer.writeInt(((Integer)this.f_19804_.m_135370_(ID_TICKS_ON_GROUND)).intValue());
        buffer.writeInt(this.originalSlotIndex);
        buffer.writeBoolean(((Boolean)this.f_19804_.m_135370_(ID_FOIL)).booleanValue());
        buffer.writeBoolean(this.lastHitEntityId != null);
        if (this.lastHitEntityId != null) {
            buffer.m_130077_(this.lastHitEntityId);
        }
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.dynamiteItem = additionalData.m_130267_();
        if (this.dynamiteItem.m_41619_()) {
            this.dynamiteItem = this.getDefaultDynamiteItem();
        }
        this.f_19804_.m_135381_(ID_DYNAMITE_ITEM, (Object)this.dynamiteItem);
        this.getPersistentData().m_128365_("DynamiteItem", (Tag)this.dynamiteItem.m_41739_(new CompoundTag()));
        this.f_19804_.m_135381_(ID_IMPACTED, (Object)additionalData.readBoolean());
        this.f_19804_.m_135381_(ID_TICKS_ON_GROUND, (Object)additionalData.readInt());
        this.originalSlotIndex = additionalData.readInt();
        this.f_19804_.m_135381_(ID_ORIGINAL_SLOT, (Object)this.originalSlotIndex);
        this.getPersistentData().m_128405_("OriginalSlotIndex", this.originalSlotIndex);
        this.f_19804_.m_135381_(ID_FOIL, (Object)additionalData.readBoolean());
        if (additionalData.readBoolean()) {
            this.lastHitEntityId = additionalData.m_130259_();
        }
        this.updateFoilData();
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (ID_DYNAMITE_ITEM.equals(key)) {
            ItemStack newDynamiteItem = (ItemStack)this.f_19804_.m_135370_(ID_DYNAMITE_ITEM);
            if (!ItemStack.m_41728_((ItemStack)this.dynamiteItem, (ItemStack)newDynamiteItem)) {
                this.dynamiteItem = newDynamiteItem.m_41619_() ? this.getDefaultDynamiteItem() : newDynamiteItem.m_41777_();
                this.updateFoilData();
                this.getPersistentData().m_128365_("DynamiteItem", (Tag)this.dynamiteItem.m_41739_(new CompoundTag()));
            }
        } else if (ID_ORIGINAL_SLOT.equals(key)) {
            this.originalSlotIndex = (Integer)this.f_19804_.m_135370_(ID_ORIGINAL_SLOT);
            this.getPersistentData().m_128405_("OriginalSlotIndex", this.originalSlotIndex);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        UUID entityUUID = entity.m_20148_();
        if (entityUUID == null || entity == this.m_19749_() || this.lastHitEntityId != null && this.lastHitEntityId.equals(entityUUID)) {
            return;
        }
        this.lastHitEntityId = entityUUID;
        entity.m_6469_(this.m_269291_().m_269264_(), 0.5f);
        if (((Boolean)JaamsWeaponryCommonConfiguration.DYNAMITEEXPLODE.get()).booleanValue()) {
            this.explode();
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.006, -0.06, -0.006));
        this.f_19804_.m_135381_(ID_IMPACTED, (Object)true);
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        this.lastState = this.m_9236_().m_8055_(blockHitResult.m_82425_());
        Vec3 vec3 = blockHitResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
        this.f_36703_ = true;
        this.f_36706_ = 7;
        this.m_36762_(false);
        this.m_36767_((byte)0);
        this.m_36793_(false);
        if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            if (!this.m_9236_().f_46443_) {
                BlockState state = this.m_9236_().m_8055_(blockHitResult.m_82425_());
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(blockHitResult.m_82425_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 4, 0.1, 0.1, 0.1, 0.05);
            }
            Vec3i normal = blockHitResult.m_82434_().m_122436_();
            Vec3 motion = this.m_20184_();
            double dotProduct = motion.f_82479_ * (double)normal.m_123341_() + motion.f_82480_ * (double)normal.m_123342_() + motion.f_82481_ * (double)normal.m_123343_();
            Vec3 reflection = new Vec3(motion.f_82479_ - 2.0 * dotProduct * (double)normal.m_123341_(), motion.f_82480_ - 2.0 * dotProduct * (double)normal.m_123342_(), motion.f_82481_ - 2.0 * dotProduct * (double)normal.m_123343_());
            if (!((Boolean)this.f_19804_.m_135370_(ID_IMPACTED)).booleanValue()) {
                this.m_20256_(reflection.m_82541_().m_82490_(0.2));
                this.f_19804_.m_135381_(ID_IMPACTED, (Object)true);
            }
        }
    }

    public void m_8119_() {
        ServerLevel serverWorld;
        Level level;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            serverWorld = (ServerLevel)level;
            this.syncPersistentDataToEntityData();
        }
        if (this.f_36703_) {
            this.f_19804_.m_135381_(ID_SPIN_TICKS, (Object)0);
            this.ticksInAir = 0;
        } else {
            this.f_19804_.m_135381_(ID_SPIN_TICKS, (Object)((Integer)this.f_19804_.m_135370_(ID_SPIN_TICKS) + 1));
            ++this.ticksInAir;
        }
        if (!this.m_9236_().f_46443_) {
            serverWorld = (ServerLevel)this.m_9236_();
            boolean isInWater = this.m_5842_();
            this.handleProjectileCollisions(serverWorld, isInWater);
            this.handleGroundBehavior(serverWorld, isInWater);
            this.handleLavaInteraction(serverWorld);
            this.handleMobPickup(serverWorld);
        } else {
            this.handleParticleTrail();
        }
        this.bubbleTime = this.m_20069_() ? ++this.bubbleTime : 0;
    }

    protected boolean m_142470_(Player player) {
        switch (this.f_36705_) {
            case ALLOWED: {
                ItemStack slotStack;
                int i;
                Entity owner = this.m_19749_();
                if (owner != null) {
                    if (owner instanceof Player) {
                        if (!owner.m_20148_().equals(player.m_20148_())) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                if (player.m_150110_().f_35937_) {
                    return false;
                }
                ItemStack pickupItemStack = this.m_7941_().m_41777_();
                pickupItemStack.m_41764_(1);
                Inventory inventory = player.m_150109_();
                for (i = 0; i < inventory.m_6643_(); ++i) {
                    ItemStack slotStack2 = inventory.m_8020_(i);
                    if (!slotStack2.m_150930_(pickupItemStack.m_41720_()) || !ItemStack.m_150942_((ItemStack)slotStack2, (ItemStack)pickupItemStack) || slotStack2.m_41613_() >= slotStack2.m_41741_()) continue;
                    slotStack2.m_41769_(1);
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                    return true;
                }
                if (this.originalSlotIndex >= 0 && (this.originalSlotIndex <= 8 || this.originalSlotIndex == 40) && (slotStack = inventory.m_8020_(this.originalSlotIndex)).m_41619_()) {
                    inventory.m_6836_(this.originalSlotIndex, pickupItemStack);
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                    return true;
                }
                for (i = 0; i <= 8; ++i) {
                    ItemStack hotbarStack;
                    if (i == this.originalSlotIndex || !(hotbarStack = inventory.m_8020_(i)).m_41619_()) continue;
                    inventory.m_6836_(i, pickupItemStack);
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                    return true;
                }
                boolean result = inventory.m_36054_(pickupItemStack);
                if (result) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                } else if (!this.m_9236_().f_46443_) {
                    this.dropAsItem();
                }
                return result;
            }
            case CREATIVE_ONLY: {
                return player.m_150110_().f_35937_;
            }
        }
        return false;
    }

    protected ItemStack m_7941_() {
        ItemStack itemStack = this.dynamiteItem.m_41777_();
        itemStack.m_41764_(1);
        return itemStack;
    }

    protected float m_6882_() {
        return 0.59f;
    }

    public int m_6078_() {
        return 72000;
    }

    public ItemStack getDefaultDynamiteItem() {
        return new ItemStack((ItemLike)JaamsWeaponryModItems.DYNAMITE.get());
    }

    public void initializeDynamiteItem(ItemStack dynamiteItem) {
        this.dynamiteItem = dynamiteItem != null && !dynamiteItem.m_41619_() ? dynamiteItem.m_41777_() : this.getDefaultDynamiteItem();
        this.f_19804_.m_135381_(ID_DYNAMITE_ITEM, (Object)this.dynamiteItem);
        this.getPersistentData().m_128365_("DynamiteItem", (Tag)this.dynamiteItem.m_41739_(new CompoundTag()));
        this.updateFoilData();
    }

    private void handleProjectileCollisions(ServerLevel serverWorld, boolean isInWater) {
        List collidingProjectiles = this.m_9236_().m_45976_(Entity.class, this.m_20191_()).stream().filter(entity -> entity instanceof Projectile && entity != this && !(entity instanceof DynamiteProjectileEntity) && !(entity instanceof BroomProjectileEntity)).collect(Collectors.toList());
        Iterator iterator = collidingProjectiles.iterator();
        if (iterator.hasNext()) {
            Entity projectile = (Entity)iterator.next();
            this.spawnItemParticles(serverWorld, 5, 0.1, 0.05);
            if (isInWater) {
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 8, 0.1, 0.1, 0.1, 0.05);
                this.spawnItemEntity();
                this.m_146870_();
            } else {
                this.m_20256_(this.m_20184_().m_82542_(-0.02, -0.2, -0.02));
                this.explode();
            }
            return;
        }
    }

    private void handleGroundBehavior(ServerLevel serverWorld, boolean isInWater) {
        if (!((Boolean)this.f_19804_.m_135370_(ID_IMPACTED)).booleanValue()) {
            return;
        }
        int ticksOnGround = (Integer)this.f_19804_.m_135370_(ID_TICKS_ON_GROUND) + 1;
        this.f_19804_.m_135381_(ID_TICKS_ON_GROUND, (Object)ticksOnGround);
        double dynamiteTicks = (Double)JaamsWeaponryCommonConfiguration.DYNAMITETICKS.get();
        float dynamiteSize = ((Double)JaamsWeaponryClientConfiguration.DYNAMITESIZE.get()).floatValue();
        if (isInWater) {
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20186_() + 0.6, this.m_20189_(), 4, 0.05, 0.05, 0.05, 0.0);
            if ((double)ticksOnGround >= dynamiteTicks) {
                this.spawnItemEntity();
                this.m_146870_();
            }
            return;
        }
        if (ticksOnGround >= 0 && (double)ticksOnGround <= dynamiteTicks - 15.0 && (double)dynamiteSize <= 4.0) {
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.6, this.m_20189_(), 1, 0.05, 0.05, 0.05, 0.0);
        }
        if ((double)ticksOnGround == dynamiteTicks / 5.0 && IGNITING_SOUND != null) {
            serverWorld.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), IGNITING_SOUND, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if ((double)ticksOnGround == dynamiteTicks - 15.0 && (double)dynamiteSize <= 1.5) {
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 0.6, this.m_20189_(), 1, 0.05, 0.05, 0.05, 0.0);
        }
        if ((double)ticksOnGround == dynamiteTicks - 10.0) {
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20185_(), this.m_20186_() + 0.4, this.m_20189_(), 1, 0.05, 0.05, 0.05, 0.0);
        }
        if ((double)ticksOnGround >= dynamiteTicks) {
            this.spawnItemParticles(serverWorld, 5, 0.1, 0.05);
            this.explode();
        }
    }

    private void handleLavaInteraction(ServerLevel serverWorld) {
        if (this.m_20077_()) {
            this.explode();
        }
    }

    public void dropAsItem() {
        if (!this.m_9236_().f_46443_) {
            ItemStack itemToSpawn = this.dynamiteItem.m_41777_();
            itemToSpawn.m_41764_(1);
            ItemEntity entityToSpawn = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), itemToSpawn);
            entityToSpawn.m_32010_(10);
            this.m_9236_().m_7967_((Entity)entityToSpawn);
        }
    }

    private void handleMobPickup(ServerLevel serverWorld) {
        Entity entity;
        if (this.f_36703_ && (entity = this.m_19749_()) instanceof Mob) {
            Mob mobOwner = (Mob)entity;
            double pickupRange = 1.5;
            if (this.m_20182_().m_82554_(mobOwner.m_20182_()) <= pickupRange && this.tryPickup(mobOwner)) {
                serverWorld.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 0.2f, 1.0f);
                this.m_146870_();
            }
        }
    }

    private boolean tryPickup(Mob mob) {
        ItemStack pickupItemStack = this.dynamiteItem.m_41777_();
        pickupItemStack.m_41764_(1);
        ItemStack mainHandStack = mob.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHandStack = mob.m_21120_(InteractionHand.OFF_HAND);
        if (!mainHandStack.m_41619_() && mainHandStack.m_150930_(pickupItemStack.m_41720_()) && mainHandStack.m_41613_() < mainHandStack.m_41741_()) {
            mainHandStack.m_41769_(1);
            return true;
        }
        if (!offHandStack.m_41619_() && offHandStack.m_150930_(pickupItemStack.m_41720_()) && offHandStack.m_41613_() < offHandStack.m_41741_()) {
            offHandStack.m_41769_(1);
            return true;
        }
        if (mainHandStack.m_41619_()) {
            mob.m_21008_(InteractionHand.MAIN_HAND, pickupItemStack);
            return true;
        }
        if (offHandStack.m_41619_()) {
            mob.m_21008_(InteractionHand.OFF_HAND, pickupItemStack);
            return true;
        }
        return false;
    }

    private void spawnItemParticles(ServerLevel serverWorld, int count, double delta, double speed) {
        if (!this.dynamiteItem.m_41619_()) {
            serverWorld.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.dynamiteItem), this.m_20185_(), this.m_20186_(), this.m_20189_(), count, delta, delta, delta, speed);
        }
    }

    private void spawnItemEntity() {
        if (!this.m_9236_().f_46443_) {
            ItemStack itemToSpawn = this.dynamiteItem.m_41777_();
            itemToSpawn.m_41764_(1);
            ItemEntity entityToSpawn = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), itemToSpawn);
            entityToSpawn.m_32010_(10);
            this.m_9236_().m_7967_((Entity)entityToSpawn);
        }
    }

    public void explode() {
        Level world = this.m_9236_();
        BlockPos blockPos = this.m_20183_();
        BlockPos.m_121990_((BlockPos)blockPos.m_7918_(-3, -3, -3), (BlockPos)blockPos.m_7918_(3, 3, 3)).filter(pos -> world.m_8055_(pos).m_60713_(Blocks.f_50077_)).forEach(pos -> world.m_255391_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ((Double)JaamsWeaponryCommonConfiguration.DYNAMITEPOWER.get()).floatValue(), false, (Boolean)JaamsWeaponryCommonConfiguration.DYNAMITEBREAKBLOCKS.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE));
        world.m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), ((Double)JaamsWeaponryCommonConfiguration.DYNAMITEPOWER.get()).floatValue(), false, (Boolean)JaamsWeaponryCommonConfiguration.DYNAMITEBREAKBLOCKS.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
        this.m_146870_();
    }

    protected void handleParticleTrail() {
        if (this.m_9236_().f_46443_ && !this.f_36703_ && !this.m_20077_()) {
            if (this.m_20069_()) {
                if (this.bubbleTime <= 200 && this.bubbleTime % 5 == 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 0.0, 0.0, 0.0);
                }
            } else if (this.ticksInAir <= 200) {
                Vec3 motion = this.m_20184_().m_82541_();
                double offset = 0.5;
                double smokeX = this.m_20185_() - motion.f_82479_ * offset;
                double smokeY = this.m_20186_() + 0.17 - motion.f_82480_ * offset;
                double smokeZ = this.m_20189_() - motion.f_82481_ * offset;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, smokeX, smokeY, smokeZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public void updateFoilData() {
        this.f_19804_.m_135381_(ID_FOIL, (Object)this.dynamiteItem.m_41790_());
    }

    public void setDynamiteItem(ItemStack newDynamiteItem) {
        ItemStack itemStack = this.dynamiteItem = newDynamiteItem != null && !newDynamiteItem.m_41619_() ? newDynamiteItem.m_41777_() : this.getDefaultDynamiteItem();
        if (!ItemStack.m_41728_((ItemStack)((ItemStack)this.f_19804_.m_135370_(ID_DYNAMITE_ITEM)), (ItemStack)this.dynamiteItem)) {
            this.f_19804_.m_135381_(ID_DYNAMITE_ITEM, (Object)this.dynamiteItem);
            this.getPersistentData().m_128365_("DynamiteItem", (Tag)this.dynamiteItem.m_41739_(new CompoundTag()));
            this.updateFoilData();
        }
    }

    public ItemStack getDynamiteItem() {
        return this.dynamiteItem.m_41777_();
    }

    public void syncPersistentDataToEntityData() {
        ItemStack persistentItem;
        CompoundTag persistentData = this.getPersistentData();
        if (persistentData.m_128425_("DynamiteItem", 10) && !ItemStack.m_41728_((ItemStack)(persistentItem = ItemStack.m_41712_((CompoundTag)persistentData.m_128469_("DynamiteItem"))), (ItemStack)this.dynamiteItem) && !persistentItem.m_41619_()) {
            this.dynamiteItem = persistentItem.m_41777_();
            this.f_19804_.m_135381_(ID_DYNAMITE_ITEM, (Object)this.dynamiteItem);
            this.updateFoilData();
        }
        if (persistentData.m_128441_("OriginalSlotIndex")) {
            this.originalSlotIndex = persistentData.m_128451_("OriginalSlotIndex");
            this.f_19804_.m_135381_(ID_ORIGINAL_SLOT, (Object)this.originalSlotIndex);
        }
    }

    public boolean hasImpacted() {
        return (Boolean)this.f_19804_.m_135370_(ID_IMPACTED);
    }

    public int getTicksOnGround() {
        return (Integer)this.f_19804_.m_135370_(ID_TICKS_ON_GROUND);
    }

    public int getBounceCount() {
        return this.bounceCount;
    }

    public int getSpinTicks() {
        return (Integer)this.f_19804_.m_135370_(ID_SPIN_TICKS);
    }

    public int getOriginalSlot() {
        return this.originalSlotIndex;
    }

    public boolean hasFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    public void setOriginalSlotIndex(int slotIndex) {
        this.originalSlotIndex = slotIndex >= 0 ? slotIndex : -1;
        this.f_19804_.m_135381_(ID_ORIGINAL_SLOT, (Object)this.originalSlotIndex);
        this.getPersistentData().m_128405_("OriginalSlotIndex", this.originalSlotIndex);
    }
}

