/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.entity;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.jaams.jaams_weaponry.components.BaseBulletProjectileEntity;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class EchoBulletProjectileEntity
extends BaseBulletProjectileEntity {
    private static final EntityDataAccessor<Boolean> ID_HAS_IMPACTED = SynchedEntityData.m_135353_(EchoBulletProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ID_HAS_PLAYED_SCULK_SOUND = SynchedEntityData.m_135353_(EchoBulletProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> ID_TARGET_UUID = SynchedEntityData.m_135353_(EchoBulletProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public EchoBulletProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends BaseBulletProjectileEntity>)((EntityType)JaamsWeaponryModEntities.ECHO_BULLET_PROJECTILE.get()), world);
        this.initializeProperties();
    }

    public EchoBulletProjectileEntity(EntityType<? extends EchoBulletProjectileEntity> type, Level world) {
        super(type, world);
        this.initializeProperties();
    }

    public EchoBulletProjectileEntity(EntityType<? extends EchoBulletProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.initializeProperties();
    }

    public EchoBulletProjectileEntity(EntityType<? extends EchoBulletProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.initializeProperties();
    }

    private void initializeProperties() {
        this.setBulletDamage(5.0f);
        this.setBulletKnockback(0.7f);
        this.setHasGravity(false);
        this.setColor(-16741493);
    }

    @Override
    public void setBulletDamage(float damage) {
        this.getPersistentData().m_128350_("BaseBulletDamage", Math.max(0.0f, damage));
    }

    @Override
    public void setBulletKnockback(float strength) {
        this.getPersistentData().m_128350_("KnockbackStrength", Math.max(0.0f, strength));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_HAS_IMPACTED, (Object)false);
        this.f_19804_.m_135372_(ID_HAS_PLAYED_SCULK_SOUND, (Object)false);
        this.f_19804_.m_135372_(ID_TARGET_UUID, Optional.empty());
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasImpacted", ((Boolean)this.f_19804_.m_135370_(ID_HAS_IMPACTED)).booleanValue());
        compound.m_128379_("hasPlayedSculkSound", ((Boolean)this.f_19804_.m_135370_(ID_HAS_PLAYED_SCULK_SOUND)).booleanValue());
        Optional targetUUID = (Optional)this.f_19804_.m_135370_(ID_TARGET_UUID);
        targetUUID.ifPresent(uuid -> compound.m_128362_("targetUUID", uuid));
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(ID_HAS_IMPACTED, (Object)compound.m_128471_("hasImpacted"));
        this.f_19804_.m_135381_(ID_HAS_PLAYED_SCULK_SOUND, (Object)compound.m_128471_("hasPlayedSculkSound"));
        if (compound.m_128403_("targetUUID")) {
            this.f_19804_.m_135381_(ID_TARGET_UUID, Optional.of(compound.m_128342_("targetUUID")));
        } else {
            this.f_19804_.m_135381_(ID_TARGET_UUID, Optional.empty());
        }
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(((Boolean)this.f_19804_.m_135370_(ID_HAS_IMPACTED)).booleanValue());
        buffer.writeBoolean(((Boolean)this.f_19804_.m_135370_(ID_HAS_PLAYED_SCULK_SOUND)).booleanValue());
        Optional targetUUID = (Optional)this.f_19804_.m_135370_(ID_TARGET_UUID);
        buffer.writeBoolean(targetUUID.isPresent());
        targetUUID.ifPresent(arg_0 -> ((FriendlyByteBuf)buffer).m_130077_(arg_0));
    }

    @Override
    public void readSpawnData(FriendlyByteBuf additionalData) {
        super.readSpawnData(additionalData);
        if (additionalData.isReadable()) {
            this.f_19804_.m_135381_(ID_HAS_IMPACTED, (Object)additionalData.readBoolean());
        }
        if (additionalData.isReadable()) {
            this.f_19804_.m_135381_(ID_HAS_PLAYED_SCULK_SOUND, (Object)additionalData.readBoolean());
        }
        if (additionalData.isReadable() && additionalData.readBoolean()) {
            this.f_19804_.m_135381_(ID_TARGET_UUID, Optional.of(additionalData.m_130259_()));
        } else {
            this.f_19804_.m_135381_(ID_TARGET_UUID, Optional.empty());
        }
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42587_);
    }

    @Override
    protected SoundEvent getHitSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:bullet_hit"));
        return sound != null ? sound : SoundEvents.f_12514_;
    }

    @Override
    protected SoundEvent getGroundSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:bullet_ground"));
        return sound != null ? sound : SoundEvents.f_12515_;
    }

    @Override
    protected void applyHitEffects(LivingEntity entity, EntityHitResult hitResult) {
        this.f_19804_.m_135381_(ID_HAS_IMPACTED, (Object)true);
    }

    @Override
    protected void applyBlockHitEffects(BlockPos pos, BlockState state, BlockHitResult hitResult) {
        this.f_19804_.m_135381_(ID_HAS_IMPACTED, (Object)true);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction face = hitResult.m_82434_();
            double offset = 0.01;
            double x = (double)pos.m_123341_() + 0.5 + (double)face.m_122429_() * (0.5 + offset);
            double y = (double)pos.m_123342_() + 0.5 + (double)face.m_122430_() * (0.5 + offset);
            double z = (double)pos.m_123343_() + 0.5 + (double)face.m_122431_() * (0.5 + offset);
            ItemStack itemStack = new ItemStack((ItemLike)JaamsWeaponryModItems.ECHO_BULLET.get());
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(pos), x, y, z, 10, 0.1, 0.1, 0.1, 0.05);
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), x, y, z, 4, 0.1, 0.1, 0.1, 0.05);
        }
    }

    @Override
    public int getMaxBreaks() {
        return 2;
    }

    @Override
    public int getMaxHits() {
        return 1;
    }

    @Override
    public int getMaxTicksInAir() {
        return 15;
    }

    @Override
    public int getMaxTicksInGround() {
        return 3;
    }

    @Override
    public boolean canDisableShield(ItemStack shield, LivingEntity shieldHolder, Entity owner) {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !((Boolean)this.f_19804_.m_135370_(ID_HAS_IMPACTED)).booleanValue()) {
            LivingEntity target = this.getStoredTarget();
            if (target == null && (target = this.findNearestTarget()) != null) {
                this.f_19804_.m_135381_(ID_TARGET_UUID, Optional.of(target.m_20148_()));
            }
            if (target != null && target.m_6084_()) {
                if (!((Boolean)this.f_19804_.m_135370_(ID_HAS_PLAYED_SCULK_SOUND)).booleanValue()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144212_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    this.f_19804_.m_135381_(ID_HAS_PLAYED_SCULK_SOUND, (Object)true);
                }
                Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20186_() + (double)target.m_20192_(), target.m_20189_());
                Vec3 direction = targetPos.m_82546_(this.m_20182_()).m_82541_();
                double speed = 1.6;
                if (this.hasClearLineOfSight(target)) {
                    this.m_20256_(direction.m_82490_(speed));
                    this.setHasGravity(false);
                }
            } else {
                this.f_19804_.m_135381_(ID_HAS_PLAYED_SCULK_SOUND, (Object)false);
                this.setHasGravity(true);
            }
            if (this.m_20184_().m_82556_() == 0.0) {
                this.m_146870_();
            }
        }
    }

    private boolean hasClearLineOfSight(LivingEntity target) {
        Vec3 targetEyePos = new Vec3(target.m_20185_(), target.m_20186_() + (double)target.m_20192_(), target.m_20189_());
        Vec3 directionToTarget = targetEyePos.m_82546_(this.m_20182_()).m_82541_();
        BlockHitResult blockHitResult = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), targetEyePos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return blockHitResult.m_6662_() != HitResult.Type.BLOCK || blockHitResult.m_82425_().equals((Object)target.m_20183_());
    }

    private LivingEntity findNearestTarget() {
        List entities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(16.0), entity -> entity != this.m_19749_() && entity.m_6084_() && !this.isTamedByOwner((LivingEntity)entity));
        if (entities.isEmpty()) {
            return null;
        }
        LivingEntity bestTarget = null;
        double bestScore = Double.MAX_VALUE;
        for (LivingEntity entity2 : entities) {
            double heightDiff;
            double distance = this.m_20280_((Entity)entity2);
            boolean hasGlowing = entity2.m_21023_(MobEffects.f_19619_);
            boolean hasLineOfSight = this.hasClearLineOfSight(entity2);
            double score = distance;
            if (hasGlowing) {
                score *= 0.1;
            }
            if (hasLineOfSight) {
                score *= 0.5;
            }
            if (!((score += (heightDiff = Math.abs(this.m_20186_() - (entity2.m_20186_() + (double)entity2.m_20192_()))) * 10.0) < bestScore)) continue;
            bestScore = score;
            bestTarget = entity2;
        }
        return bestTarget;
    }

    private boolean isTamedByOwner(LivingEntity entity) {
        if (this.m_19749_() instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)this.m_19749_();
            if (entity.m_7307_((Entity)owner)) {
                return true;
            }
            if (entity instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)entity;
                UUID ownerUUID = owner.m_20148_();
                UUID horseOwnerUUID = horse.m_21805_();
                return ownerUUID.equals(horseOwnerUUID);
            }
        }
        return false;
    }

    private LivingEntity getStoredTarget() {
        LivingEntity livingEntity;
        ServerLevel serverLevel;
        Entity entity;
        Level level;
        Optional targetUUID = (Optional)this.f_19804_.m_135370_(ID_TARGET_UUID);
        if (targetUUID.isPresent() && (level = this.m_9236_()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_((UUID)targetUUID.get())) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6084_()) {
            return livingEntity;
        }
        return null;
    }
}

