/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.entity;

import net.jaams.jaams_weaponry.components.BaseReturningProjectileEntity;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class HuntersBoomerangProjectileEntity
extends BaseReturningProjectileEntity {
    public HuntersBoomerangProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends BaseReturningProjectileEntity>)((EntityType)JaamsWeaponryModEntities.HUNTERS_BOOMERANG_PROJECTILE.get()), world);
        this.configureProjectileProperties();
    }

    public HuntersBoomerangProjectileEntity(EntityType<? extends HuntersBoomerangProjectileEntity> type, Level world) {
        super(type, world);
        this.configureProjectileProperties();
    }

    public HuntersBoomerangProjectileEntity(EntityType<? extends HuntersBoomerangProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.configureProjectileProperties();
    }

    public HuntersBoomerangProjectileEntity(EntityType<? extends HuntersBoomerangProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.configureProjectileProperties();
    }

    public HuntersBoomerangProjectileEntity(Level world, LivingEntity entity, ItemStack weaponItem) {
        super((EntityType<? extends BaseReturningProjectileEntity>)((EntityType)JaamsWeaponryModEntities.HUNTERS_BOOMERANG_PROJECTILE.get()), entity, world, weaponItem);
        this.configureProjectileProperties();
    }

    protected void configureProjectileProperties() {
        this.setPiercingLevel(0);
        this.setAreaDamage(false, 0.0f, 0.0f);
    }

    @Override
    public ItemStack getDefaultWeaponItem() {
        return new ItemStack((ItemLike)JaamsWeaponryModItems.HUNTERS_BOOMERANG.get());
    }

    @Override
    protected SoundEvent getHitSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:hunters_boomerang_hit"));
        return sound != null ? sound : SoundEvents.f_12514_;
    }

    @Override
    protected SoundEvent getGroundSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:hunters_boomerang_ground"));
        return sound != null ? sound : SoundEvents.f_12515_;
    }

    @Override
    protected SoundEvent getLoyaltySound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:hunters_boomerang_return"));
        return sound != null ? sound : SoundEvents.f_12516_;
    }

    @Override
    public float getWeaponBaseDamage() {
        return 2.0f;
    }

    @Override
    public float getDisarmChance() {
        if (this.isCritical()) {
            return 0.3f;
        }
        return 0.15f;
    }

    @Override
    public int getMaxBreaks() {
        return 1;
    }

    @Override
    public int getMaxHits() {
        return 1;
    }

    @Override
    public int getMaxMountedEntities() {
        return 3;
    }

    @Override
    protected boolean returnOnBlockHit(BlockHitResult blockHitResult) {
        return true;
    }

    @Override
    protected boolean returnOnEntityHit(EntityHitResult entityHitResult) {
        return true;
    }

    @Override
    protected void applyHitEffects(LivingEntity entity, EntityHitResult hitResult) {
    }

    @Override
    protected void applyBlockHitEffects(BlockPos pos, BlockState state, BlockHitResult hitResult) {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && !this.m_20069_() && this.f_19796_.m_188503_(5) == 0 && !this.f_36703_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (!(this.m_9236_().f_46443_ || this.f_36703_ || this.m_36797_() || this.f_19797_ % 6 != 0)) {
            ModUtils.playSound((Entity)this, "jaams_weaponry:thin_swoosh_air", SoundSource.AMBIENT, 0.3f, 1.0f);
        }
    }

    protected void m_6901_() {
        ++this.life;
        if ((double)this.life >= (Double)JaamsWeaponryCommonConfiguration.HUNTERSBOOMERANGDESPAWN.get()) {
            ItemStack itemStack;
            if (((Boolean)JaamsWeaponryCommonConfiguration.DROPASITEM.get()).booleanValue() && this.f_36705_ != AbstractArrow.Pickup.CREATIVE_ONLY) {
                this.dropAsItem();
            } else if (!this.m_9236_().m_5776_() && !(itemStack = this.getWeaponItem().m_41777_()).m_41619_()) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), this.m_20185_(), this.m_20186_() + 0.3, this.m_20189_(), 5, 0.1, 0.1, 0.1, 0.05);
            }
            this.m_146870_();
        }
    }
}

