/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.entity;

import net.jaams.jaams_weaponry.components.BaseWeaponProjectileEntity;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class RoyalAxeProjectileEntity
extends BaseWeaponProjectileEntity {
    public RoyalAxeProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends BaseWeaponProjectileEntity>)((EntityType)JaamsWeaponryModEntities.ROYAL_AXE_PROJECTILE.get()), world);
        this.configureProjectileProperties();
    }

    public RoyalAxeProjectileEntity(EntityType<? extends RoyalAxeProjectileEntity> type, Level world) {
        super(type, world);
        this.configureProjectileProperties();
    }

    public RoyalAxeProjectileEntity(EntityType<? extends RoyalAxeProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.configureProjectileProperties();
    }

    public RoyalAxeProjectileEntity(EntityType<? extends RoyalAxeProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.configureProjectileProperties();
    }

    public RoyalAxeProjectileEntity(Level world, LivingEntity entity, ItemStack weaponItem) {
        super((EntityType<? extends BaseWeaponProjectileEntity>)((EntityType)JaamsWeaponryModEntities.ROYAL_AXE_PROJECTILE.get()), entity, world, weaponItem);
        this.configureProjectileProperties();
    }

    protected void configureProjectileProperties() {
        this.setPiercingLevel(0);
        this.setAreaDamage(true, 1.5f, 2.0f);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)0.7f, (float)0.7f);
    }

    @Override
    public ItemStack getDefaultWeaponItem() {
        return new ItemStack((ItemLike)JaamsWeaponryModItems.ROYAL_AXE.get());
    }

    @Override
    protected SoundEvent getHitSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:royal_axe_hit"));
        return sound != null ? sound : SoundEvents.f_12514_;
    }

    @Override
    protected SoundEvent getGroundSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:royal_axe_ground"));
        return sound != null ? sound : SoundEvents.f_12515_;
    }

    @Override
    protected SoundEvent getLoyaltySound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:royal_axe_return"));
        return sound != null ? sound : SoundEvents.f_12516_;
    }

    @Override
    public float getWeaponBaseDamage() {
        return 3.0f;
    }

    @Override
    public int getMaxBreaks() {
        return 3;
    }

    @Override
    public int getMaxHits() {
        return 1;
    }

    @Override
    protected void applyHitEffects(LivingEntity entity, EntityHitResult hitResult) {
        LightningBolt lightning;
        ItemStack weaponItem;
        if (!this.m_9236_().f_46443_ && (weaponItem = this.getWeaponItem()) != null && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44958_, (ItemStack)weaponItem) > 0 && (this.m_9236_().m_46470_() || this.m_9236_().m_46471_()) && (lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_())) != null) {
            lightning.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            this.m_9236_().m_7967_((Entity)lightning);
            this.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)JaamsWeaponryModSounds.ROYAL_AXE_THUNDER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    protected void applyBlockHitEffects(BlockPos pos, BlockState state, BlockHitResult hitResult) {
    }

    protected void m_6901_() {
        ++this.life;
        int despawnTime = Math.max(1, (int)((Double)JaamsWeaponryCommonConfiguration.ROYALAXEDESPAWN.get()).doubleValue());
        if (this.life >= despawnTime) {
            ItemStack itemStack;
            if (((Boolean)JaamsWeaponryCommonConfiguration.DROPASITEM.get()).booleanValue() && this.f_36705_ != AbstractArrow.Pickup.CREATIVE_ONLY) {
                this.dropAsItem();
            } else if (!this.m_9236_().f_46443_ && !(itemStack = this.weaponItem.m_41777_()).m_41619_()) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 5, 0.1, 0.1, 0.1, 0.05);
            }
            this.m_146870_();
        }
    }
}

