/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.entity;

import net.jaams.jaams_weaponry.components.BaseStackableProjectileEntity;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class ShurikenProjectileEntity
extends BaseStackableProjectileEntity {
    public static final float DISABLE_CHANCE = 0.5f;

    public ShurikenProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends BaseStackableProjectileEntity>)((EntityType)JaamsWeaponryModEntities.SHURIKEN_PROJECTILE.get()), world);
        this.initializeProperties();
    }

    public ShurikenProjectileEntity(EntityType<? extends ShurikenProjectileEntity> type, Level world) {
        super(type, world);
        this.initializeProperties();
    }

    public ShurikenProjectileEntity(EntityType<? extends ShurikenProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.initializeProperties();
    }

    public ShurikenProjectileEntity(EntityType<? extends ShurikenProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.initializeProperties();
    }

    public ShurikenProjectileEntity(EntityType<? extends ShurikenProjectileEntity> type, LivingEntity entity, Level world, ItemStack weaponItem) {
        super(type, entity, world, weaponItem);
        this.initializeProperties();
    }

    private void initializeProperties() {
        this.setWeaponDamage(5.0f);
        this.setWeaponKnockback(0.4f);
        this.setHasGravity(true);
        this.setPiercingLevel(0);
    }

    @Override
    public ItemStack getDefaultWeaponItem() {
        return new ItemStack((ItemLike)JaamsWeaponryModItems.SHURIKEN.get());
    }

    @Override
    protected SoundEvent getHitSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:shuriken_hit"));
        return sound != null ? sound : SoundEvents.f_12514_;
    }

    @Override
    protected SoundEvent getGroundSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:shuriken_ground"));
        return sound != null ? sound : SoundEvents.f_12515_;
    }

    @Override
    public int getMaxBreaks() {
        return 1;
    }

    @Override
    public int getMaxHits() {
        return 1;
    }

    @Override
    protected void applyHitEffects(LivingEntity entity, EntityHitResult hitResult) {
        if (!this.m_9236_().f_46443_ && this.m_9236_().f_46441_.m_188501_() < 0.5f) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_6117_()) {
                    ItemStack activeItem = player.m_21211_();
                    if (!activeItem.m_41619_() && !player.m_36335_().m_41519_(activeItem.m_41720_())) {
                        player.m_36335_().m_41524_(activeItem.m_41720_(), 60);
                    }
                    player.m_5810_();
                }
            } else {
                entity.m_5810_();
            }
        }
    }

    @Override
    protected void applyBlockHitEffects(BlockPos pos, BlockState state, BlockHitResult hitResult) {
    }

    @Override
    public void setWeaponDamage(float damage) {
        this.getPersistentData().m_128350_("BaseWeaponDamage", Math.max(0.0f, damage));
    }

    @Override
    public void setWeaponKnockback(float strength) {
        this.getPersistentData().m_128350_("WeaponKnockbackStrength", Math.max(0.0f, strength));
    }

    @Override
    public boolean canDisableShield(ItemStack shield, LivingEntity shieldHolder, Entity owner) {
        return false;
    }

    @Override
    protected boolean shouldBreakOnEntityHit() {
        return true;
    }

    @Override
    protected boolean shouldBreakOnPiercingExhausted() {
        return false;
    }

    @Override
    protected boolean shouldBreakOnBlockHit() {
        return false;
    }

    protected void m_6901_() {
        ++this.life;
        int despawnTime = Math.max(1, (int)((Double)JaamsWeaponryCommonConfiguration.SHURIKENDESPAWN.get()).doubleValue());
        if (this.life >= despawnTime) {
            ItemStack itemStack;
            if (((Boolean)JaamsWeaponryCommonConfiguration.DROPASITEM.get()).booleanValue() && this.f_36705_ != AbstractArrow.Pickup.CREATIVE_ONLY) {
                this.dropAsItem();
            } else if (!this.m_9236_().f_46443_ && !(itemStack = this.weaponItem.m_41777_()).m_41619_()) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 5, 0.1, 0.1, 0.1, 0.05);
            }
            this.m_146870_();
        }
    }
}

