/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.entity;

import java.util.Collection;
import java.util.HashSet;
import net.jaams.jaams_weaponry.components.BaseBlockProjectileEntity;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class SlingshotProjectileEntity
extends BaseBlockProjectileEntity {
    private static final int TNT_FUSE_TICKS = 40;
    private static final int MAX_SLIME_BOUNCES = 2;
    private static final EntityDataAccessor<Boolean> IS_CHARGED_FOR_CRIT = SynchedEntityData.m_135353_(SlingshotProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int tntFuse = -1;
    private int slimeBounceCount = 0;

    public SlingshotProjectileEntity(EntityType<? extends SlingshotProjectileEntity> type, Level world) {
        super(type, world);
        this.initializeProperties();
    }

    public SlingshotProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends BaseBlockProjectileEntity>)((EntityType)JaamsWeaponryModEntities.SLINGSHOT_PROJECTILE.get()), world);
        this.initializeProperties();
    }

    public SlingshotProjectileEntity(EntityType<? extends SlingshotProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.initializeProperties();
    }

    public SlingshotProjectileEntity(EntityType<? extends SlingshotProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.initializeProperties();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CHARGED_FOR_CRIT, (Object)false);
    }

    public void setChargedForCrit(boolean charged) {
        this.f_19804_.m_135381_(IS_CHARGED_FOR_CRIT, (Object)charged);
    }

    public boolean isChargedForCrit() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGED_FOR_CRIT);
    }

    private void initializeProperties() {
        this.setBlockDamage(3.0f);
        this.setBlockKnockback(0.5f);
        this.setHasGravity(true);
        this.setColor(-1);
    }

    @Override
    protected void handleParticleTrail() {
        if (this.m_9236_().f_46443_ && !this.f_36703_ && !this.m_20077_()) {
            if (this.m_20069_()) {
                if (this.bubbleTime <= 200 && this.bubbleTime % 5 == 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 0.0, 0.0, 0.0);
                }
            } else if (this.isChargedForCrit()) {
                Vec3 motion = this.m_20184_().m_82541_();
                double offset = 0.5;
                double smokeX = this.m_20185_() - motion.f_82479_ * offset;
                double smokeY = this.m_20186_() + 0.17 - motion.f_82480_ * offset;
                double smokeZ = this.m_20189_() - motion.f_82481_ * offset;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, smokeX, smokeY, smokeZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void setBlockDamage(float damage) {
        this.getPersistentData().m_128350_("BaseBlockDamage", Math.max(0.0f, damage));
    }

    @Override
    public void setBlockKnockback(float strength) {
        this.getPersistentData().m_128350_("KnockbackStrength", Math.max(0.0f, strength));
    }

    @Override
    public ItemStack getDefaultBlockItem() {
        return new ItemStack((ItemLike)Items.f_41905_);
    }

    @Override
    protected SoundEvent getHitSound() {
        return this.getBlockSoundType().m_56775_();
    }

    @Override
    protected SoundEvent getGroundSound() {
        return this.getBlockSoundType().m_56777_();
    }

    @Override
    protected void applyHitEffects(LivingEntity entity, EntityHitResult hitResult) {
        Level level;
        if (this.isTNTBlock() && this.m_6060_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerExplosion(serverLevel);
            this.m_146870_();
        }
        if (this.isMagmaBlock() && this.m_9236_() instanceof ServerLevel) {
            entity.m_20254_(5);
        }
    }

    @Override
    protected void applyBlockHitEffects(BlockPos pos, BlockState state, BlockHitResult hitResult) {
        ServerLevel serverLevel;
        Level level;
        if ((this.m_6060_() || this.isMagmaBlock()) && (level = this.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            Direction face = hitResult.m_82434_();
            double offset = 0.01;
            double x = (double)pos.m_123341_() + 0.5 + (double)face.m_122429_() * (0.5 + offset);
            double y = (double)pos.m_123342_() + 0.5 + (double)face.m_122430_() * (0.5 + offset);
            double z = (double)pos.m_123343_() + 0.5 + (double)face.m_122431_() * (0.5 + offset);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 4, 0.1, 0.1, 0.1, 0.05);
        }
        if (this.isTNTBlock() && this.m_6060_() && (level = this.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            this.triggerExplosion(serverLevel);
            this.m_146870_();
            return;
        }
        if (this.isSlimeBlock() && this.slimeBounceCount < 2) {
            this.reverseMovementAndRotation();
            this.m_20256_(this.m_20184_().m_82490_(0.8));
            this.f_36703_ = false;
            this.f_36706_ = 0;
            this.f_19804_.m_135381_(ID_IMPACTED, (Object)false);
            this.m_9236_().m_5594_(null, pos, SoundEvents.f_12393_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ++this.slimeBounceCount;
        } else if (this.isSlimeBlock()) {
            this.f_36703_ = true;
            this.f_19804_.m_135381_(ID_IMPACTED, (Object)true);
        }
        if (this.isHoneyBlock()) {
            this.m_20256_(this.m_20184_().m_82490_(0.3));
            this.m_9236_().m_5594_(null, pos, SoundEvents.f_11969_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (this.isRedstoneBlock() && (level = this.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            serverLevel.m_46672_(pos, state.m_60734_());
        }
    }

    @Override
    public int getMaxBreaks() {
        return 1;
    }

    @Override
    public int getMaxHits() {
        return 1;
    }

    @Override
    public boolean canDisableShield(ItemStack shield, LivingEntity shieldHolder, Entity owner) {
        return false;
    }

    @Override
    protected boolean shouldBreakOnEntityHit() {
        return true;
    }

    @Override
    protected boolean shouldBreakOnPiercingExhausted() {
        return true;
    }

    @Override
    protected boolean shouldBreakOnBlockHit() {
        if (this.isSlimeBlock() && this.slimeBounceCount < 2) {
            return false;
        }
        if (this.getPersistentData().m_128471_("BreakOnBlockHit")) {
            return true;
        }
        return true;
    }

    @Override
    protected boolean shouldPlaceBlockOnImpact() {
        BlockItem blockItem;
        ResourceLocation blockId;
        if (!this.getPersistentData().m_128471_("CanPlaceBlock")) {
            return false;
        }
        Item item = this.blockItem.m_41720_();
        if (item instanceof BlockItem && (blockId = ForgeRegistries.ITEMS.getKey((Object)(blockItem = (BlockItem)item))) != null) {
            return ModUtils.matchesList(new HashSet<String>((Collection)JaamsWeaponryCommonConfiguration.SLINGSHOTPLACEABLEBLOCKS.get()), blockId, (Item)blockItem, true);
        }
        return false;
    }

    @Override
    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isTNTBlock() && this.m_6060_() && this.tntFuse == -1) {
                this.tntFuse = 40;
            }
            if (this.tntFuse > 0) {
                --this.tntFuse;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1, 0.05, 0.05, 0.05, 0.02);
                if (this.tntFuse <= 0) {
                    this.triggerExplosion(serverLevel);
                    this.m_146870_();
                }
            }
        }
    }

    private SoundType getBlockSoundType() {
        Item item;
        ItemStack blockItem = this.getBlockItem();
        if (blockItem != null && !blockItem.m_41619_() && (item = blockItem.m_41720_()) instanceof BlockItem) {
            BlockItem blockItemInstance = (BlockItem)item;
            Block block = blockItemInstance.m_40614_();
            return block.m_49966_().m_60827_();
        }
        return SoundType.f_56742_;
    }

    private boolean isMagmaBlock() {
        return this.blockItem.m_41720_() == Items.f_42258_;
    }

    private boolean isTNTBlock() {
        return this.blockItem.m_41720_() == Items.f_41996_;
    }

    private boolean isSlimeBlock() {
        return this.blockItem.m_41720_() == Items.f_42204_;
    }

    private boolean isHoneyBlock() {
        return this.blockItem.m_41720_() == Items.f_42788_;
    }

    private boolean isRedstoneBlock() {
        return this.blockItem.m_41720_() == Items.f_42153_;
    }

    @Override
    protected void triggerExplosion(ServerLevel serverWorld) {
        if (this.isTNTBlock()) {
            serverWorld.m_255391_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.5f, true, Level.ExplosionInteraction.TNT);
            this.m_146870_();
        } else {
            super.triggerExplosion(serverWorld);
        }
    }
}

