/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.entity;

import net.jaams.jaams_weaponry.components.BaseWeaponProjectileEntity;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.handler.events.AdvancementsHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class SpearProjectileEntity
extends BaseWeaponProjectileEntity {
    public SpearProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends BaseWeaponProjectileEntity>)((EntityType)JaamsWeaponryModEntities.SPEAR_PROJECTILE.get()), world);
        this.configureProjectileProperties();
    }

    public SpearProjectileEntity(EntityType<? extends SpearProjectileEntity> type, Level world) {
        super(type, world);
        this.configureProjectileProperties();
    }

    public SpearProjectileEntity(EntityType<? extends SpearProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.configureProjectileProperties();
    }

    public SpearProjectileEntity(EntityType<? extends SpearProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.configureProjectileProperties();
    }

    public SpearProjectileEntity(Level world, LivingEntity entity, ItemStack weaponItem) {
        super((EntityType<? extends BaseWeaponProjectileEntity>)((EntityType)JaamsWeaponryModEntities.SPEAR_PROJECTILE.get()), entity, world, weaponItem);
        this.configureProjectileProperties();
    }

    protected void configureProjectileProperties() {
        this.setPiercingLevel(0);
        this.setAreaDamage(false, 0.0f, 0.0f);
    }

    @Override
    public ItemStack getDefaultWeaponItem() {
        return new ItemStack((ItemLike)JaamsWeaponryModItems.IRON_SPEAR.get());
    }

    @Override
    protected SoundEvent getHitSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:spear_hit"));
        return sound != null ? sound : SoundEvents.f_12514_;
    }

    @Override
    protected SoundEvent getGroundSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:spear_ground"));
        return sound != null ? sound : SoundEvents.f_12515_;
    }

    @Override
    protected SoundEvent getLoyaltySound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:spear_return"));
        return sound != null ? sound : SoundEvents.f_12516_;
    }

    @Override
    public float getWeaponBaseDamage() {
        return 3.0f;
    }

    @Override
    public int getMaxBreaks() {
        return 1;
    }

    @Override
    public int getMaxHits() {
        return 1;
    }

    @Override
    protected void applyHitEffects(LivingEntity entity, EntityHitResult hitResult) {
        Entity entity2;
        boolean isDead;
        boolean bl = isDead = entity.m_21223_() <= 0.0f;
        if (this.isCritical() && (entity2 = this.m_19749_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            if (isDead) {
                boolean shouldIncrementCounter = false;
                boolean isCreative = player.m_150110_().f_35937_;
                if (isCreative) {
                    shouldIncrementCounter = true;
                } else if (entity instanceof Player) {
                    shouldIncrementCounter = true;
                } else if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    boolean bl2 = shouldIncrementCounter = mob.m_5448_() == player;
                }
                if (shouldIncrementCounter) {
                    AdvancementsHandler.incrementCounterAndCheckAdvancement(player, "spear_critical_hits", "spear_of_justice", 3);
                    Vec3 hitLocation = hitResult.m_82450_();
                    entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, hitLocation.f_82479_, hitLocation.f_82480_, hitLocation.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    protected void applyBlockHitEffects(BlockPos pos, BlockState state, BlockHitResult hitResult) {
    }

    protected void m_6901_() {
        ++this.life;
        int despawnTime = Math.max(1, (int)((Double)JaamsWeaponryCommonConfiguration.SPEARDESPAWN.get()).doubleValue());
        if (this.life >= despawnTime) {
            ItemStack itemStack;
            if (((Boolean)JaamsWeaponryCommonConfiguration.DROPASITEM.get()).booleanValue() && this.f_36705_ != AbstractArrow.Pickup.CREATIVE_ONLY) {
                this.dropAsItem();
            } else if (!this.m_9236_().f_46443_ && !(itemStack = this.weaponItem.m_41777_()).m_41619_()) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 5, 0.1, 0.1, 0.1, 0.05);
            }
            this.m_146870_();
        }
    }
}

