/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.entity;

import javax.annotation.Nullable;
import net.jaams.jaams_weaponry.components.BaseStackableProjectileEntity;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class StakeProjectileEntity
extends BaseStackableProjectileEntity {
    public StakeProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends BaseStackableProjectileEntity>)((EntityType)JaamsWeaponryModEntities.STAKE_PROJECTILE.get()), world);
        this.initializeProperties();
    }

    public StakeProjectileEntity(EntityType<? extends StakeProjectileEntity> type, Level world) {
        super(type, world);
        this.initializeProperties();
    }

    public StakeProjectileEntity(EntityType<? extends StakeProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.initializeProperties();
    }

    public StakeProjectileEntity(EntityType<? extends StakeProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.initializeProperties();
    }

    public StakeProjectileEntity(EntityType<? extends StakeProjectileEntity> type, LivingEntity entity, Level world, ItemStack weaponItem) {
        super(type, entity, world, weaponItem);
        this.initializeProperties();
    }

    private void initializeProperties() {
        this.setWeaponDamage(4.0f);
        this.setWeaponKnockback(0.2f);
        this.setHasGravity(true);
    }

    @Override
    public ItemStack getDefaultWeaponItem() {
        return new ItemStack((ItemLike)JaamsWeaponryModItems.STAKE.get());
    }

    @Override
    protected SoundEvent getHitSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:stake_hit"));
        return sound != null ? sound : SoundEvents.f_12514_;
    }

    @Override
    protected SoundEvent getGroundSound() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:stake_ground"));
        return sound != null ? sound : SoundEvents.f_12515_;
    }

    @Override
    public int getMaxBreaks() {
        return 1;
    }

    @Override
    public int getMaxHits() {
        return 1;
    }

    @Override
    protected float calculateDamage(@Nullable Entity entity) {
        LivingEntity livingEntity;
        float baseDamage = super.calculateDamage(entity);
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6336_() == MobType.f_21641_) {
            baseDamage *= 3.5f;
        }
        return baseDamage;
    }

    @Override
    protected void applyHitEffects(LivingEntity entity, EntityHitResult hitResult) {
    }

    @Override
    protected void applyBlockHitEffects(BlockPos pos, BlockState state, BlockHitResult hitResult) {
    }

    @Override
    public void setWeaponDamage(float damage) {
        this.getPersistentData().m_128350_("BaseWeaponDamage", Math.max(0.0f, damage));
    }

    @Override
    public void setWeaponKnockback(float strength) {
        this.getPersistentData().m_128350_("WeaponKnockbackStrength", Math.max(0.0f, strength));
    }

    @Override
    public boolean canDisableShield(ItemStack shield, LivingEntity shieldHolder, Entity owner) {
        return false;
    }

    @Override
    protected boolean shouldBreakOnEntityHit() {
        return true;
    }

    @Override
    protected boolean shouldBreakOnPiercingExhausted() {
        return true;
    }

    @Override
    protected boolean shouldBreakOnBlockHit() {
        return false;
    }

    protected void m_6901_() {
        ++this.life;
        int despawnTime = Math.max(1, (int)((Double)JaamsWeaponryCommonConfiguration.STAKEDESPAWN.get()).doubleValue());
        if (this.life >= despawnTime) {
            if (((Boolean)JaamsWeaponryCommonConfiguration.DROPASITEM.get()).booleanValue() && this.f_36705_ != AbstractArrow.Pickup.CREATIVE_ONLY) {
                this.dropAsItem();
            } else {
                this.handleItemBreak();
            }
            this.m_146870_();
        }
    }
}

