/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.entity;

import net.jaams.jaams_weaponry.components.BaseWeaponProjectileEntity;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class TridentProjectileEntity
extends BaseWeaponProjectileEntity {
    public TridentProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType<? extends BaseWeaponProjectileEntity>)((EntityType)JaamsWeaponryModEntities.TRIDENT_PROJECTILE.get()), world);
        this.configureProjectileProperties();
    }

    public TridentProjectileEntity(EntityType<? extends TridentProjectileEntity> type, Level world) {
        super(type, world);
        this.configureProjectileProperties();
    }

    public TridentProjectileEntity(EntityType<? extends TridentProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.configureProjectileProperties();
    }

    public TridentProjectileEntity(EntityType<? extends TridentProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
        this.configureProjectileProperties();
    }

    public TridentProjectileEntity(Level world, LivingEntity entity, ItemStack weaponItem) {
        super((EntityType<? extends BaseWeaponProjectileEntity>)((EntityType)JaamsWeaponryModEntities.TRIDENT_PROJECTILE.get()), entity, world, weaponItem);
        this.configureProjectileProperties();
    }

    protected void configureProjectileProperties() {
        this.setPiercingLevel(0);
        this.setAreaDamage(false, 0.0f, 0.0f);
    }

    @Override
    public ItemStack getDefaultWeaponItem() {
        return new ItemStack((ItemLike)Items.f_42713_);
    }

    @Override
    protected SoundEvent getHitSound() {
        return SoundEvents.f_12514_;
    }

    @Override
    protected SoundEvent getLoyaltySound() {
        return SoundEvents.f_12516_;
    }

    @Override
    protected SoundEvent getGroundSound() {
        return SoundEvents.f_12515_;
    }

    @Override
    public float getWeaponBaseDamage() {
        return 2.0f;
    }

    @Override
    public int getMaxBreaks() {
        return 1;
    }

    @Override
    public int getMaxHits() {
        return 1;
    }

    @Override
    protected void applyHitEffects(LivingEntity entity, EntityHitResult hitResult) {
    }

    @Override
    protected void applyBlockHitEffects(BlockPos pos, BlockState state, BlockHitResult hitResult) {
    }

    @Override
    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        SoundEvent soundEvent = this.getHitSound();
        float damageMultiplier = 1.0f;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            LightningBolt lightningBolt;
            BlockPos blockPos;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_9236_().m_46470_() && this.isChanneling() && serverLevel.m_45527_(blockPos = entity.m_20183_()) && (lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel)) != null) {
                lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)blockPos));
                lightningBolt.m_20879_(this.m_19749_() instanceof ServerPlayer ? (ServerPlayer)this.m_19749_() : null);
                serverLevel.m_7967_((Entity)lightningBolt);
                soundEvent = SoundEvents.f_12521_;
                damageMultiplier = 5.0f;
            }
        }
    }

    protected void m_6901_() {
        ++this.life;
        int despawnTime = Math.max(1, (int)((Double)JaamsWeaponryCommonConfiguration.TRIDENTDESPAWN.get()).doubleValue());
        if (this.life >= despawnTime) {
            ItemStack itemStack;
            if (((Boolean)JaamsWeaponryCommonConfiguration.DROPASITEM.get()).booleanValue() && this.f_36705_ != AbstractArrow.Pickup.CREATIVE_ONLY) {
                this.dropAsItem();
            } else if (!this.m_9236_().f_46443_ && !(itemStack = this.weaponItem.m_41777_()).m_41619_()) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 5, 0.1, 0.1, 0.1, 0.05);
            }
            this.m_146870_();
        }
    }

    @Override
    protected float m_6882_() {
        return 0.99f;
    }

    private boolean isChanneling() {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44958_, (ItemStack)this.weaponItem) > 0;
    }
}

