/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.guns.shoot;

import net.jaams.jaams_weaponry.JaamsWeaponryMod;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.guns.util.GunUtils;
import net.jaams.jaams_weaponry.handler.guns.GunActionsHandler;
import net.jaams.jaams_weaponry.handler.guns.GunSoundHandler;
import net.jaams.jaams_weaponry.handler.guns.GunStorageHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEntities;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.packets.VisualRecoilPacket;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.PacketDistributor;

public class PistolShoot {
    public static final double COOLDOWN = 30.0;
    public static final int OFFHAND_COOLDOWN = 10;
    public static final double DEFAULT_MODIFIER = 1.0;
    public static final int PROJECTILE_COUNT = 1;
    public static final float SPREAD_ANGLE = 0.0f;
    public static final float GUN_SHOT_SIZE = 0.8f;
    public static final float GUN_SHOT_DISTANCE = 0.8f;
    public static final double GHOST_CLIP_CHANCE = 0.15;
    public static final double FRAMEGUARD_CHANCE = 0.15;
    public static final float SHAKE_INTENSITY = 0.5f;
    public static final int SHAKE_RESET_DELAY = 5;
    public static final float RECOIL_DISTANCE = 0.35f;
    public static final float CROUCH_RECOIL_REDUCTION = 0.6f;
    public static final float VERTICAL_RECOIL_MULTIPLIER = 0.45f;
    public static final float XROT_RECOIL_INTENSITY = 1.75f;
    public static final double BULLET_DAMAGE = 8.0;
    public static final double BULLET_KNOCKBACK = 0.5;
    public static final int BULLET_PIERCING = 0;
    public static final double BULLET_SPEED = 4.5;
    public static final double BULLET_INACCURACY = 0.0;
    public static final double FIRE_BULLET_DAMAGE = 7.0;
    public static final double FIRE_BULLET_KNOCKBACK = 0.5;
    public static final int FIRE_BULLET_PIERCING = 0;
    public static final double FIRE_BULLET_SPEED = 4.5;
    public static final double FIRE_BULLET_INACCURACY = 0.0;
    public static final double HEAVY_BULLET_DAMAGE = 12.0;
    public static final double HEAVY_BULLET_KNOCKBACK = 1.0;
    public static final int HEAVY_BULLET_PIERCING = 0;
    public static final double HEAVY_BULLET_SPEED = 2.2;
    public static final double HEAVY_BULLET_INACCURACY = 0.0;
    public static final double HEAVY_BULLET_COOLDOWN_ADDITION = 20.0;
    public static final double GLOWING_BULLET_DAMAGE = 7.0;
    public static final double GLOWING_BULLET_KNOCKBACK = 0.5;
    public static final int GLOWING_BULLET_PIERCING = 0;
    public static final double GLOWING_BULLET_SPEED = 4.5;
    public static final double GLOWING_BULLET_INACCURACY = 0.0;
    public static final double ECHO_BULLET_DAMAGE = 7.0;
    public static final double ECHO_BULLET_KNOCKBACK = 0.5;
    public static final int ECHO_BULLET_PIERCING = 0;
    public static final double ECHO_BULLET_SPEED = 4.5;
    public static final double ECHO_BULLET_INACCURACY = 0.0;
    public static final double SHARP_BULLET_DAMAGE = 7.0;
    public static final double SHARP_BULLET_KNOCKBACK = 0.2;
    public static final int SHARP_BULLET_PIERCING = 3;
    public static final double SHARP_BULLET_SPEED = 4.5;
    public static final double SHARP_BULLET_INACCURACY = 0.0;
    public static final double MUZZLE_MODIFIER = 1.5;
    public static final double MAGAZINE_MODIFIER = 2.0;
    public static final Item MUZZLE_ATTACHMENT = (Item)JaamsWeaponryModItems.COPPER_MUZZLE.get();
    public static final Item MAGAZINE_ATTACHMENT = (Item)JaamsWeaponryModItems.COPPER_QUICK_DRAW_MAGAZINE.get();

    public static void shoot(LevelAccessor level, double x, double y, double z, Entity entity, ItemStack itemstack) {
        ItemStack bulletFromInventory;
        if (entity == null || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        double muzzle = GunUtils.getItemStack(itemstack, 0).m_41720_() == MUZZLE_ATTACHMENT ? 1.5 : 0.0;
        double magazineModifier = GunUtils.getItemStack(itemstack, 2).m_41720_() == MAGAZINE_ATTACHMENT ? 2.0 : 1.0;
        boolean isClientSide = level.m_5776_();
        if (itemstack.m_41773_() == itemstack.m_41776_() - 1 && !isClientSide) {
            GunUtils.spawnParticles(level, entity, itemstack);
        }
        boolean fromInventory = (Boolean)JaamsWeaponryCommonConfiguration.AMMOFROMPLAYERINVENTORY.get();
        boolean fromHand = (Boolean)JaamsWeaponryCommonConfiguration.AMMOFROMHAND.get();
        boolean fromGun = (Boolean)JaamsWeaponryCommonConfiguration.AMMOFROMGUN.get();
        ItemStack bulletFromGun = fromGun ? GunUtils.getBulletFromGun(itemstack, false) : ItemStack.f_41583_;
        ItemStack bulletFromHand = fromHand ? GunUtils.getBulletFromHands(player, false) : ItemStack.f_41583_;
        ItemStack itemStack = bulletFromInventory = fromInventory ? GunUtils.getBulletFromInventory(player, false) : ItemStack.f_41583_;
        if (bulletFromGun.m_41619_() && bulletFromHand.m_41619_() && bulletFromInventory.m_41619_()) {
            if (player.m_7500_()) {
                PistolShoot.processShot(level, player, itemstack, muzzle, 30.0, magazineModifier, "message.gun.bullets", (EntityType<? extends AbstractArrow>)((EntityType)JaamsWeaponryModEntities.BULLET_PROJECTILE.get()), 8.0, 0.5, 0, 4.5, 0.0, false, fromHand, fromInventory);
            } else {
                GunSoundHandler.playPistolEmptySound(level, x, y, z, entity, itemstack);
            }
        } else {
            ItemStack bulletItem = GunUtils.getBulletFromSources(player, itemstack, fromGun, fromHand, fromInventory, false);
            if (bulletItem.m_41720_() == JaamsWeaponryModItems.BULLET.get()) {
                PistolShoot.processShot(level, player, itemstack, muzzle, 30.0, magazineModifier, "message.gun.bullets", (EntityType<? extends AbstractArrow>)((EntityType)JaamsWeaponryModEntities.BULLET_PROJECTILE.get()), 8.0, 0.5, 0, 4.5, 0.0, fromGun, fromHand, fromInventory);
            } else if (bulletItem.m_41720_() == JaamsWeaponryModItems.FIRE_BULLET.get()) {
                PistolShoot.processShot(level, player, itemstack, muzzle, 30.0, magazineModifier, "message.gun.fire_bullets", (EntityType<? extends AbstractArrow>)((EntityType)JaamsWeaponryModEntities.FIRE_BULLET_PROJECTILE.get()), 7.0, 0.5, 0, 4.5, 0.0, fromGun, fromHand, fromInventory);
            } else if (bulletItem.m_41720_() == JaamsWeaponryModItems.HEAVY_BULLET.get()) {
                PistolShoot.processShot(level, player, itemstack, muzzle, 50.0, magazineModifier, "message.gun.heavy_bullets", (EntityType<? extends AbstractArrow>)((EntityType)JaamsWeaponryModEntities.HEAVY_BULLET_PROJECTILE.get()), 12.0, 1.0, 0, 2.2, 0.0, fromGun, fromHand, fromInventory);
            } else if (bulletItem.m_41720_() == JaamsWeaponryModItems.GLOWING_BULLET.get()) {
                PistolShoot.processShot(level, player, itemstack, muzzle, 30.0, magazineModifier, "message.gun.glowing_bullets", (EntityType<? extends AbstractArrow>)((EntityType)JaamsWeaponryModEntities.GLOWING_BULLET_PROJECTILE.get()), 7.0, 0.5, 0, 4.5, 0.0, fromGun, fromHand, fromInventory);
            } else if (bulletItem.m_41720_() == JaamsWeaponryModItems.ECHO_BULLET.get()) {
                PistolShoot.processShot(level, player, itemstack, muzzle, 30.0, magazineModifier, "message.gun.echo_bullets", (EntityType<? extends AbstractArrow>)((EntityType)JaamsWeaponryModEntities.ECHO_BULLET_PROJECTILE.get()), 7.0, 0.5, 0, 4.5, 0.0, fromGun, fromHand, fromInventory);
            } else if (bulletItem.m_41720_() == JaamsWeaponryModItems.SHARP_BULLET.get()) {
                PistolShoot.processShot(level, player, itemstack, muzzle, 30.0, magazineModifier, "message.gun.sharp_bullets", (EntityType<? extends AbstractArrow>)((EntityType)JaamsWeaponryModEntities.SHARP_BULLET_PROJECTILE.get()), 7.0, 0.2, 3, 4.5, 0.0, fromGun, fromHand, fromInventory);
            }
        }
    }

    private static void processShot(LevelAccessor level, Player player, ItemStack itemstack, double muzzle, double cooldown, double magazineModifier, String messageKey, EntityType<? extends AbstractArrow> projectileType, double damage, double knockback, int piercing, double speed, double inaccuracy, boolean fromGun, boolean fromHand, boolean fromInventory) {
        GunActionsHandler.handleGunShot(level, (Entity)player, itemstack, 0.8f, 0.8f);
        int cooldownTicks = (int)(cooldown / magazineModifier);
        GunUtils.shootProjectilesAndSound(level, (Entity)player, itemstack, muzzle, speed, projectileType, damage, knockback, piercing, inaccuracy, 1, 0.0f, GunSoundHandler::playPistolAttachmentSound);
        GunUtils.updateGunState(level, (Entity)player, itemstack, messageKey, 0.15);
        GunUtils.applyCooldowns(player, itemstack, cooldownTicks += GunUtils.handleAmmoConsumption(player, itemstack, fromGun, fromHand, fromInventory, 1, 0.15, GunStorageHandler::handleOneShot), 10);
        ModUtils.applyShakeEffect((Entity)player, 0.5, 5);
        GunUtils.applyPhysicalRecoil((LivingEntity)player, itemstack, 0.35f, 0.6f, 0.45f);
        JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new VisualRecoilPacket(1.75f));
    }
}

