/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.guns.util;

import io.netty.buffer.Unpooled;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.jaams.jaams_weaponry.JaamsWeaponryMod;
import net.jaams.jaams_weaponry.components.BaseBulletProjectileEntity;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.guns.shoot.PistolShoot;
import net.jaams.jaams_weaponry.guns.shoot.ScattergunShoot;
import net.jaams.jaams_weaponry.guns.shoot.ShotgunShoot;
import net.jaams.jaams_weaponry.handler.guns.GunActionsHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEnchantments;
import net.jaams.jaams_weaponry.packets.GunShootPacket;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.jaams.jaams_weaponry.world.inventory.PistolGUIMenu;
import net.jaams.jaams_weaponry.world.inventory.ScattergunGUIMenu;
import net.jaams.jaams_weaponry.world.inventory.ShotgunGUIMenu;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GunUtils {
    private static final ResourceLocation BULLETS_TAG = new ResourceLocation("jaams_weaponry:bullets");
    private static final ResourceLocation SHOTSHELLS_TAG = new ResourceLocation("jaams_weaponry:shotshells");

    public static void shoot(Level world, ServerPlayer player, ItemStack itemStack) {
        if (itemStack.m_204117_(TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation("jaams_weaponry:pistols")))) {
            PistolShoot.shoot((LevelAccessor)world, player.m_20185_(), player.m_20186_(), player.m_20189_(), (Entity)player, itemStack);
        } else if (itemStack.m_204117_(TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation("jaams_weaponry:scatterguns")))) {
            ScattergunShoot.shoot((LevelAccessor)world, player.m_20185_(), player.m_20186_(), player.m_20189_(), (Entity)player, itemStack);
        } else if (itemStack.m_204117_(TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation("jaams_weaponry:shotguns")))) {
            ShotgunShoot.shoot((LevelAccessor)world, player.m_20185_(), player.m_20186_(), player.m_20189_(), (Entity)player, itemStack);
        }
    }

    public static void applyPhysicalRecoil(LivingEntity entity, ItemStack itemstack, float recoilDistance, float crouchRecoilReduction, float verticalRecoilMultiplier) {
        int backblastLevel = itemstack.getEnchantmentLevel((Enchantment)JaamsWeaponryModEnchantments.BACKBLAST.get());
        if (backblastLevel > 0) {
            float backblastBonus = 0.25f * (float)backblastLevel;
            float fireDurationBonus = 2.0f * (float)backblastLevel;
            float enhancedVerticalRecoil = verticalRecoilMultiplier + 0.05f * (float)backblastLevel;
            float baseDamage = 2.0f * (float)backblastLevel;
            GunActionsHandler.applyBackblastRecoil(entity, recoilDistance, crouchRecoilReduction, enhancedVerticalRecoil, backblastBonus, fireDurationBonus, baseDamage);
        } else {
            ModUtils.applyRecoil(entity, recoilDistance, crouchRecoilReduction, verticalRecoilMultiplier);
        }
    }

    public static void applyVisualRecoil(Player player, float xRotRecoilIntensity) {
        player.m_146926_(player.m_146909_() - xRotRecoilIntensity);
    }

    public static void applyCooldowns(Player player, ItemStack itemstack, int cooldownTicks, int offhandCooldown) {
        ItemStack offhandItem;
        if (cooldownTicks > 0) {
            player.m_36335_().m_41524_(itemstack.m_41720_(), cooldownTicks);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new GunShootPacket(player.m_7655_(), cooldownTicks));
            }
        }
        if (!(offhandItem = player.m_21206_()).m_41619_() && !offhandItem.equals(itemstack) && offhandCooldown > 0 && player.m_36335_().m_41521_(offhandItem.m_41720_(), 0.0f) == 0.0f) {
            player.m_36335_().m_41524_(offhandItem.m_41720_(), offhandCooldown);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new GunShootPacket(InteractionHand.OFF_HAND, offhandCooldown));
            }
        }
    }

    public static void updateGunState(LevelAccessor level, Entity entity, ItemStack itemstack, String messageKey, double frameguardChance) {
        GunActionsHandler.updateAmmoCount(itemstack);
        int frameGuardLevel = itemstack.getEnchantmentLevel((Enchantment)JaamsWeaponryModEnchantments.FRAMEGUARD.get());
        boolean breakGun = true;
        if (frameGuardLevel > 0) {
            double noBreakChance = frameguardChance * (double)frameGuardLevel;
            if (level.m_213780_().m_188500_() < noBreakChance) {
                breakGun = false;
            }
        }
        if (breakGun) {
            GunActionsHandler.handleGunBreak(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity, itemstack);
        }
        GunUtils.showBulletCount(entity, itemstack, messageKey);
    }

    public static int handleAmmoConsumption(Player player, ItemStack itemstack, boolean fromGun, boolean fromHand, boolean fromInventory, int bulletConsumption, double ghostClipChance, Consumer<ItemStack> handleGunAmmo) {
        ItemStack bulletItem = GunUtils.getBulletFromSources(player, itemstack, fromGun, fromHand, fromInventory, false);
        int additionalCooldown = 0;
        boolean consumeAmmo = true;
        int ghostClipLevel = itemstack.getEnchantmentLevel((Enchantment)JaamsWeaponryModEnchantments.GHOST_CLIP.get());
        if (ghostClipLevel > 0) {
            double noConsumeChance = ghostClipChance * (double)ghostClipLevel;
            if (player.m_217043_().m_188500_() < noConsumeChance) {
                consumeAmmo = false;
            }
        }
        if (!player.m_7500_() && consumeAmmo) {
            if (bulletItem == GunUtils.getBulletFromGun(itemstack, false)) {
                handleGunAmmo.accept(itemstack);
            } else if (bulletItem == GunUtils.getBulletFromHands(player, false)) {
                bulletItem.m_41774_(bulletConsumption);
                additionalCooldown = 20;
            } else if (bulletItem == GunUtils.getBulletFromInventory(player, false)) {
                bulletItem.m_41774_(bulletConsumption);
                additionalCooldown = 40;
            }
        } else if (bulletItem == GunUtils.getBulletFromHands(player, false)) {
            additionalCooldown = 20;
        } else if (bulletItem == GunUtils.getBulletFromInventory(player, false)) {
            additionalCooldown = 40;
        }
        return additionalCooldown;
    }

    public static void shootProjectilesAndSound(LevelAccessor level, Entity entity, ItemStack itemstack, double muzzle, double speed, EntityType<? extends AbstractArrow> projectileType, double damage, double knockback, int piercing, double inaccuracy, int projectileCount, float spreadAngle, GunSoundPlayer playSound) {
        GunUtils.shootProjectile(level, entity, muzzle, speed, projectileType, damage, knockback, piercing, inaccuracy, projectileCount, spreadAngle);
        playSound.play(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity, itemstack);
    }

    public static ItemStack getBulletFromSources(Player player, ItemStack gunStack, boolean fromGun, boolean fromHand, boolean fromInventory, boolean isShotgun) {
        ItemStack bulletFromInventory;
        ItemStack bulletFromHand;
        ItemStack bulletFromGun;
        if (fromGun && !(bulletFromGun = GunUtils.getBulletFromGun(gunStack, isShotgun)).m_41619_()) {
            return bulletFromGun;
        }
        if (fromHand && !(bulletFromHand = GunUtils.getBulletFromHands(player, isShotgun)).m_41619_()) {
            return bulletFromHand;
        }
        if (fromInventory && !(bulletFromInventory = GunUtils.getBulletFromInventory(player, isShotgun)).m_41619_()) {
            return bulletFromInventory;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getBulletFromGun(ItemStack gunStack, boolean isShotgun) {
        return gunStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(capability -> {
            ItemStack bulletItem = capability.getStackInSlot(1);
            if (GunUtils.isValidAmmo(bulletItem, isShotgun)) {
                return bulletItem;
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }

    public static ItemStack getBulletFromHands(Player player, boolean isShotgun) {
        ItemStack bulletItem = player.m_21205_();
        if (GunUtils.isValidAmmo(bulletItem, isShotgun)) {
            return bulletItem;
        }
        bulletItem = player.m_21206_();
        if (GunUtils.isValidAmmo(bulletItem, isShotgun)) {
            return bulletItem;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getBulletFromInventory(Player player, boolean isShotgun) {
        ItemStack bulletItem = player.m_21206_();
        if (GunUtils.isValidAmmo(bulletItem, isShotgun)) {
            return bulletItem;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!GunUtils.isValidAmmo(stack, isShotgun)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private static boolean isValidAmmo(ItemStack itemStack, boolean isShotgun) {
        return isShotgun ? itemStack.m_204117_(ItemTags.create((ResourceLocation)SHOTSHELLS_TAG)) : itemStack.m_204117_(ItemTags.create((ResourceLocation)BULLETS_TAG));
    }

    public static void shootProjectile(LevelAccessor level, Entity entity, double damageModifier, double speed, EntityType<? extends AbstractArrow> projectileType, double damage, double knockback, int piercing, double inaccuracy, int projectileCount, double spreadAngle) {
        if (!level.m_5776_()) {
            Level projectileLevel = entity.m_9236_();
            Vec3 upVector = entity.m_20289_(1.0f);
            double angleStep = projectileCount > 1 ? spreadAngle / (double)(projectileCount - 1) : 0.0;
            for (int i = 0; i < projectileCount; ++i) {
                AbstractArrow projectile = (AbstractArrow)projectileType.m_20615_(projectileLevel);
                if (!(projectile instanceof BaseBulletProjectileEntity)) continue;
                BaseBulletProjectileEntity bullet = (BaseBulletProjectileEntity)projectile;
                bullet.m_5602_(entity);
                bullet.setBulletDamage((float)(damage + damageModifier));
                bullet.setBulletKnockback((float)knockback);
                bullet.setPiercingLevel(piercing);
                bullet.m_6034_(entity.m_20185_(), entity.m_20188_() - 0.1, entity.m_20189_());
                double rotation = projectileCount == 1 ? 0.0 : (double)i * angleStep - spreadAngle / 2.0;
                Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis(rotation * Math.PI / 180.0, upVector.f_82479_, upVector.f_82480_, upVector.f_82481_);
                Vec3 viewVector = entity.m_20252_(1.0f);
                Vector3f rotatedVector = viewVector.m_252839_().rotate((Quaternionfc)rotationQuaternion);
                Vec3 direction = new Vec3((double)rotatedVector.x(), (double)rotatedVector.y(), (double)rotatedVector.z());
                direction = direction.m_82520_(level.m_213780_().m_188583_() * inaccuracy, level.m_213780_().m_188583_() * inaccuracy, level.m_213780_().m_188583_() * inaccuracy).m_82541_().m_82490_(speed);
                bullet.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, (float)speed, 0.0f);
                projectileLevel.m_7967_((Entity)bullet);
            }
        }
    }

    public static void showBulletCount(Entity entity, ItemStack itemstack, String messageKey) {
        Player player;
        if (((Boolean)JaamsWeaponryClientConfiguration.AMMOCOUNT.get()).booleanValue() && ((Boolean)JaamsWeaponryCommonConfiguration.AMMOFROMGUN.get()).booleanValue() && entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_() && !GunUtils.getBulletFromGun(itemstack, false).m_41619_()) {
            double bulletCount = itemstack.m_41784_().m_128459_("bulletamount");
            player.m_5661_((Component)Component.m_237115_((String)messageKey).m_130946_(" " + new DecimalFormat("##").format(bulletCount)), true);
        }
    }

    public static void spawnParticles(LevelAccessor level, Entity entity, ItemStack itemstack) {
        ServerLevel serverLevel = (ServerLevel)level;
        double xOffset = entity.m_20185_() + entity.m_20154_().f_82479_ * 0.5;
        double yOffset = entity.m_20186_() + (double)entity.m_20192_();
        double zOffset = entity.m_20189_() + entity.m_20154_().f_82481_ * 0.5;
        serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), xOffset, yOffset, zOffset, 5, 0.1, 0.1, 0.1, 0.05);
    }

    public static ItemStack getItemStack(ItemStack itemstack, int slot) {
        AtomicReference<ItemStack> result = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        itemstack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> result.set(capability.getStackInSlot(slot).m_41777_()));
        return result.get();
    }

    public static void openPistolInventory(ServerPlayer serverPlayer, ItemStack itemStack, final InteractionHand hand) {
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Gun Storage");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                buffer.m_130064_(player.m_20183_());
                buffer.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                return new PistolGUIMenu(id, inventory, buffer);
            }
        }, buf -> {
            buf.m_130064_(serverPlayer.m_20183_());
            buf.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
        });
        serverPlayer.m_21011_(hand, true);
    }

    public static void openScattergunInventory(ServerPlayer serverPlayer, ItemStack itemStack, final InteractionHand hand) {
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Gun Storage");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                buffer.m_130064_(player.m_20183_());
                buffer.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                return new ScattergunGUIMenu(id, inventory, buffer);
            }
        }, buf -> {
            buf.m_130064_(serverPlayer.m_20183_());
            buf.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
        });
        serverPlayer.m_21011_(hand, true);
    }

    public static void openShotgunInventory(ServerPlayer serverPlayer, ItemStack itemStack, final InteractionHand hand) {
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Gun Storage");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                buffer.m_130064_(player.m_20183_());
                buffer.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                return new ShotgunGUIMenu(id, inventory, buffer);
            }
        }, buf -> {
            buf.m_130064_(serverPlayer.m_20183_());
            buf.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
        });
        serverPlayer.m_21011_(hand, true);
    }

    @FunctionalInterface
    public static interface GunSoundPlayer {
        public void play(LevelAccessor var1, double var2, double var4, double var6, Entity var8, ItemStack var9);
    }
}

