/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.effects;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMobEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_weaponry", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArchersGraceHandler {
    private static final Map<LivingEntity, ArchersGraceData> archersGraceEntities = new ConcurrentHashMap<LivingEntity, ArchersGraceData>();
    private static final String ARCHERS_GRACE_NBT_KEY = "ArchersGrace";
    private static final int CLEANUP_DELAY = 5;
    private static final int MIN_USE_TICKS = 20;

    private static boolean isArchersGraceEnabled() {
        return (Boolean)JaamsWeaponryCommonConfiguration.ARCHERSGRACE.get();
    }

    @SubscribeEvent
    public static void onLivingUpdateEffect(MobEffectEvent.Added event) {
        if (!ArchersGraceHandler.isArchersGraceEnabled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (event.getEffectInstance().m_19544_() == JaamsWeaponryModMobEffects.ARCHERS_GRACE.get()) {
            archersGraceEntities.put(entity, new ArchersGraceData(entity.m_9236_().m_46467_(), ItemStack.f_41583_, 0));
        }
    }

    @SubscribeEvent
    public static void onLivingRemoveEffect(MobEffectEvent.Remove event) {
        if (!ArchersGraceHandler.isArchersGraceEnabled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null && effectInstance.m_19544_() == JaamsWeaponryModMobEffects.ARCHERS_GRACE.get()) {
            archersGraceEntities.remove(entity);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!ArchersGraceHandler.isArchersGraceEnabled()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack itemStack = player.m_21120_(event.getHand());
        if (ArchersGraceHandler.isValidItem(itemStack) && player.m_21023_((MobEffect)JaamsWeaponryModMobEffects.ARCHERS_GRACE.get())) {
            archersGraceEntities.put((LivingEntity)player, new ArchersGraceData(player.m_9236_().m_46467_(), itemStack, 0));
        }
    }

    @SubscribeEvent
    public static void onArchersGraceCrossbow(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack itemStack = player.m_21120_(event.getHand());
        if (itemStack.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)itemStack) && player.m_21023_((MobEffect)JaamsWeaponryModMobEffects.ARCHERS_GRACE.get())) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("jaams_weaponry", "archers_grace_shoot")), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        ArchersGraceData data;
        if (!ArchersGraceHandler.isArchersGraceEnabled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_5776_() && (data = archersGraceEntities.get(entity)) != null) {
            if (!entity.m_21023_((MobEffect)JaamsWeaponryModMobEffects.ARCHERS_GRACE.get())) {
                long currentTick = entity.m_9236_().m_46467_();
                if (currentTick - data.lastUseTick >= 5L) {
                    archersGraceEntities.remove(entity);
                }
            } else if (entity.m_6117_() && ArchersGraceHandler.isValidItem(entity.m_21211_())) {
                ++data.useDuration;
            } else {
                data.useDuration = 0;
                data.usedItem = ItemStack.f_41583_;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        LivingEntity entity;
        ArchersGraceData data;
        AbstractArrow arrow;
        if (!ArchersGraceHandler.isArchersGraceEnabled()) {
            return;
        }
        Entity entity2 = event.getEntity();
        if (entity2 instanceof AbstractArrow && (entity2 = (arrow = (AbstractArrow)entity2).m_19749_()) instanceof LivingEntity && (data = archersGraceEntities.get(entity = (LivingEntity)entity2)) != null && data.useDuration >= 20 && ArchersGraceHandler.isValidItem(data.usedItem) && !entity.m_9236_().m_5776_()) {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("jaams_weaponry", "archers_grace_shoot")), SoundSource.PLAYERS, 1.0f, 1.0f);
            arrow.getPersistentData().m_128379_(ARCHERS_GRACE_NBT_KEY, true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (!ArchersGraceHandler.isArchersGraceEnabled()) {
            return;
        }
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            if (event.getEntity() instanceof LivingEntity && arrow.getPersistentData().m_128471_(ARCHERS_GRACE_NBT_KEY)) {
                MobEffectInstance effect;
                LivingEntity sourceEntity = (LivingEntity)arrow.m_19749_();
                if (sourceEntity != null && (effect = sourceEntity.m_21124_((MobEffect)JaamsWeaponryModMobEffects.ARCHERS_GRACE.get())) != null) {
                    int level = effect.m_19564_() + 1;
                    float damageMultiplier = 1.0f + 0.5f * (float)level;
                    float originalDamage = event.getAmount();
                    float increasedDamage = originalDamage * damageMultiplier;
                    event.setAmount(increasedDamage);
                }
                arrow.getPersistentData().m_128473_(ARCHERS_GRACE_NBT_KEY);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (!ArchersGraceHandler.isArchersGraceEnabled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        archersGraceEntities.remove(entity);
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!ArchersGraceHandler.isArchersGraceEnabled()) {
            return;
        }
        Player player = event.getEntity();
        archersGraceEntities.remove(player);
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        if (!ArchersGraceHandler.isArchersGraceEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(entity instanceof Player)) {
                archersGraceEntities.remove(livingEntity);
            }
        }
    }

    private static boolean isValidItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        UseAnim anim = item.m_6164_(itemStack);
        return item instanceof BowItem || item instanceof CrossbowItem || anim == UseAnim.BOW || anim == UseAnim.CROSSBOW || anim == UseAnim.SPEAR;
    }

    private static class ArchersGraceData {
        long lastUseTick;
        ItemStack usedItem;
        int useDuration;

        ArchersGraceData(long lastUseTick, ItemStack usedItem, int useDuration) {
            this.lastUseTick = lastUseTick;
            this.usedItem = usedItem.m_41777_();
            this.useDuration = useDuration;
        }
    }
}

