/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.effects;

import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMobEffects;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_weaponry", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RestrictedEffectHandler {
    private static boolean isKnockedUpEnabled() {
        return (Boolean)JaamsWeaponryCommonConfiguration.KNOCKEDUP.get();
    }

    private static boolean isIncapableEnabled() {
        return (Boolean)JaamsWeaponryCommonConfiguration.INCAPABLE.get();
    }

    @SubscribeEvent
    public static void onRestrictedItemUse(PlayerInteractEvent.RightClickItem event) {
        MobEffectInstance incapableEffect;
        if (!RestrictedEffectHandler.isKnockedUpEnabled() && !RestrictedEffectHandler.isIncapableEnabled()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        MobEffectInstance knockedUpEffect = RestrictedEffectHandler.isKnockedUpEnabled() ? player.m_21124_((MobEffect)JaamsWeaponryModMobEffects.KNOCKED_UP.get()) : null;
        MobEffectInstance mobEffectInstance = incapableEffect = RestrictedEffectHandler.isIncapableEnabled() ? player.m_21124_((MobEffect)JaamsWeaponryModMobEffects.INCAPABLE.get()) : null;
        if (knockedUpEffect != null || incapableEffect != null) {
            int maxDuration = 0;
            if (knockedUpEffect != null) {
                maxDuration = Math.max(maxDuration, knockedUpEffect.m_19557_());
            }
            if (incapableEffect != null) {
                maxDuration = Math.max(maxDuration, incapableEffect.m_19557_());
            }
            player.m_36335_().m_41524_(event.getItemStack().m_41720_(), maxDuration);
            event.setCanceled(true);
            ModUtils.playSound((Entity)player, "jaams_weaponry:incapable_using");
        }
    }

    @SubscribeEvent
    public static void onRestrictedPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!RestrictedEffectHandler.isKnockedUpEnabled() && !RestrictedEffectHandler.isIncapableEnabled()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (ModUtils.hasRestrictedEffect((LivingEntity)player)) {
            player.m_5810_();
        }
    }

    @SubscribeEvent
    public static void onKnockedUpRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!RestrictedEffectHandler.isKnockedUpEnabled()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_21023_((MobEffect)JaamsWeaponryModMobEffects.KNOCKED_UP.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKnockedUpJump(LivingEvent.LivingJumpEvent event) {
        if (!RestrictedEffectHandler.isKnockedUpEnabled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)JaamsWeaponryModMobEffects.KNOCKED_UP.get())) {
            entity.m_6853_(true);
            entity.m_20256_(new Vec3(entity.m_20184_().f_82479_, -0.1, entity.m_20184_().f_82481_));
        }
    }

    @SubscribeEvent
    public static void onRestrictedBreakBlock(BlockEvent.BreakEvent event) {
        if (!RestrictedEffectHandler.isKnockedUpEnabled() && !RestrictedEffectHandler.isIncapableEnabled()) {
            return;
        }
        if (ModUtils.hasRestrictedEffect((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRestrictedLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!RestrictedEffectHandler.isKnockedUpEnabled() && !RestrictedEffectHandler.isIncapableEnabled()) {
            return;
        }
        if (ModUtils.hasRestrictedEffect((LivingEntity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRestrictedPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Player player;
        if (!RestrictedEffectHandler.isKnockedUpEnabled() && !RestrictedEffectHandler.isIncapableEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player && ModUtils.hasRestrictedEffect((LivingEntity)(player = (Player)entity))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRestrictedRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!RestrictedEffectHandler.isKnockedUpEnabled() && !RestrictedEffectHandler.isIncapableEnabled()) {
            return;
        }
        if (ModUtils.hasRestrictedEffect((LivingEntity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRestrictedEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!RestrictedEffectHandler.isKnockedUpEnabled() && !RestrictedEffectHandler.isIncapableEnabled()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        if (ModUtils.hasRestrictedEffect((LivingEntity)player)) {
            event.setCanceled(true);
        }
    }
}

