/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.effects;

import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMobEffects;
import net.jaams.jaams_weaponry.particles.CustomSkullParticleData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_weaponry", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class VigorousRageHandler {
    private static final float BASE_UPGRADE_CHANCE = 0.2f;
    private static final int MAX_LEVEL = 10;
    private static final int MAX_DURATION_TICKS = 300;
    private static final int MIN_EXTRA_TICKS = 60;
    private static final int MAX_EXTRA_TICKS = 120;
    private static final float UPGRADE_CHANCE_DECAY = 0.8f;
    private static final float HEALTH_SCALING_FACTOR = 0.02f;
    private static final float MIN_HEALTH_THRESHOLD = 10.0f;
    private static final float MAX_HEALTH_THRESHOLD = 100.0f;

    private static boolean isVigorousRageEnabled() {
        return (Boolean)JaamsWeaponryCommonConfiguration.VIGOROUSRAGE.get();
    }

    @SubscribeEvent
    public static void onVigorousRage(LivingDeathEvent event) {
        LivingEntity attacker;
        block10: {
            block9: {
                if (!VigorousRageHandler.isVigorousRageEnabled()) {
                    return;
                }
                DamageSource source = event.getSource();
                Entity entity = source.m_7639_();
                if (!(entity instanceof LivingEntity)) break block9;
                attacker = (LivingEntity)entity;
                if (!source.m_269533_(DamageTypeTags.f_268524_)) break block10;
            }
            return;
        }
        if (!attacker.m_21023_((MobEffect)JaamsWeaponryModMobEffects.VIGOROUS_RAGE.get())) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (VigorousRageHandler.isValidTarget(target)) {
            Level level;
            MobEffectInstance effectInstance = attacker.m_21124_((MobEffect)JaamsWeaponryModMobEffects.VIGOROUS_RAGE.get());
            if (effectInstance == null) {
                return;
            }
            int currentLevel = effectInstance.m_19564_() + 1;
            RandomSource random = attacker.m_217043_();
            int currentDuration = effectInstance.m_19557_();
            float maxHealth = target.m_21233_();
            float healthFactor = Math.min(Math.max((maxHealth - 10.0f) * 0.02f, 0.0f), 1.0f);
            float upgradeChance = 0.2f * (float)Math.pow(0.8f, currentLevel - 1) * (0.5f + healthFactor);
            int extraTicks = currentDuration < 300 ? Math.round(60.0f + 60.0f * healthFactor) : 0;
            int newDuration = Math.min(currentDuration + extraTicks, 300);
            int newLevel = currentLevel;
            if (random.m_188501_() < upgradeChance) {
                newLevel = Math.min(currentLevel + 1, 10);
            }
            MobEffectInstance newEffect = new MobEffectInstance((MobEffect)JaamsWeaponryModMobEffects.VIGOROUS_RAGE.get(), newDuration, newLevel - 1);
            attacker.m_7292_(newEffect);
            if (!attacker.m_9236_().m_5776_() && (level = attacker.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                VigorousRageHandler.spawnSkullParticle(serverLevel, target);
            }
        }
    }

    private static void spawnSkullParticle(ServerLevel serverLevel, LivingEntity target) {
        float hitboxSize = Math.max(target.m_20205_(), target.m_20206_()) * 0.3f;
        float[] rgb = VigorousRageHandler.getRandomColor(serverLevel.m_213780_());
        CustomSkullParticleData particleData = new CustomSkullParticleData(rgb[0], rgb[1], rgb[2], hitboxSize);
        serverLevel.m_8767_((ParticleOptions)particleData, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() * 0.5f), target.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static float[] getRandomColor(RandomSource random) {
        float r = 0.8f + random.m_188501_() * 0.2f;
        float g = 0.3f + random.m_188501_() * 0.3f;
        float b = random.m_188501_() * 0.2f;
        return new float[]{r, g, b};
    }

    private static boolean isValidTarget(LivingEntity target) {
        return target instanceof Mob && !(target instanceof Animal) || target instanceof Player;
    }
}

