/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.effects;

import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMobEffects;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_weaponry", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WarriorGraceHandler {
    private static boolean isWarriorsGraceEnabled() {
        return (Boolean)JaamsWeaponryCommonConfiguration.WARRIORSGRACE.get();
    }

    @SubscribeEvent
    public static void onWarriorGrace(AttackEntityEvent event) {
        if (!WarriorGraceHandler.isWarriorsGraceEnabled()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_21023_((MobEffect)JaamsWeaponryModMobEffects.WARRIORS_GRACE.get()) && ModUtils.isItemWeapon(player.m_21205_())) {
            ModUtils.playSound((Entity)player, "jaams_weaponry:warrior_grace_hit");
        }
    }

    @SubscribeEvent
    public static void onWarriorGraceCriticalHit(CriticalHitEvent event) {
        if (!WarriorGraceHandler.isWarriorsGraceEnabled()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_21023_((MobEffect)JaamsWeaponryModMobEffects.WARRIORS_GRACE.get())) {
            MobEffectInstance effectInstance = player.m_21124_((MobEffect)JaamsWeaponryModMobEffects.WARRIORS_GRACE.get());
            int level = effectInstance.m_19564_() + 1;
            RandomSource random = player.m_217043_();
            float extraCritChance = 0.1f * (float)level;
            if (!event.isVanillaCritical() && random.m_188501_() < extraCritChance) {
                event.setDamageModifier(1.5f);
            }
            if (event.isVanillaCritical() || event.getDamageModifier() > event.getOldDamageModifier()) {
                float extraDamageMultiplier = 1.0f + 0.15f * (float)level;
                event.setDamageModifier(event.getDamageModifier() * extraDamageMultiplier);
            }
        }
    }

    @SubscribeEvent
    public static void onWarriorGraceLivingHurt(LivingHurtEvent event) {
        if (!WarriorGraceHandler.isWarriorsGraceEnabled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)JaamsWeaponryModMobEffects.WARRIORS_GRACE.get())) {
            MobEffectInstance effectInstance = entity.m_21124_((MobEffect)JaamsWeaponryModMobEffects.WARRIORS_GRACE.get());
            int level = effectInstance.m_19564_() + 1;
            float damageReduction = 1.0f - 0.05f * (float)level;
            float originalDamage = event.getAmount();
            float reducedDamage = originalDamage * damageReduction;
            event.setAmount(reducedDamage);
        }
    }
}

