/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.enchants;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jaams.jaams_weaponry.JaamsWeaponryMod;
import net.jaams.jaams_weaponry.enchantment.AftermathEnchantment;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEnchantments;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_weaponry", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AftermathHandler {
    private static final Map<Player, AftermathData> aftermathPlayers = new ConcurrentHashMap<Player, AftermathData>();
    private static final Map<LivingEntity, AftermathData> aftermathItems = new ConcurrentHashMap<LivingEntity, AftermathData>();
    private static final String AFTERMATH_NBT_KEY = "AftermathLevel";
    public static int I_FRAMES = 5;
    private static final int CLEANUP_DELAY = 5;

    @SubscribeEvent
    public static void onLivingEntityUseItemStop(LivingEntityUseItemEvent.Stop event) {
        LivingEntity entity = event.getEntity();
        ItemStack item = event.getItem();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int aftermathLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)JaamsWeaponryModEnchantments.AFTERMATH.get()), (ItemStack)item);
            if (aftermathLevel > 0) {
                aftermathPlayers.put(player, new AftermathData(aftermathLevel, player.m_9236_().m_46467_()));
            } else {
                aftermathPlayers.remove(player);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack itemStack = player.m_21120_(event.getHand());
        int aftermathLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)JaamsWeaponryModEnchantments.AFTERMATH.get()), (ItemStack)itemStack);
        if (aftermathLevel > 0) {
            aftermathPlayers.put(player, new AftermathData(aftermathLevel, player.m_9236_().m_46467_()));
        } else {
            aftermathPlayers.remove(player);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        AbstractArrow arrow;
        Entity entity = event.getEntity();
        if (entity instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity).m_19749_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                AftermathData data = aftermathPlayers.get(player);
                if (data != null && data.level > 0) {
                    arrow.getPersistentData().m_128405_(AFTERMATH_NBT_KEY, data.level);
                }
            } else {
                ItemStack heldItem = entity2.m_21205_();
                int aftermathLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)JaamsWeaponryModEnchantments.AFTERMATH.get()), (ItemStack)heldItem);
                if (aftermathLevel > 0) {
                    aftermathItems.put(entity2, new AftermathData(aftermathLevel, entity2.m_9236_().m_46467_()));
                    arrow.getPersistentData().m_128405_(AFTERMATH_NBT_KEY, aftermathLevel);
                } else {
                    aftermathItems.remove(entity2);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        long currentTick;
        Player player;
        AftermathData data;
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_() && (data = aftermathPlayers.get(player = event.player)) != null && (currentTick = player.m_9236_().m_46467_()) - data.lastUseTick >= 5L) {
            aftermathPlayers.remove(player);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        long currentTick;
        AftermathData data;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player) && !entity.m_9236_().m_5776_() && (data = aftermathItems.get(entity)) != null && (currentTick = entity.m_9236_().m_46467_()) - data.lastUseTick >= 5L) {
            aftermathItems.remove(entity);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            aftermathPlayers.remove(player);
        } else {
            aftermathItems.remove(entity);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        aftermathPlayers.remove(player);
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(entity instanceof Player)) {
                aftermathItems.remove(livingEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            if (event.getEntity() instanceof LivingEntity) {
                LivingEntity target = event.getEntity();
                int aftermathLevel = arrow.getPersistentData().m_128451_(AFTERMATH_NBT_KEY);
                if (aftermathLevel > 0) {
                    float arrowDamage = event.getAmount();
                    float baseExtraDamage = AftermathEnchantment.getExtraDamage(aftermathLevel);
                    float multiplier = 0.1f;
                    float extraDamage = baseExtraDamage + arrowDamage * multiplier * (float)aftermathLevel;
                    AbstractArrow sourceEntity = arrow.m_19749_() != null ? arrow.m_19749_() : arrow;
                    JaamsWeaponryMod.queueServerWork(20, () -> AftermathHandler.lambda$onLivingHurt$0(target, (Entity)sourceEntity, extraDamage));
                    arrow.getPersistentData().m_128473_(AFTERMATH_NBT_KEY);
                }
            }
        }
    }

    private static /* synthetic */ void lambda$onLivingHurt$0(LivingEntity target, Entity sourceEntity, float extraDamage) {
        if (!target.m_213877_() && target.m_6084_()) {
            target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f);
            target.m_6469_(new DamageSource((Holder)target.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268739_), sourceEntity), extraDamage);
            target.f_19802_ = I_FRAMES;
            if (!target.m_9236_().m_5776_()) {
                ServerLevel serverLevel = (ServerLevel)target.m_9236_();
                for (int i = 0; i < 10; ++i) {
                    double offsetX = target.m_217043_().m_188583_() * 0.3;
                    double offsetY = target.m_217043_().m_188583_() * 0.3 + 1.0;
                    double offsetZ = target.m_217043_().m_188583_() * 0.3;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20185_() + offsetX, target.m_20186_() + offsetY, target.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static class AftermathData {
        int level;
        long lastUseTick;

        AftermathData(int level, long lastUseTick) {
            this.level = level;
            this.lastUseTick = lastUseTick;
        }
    }
}

