/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.events;

import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="jaams_weaponry", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AdvancementsHandler {
    @SubscribeEvent
    public static void onItemAdvancementCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack stack = event.getCrafting();
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            if (itemId != null && itemId.m_135827_().equals("jaams_weaponry")) {
                AdvancementsHandler.grantAdvancement(player2, "weaponry_ad");
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerAdvancementTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AdvancementsHandler.checkWeaponryAdvancement(player2);
            AdvancementsHandler.checkHunterAdvancement(player2);
        }
    }

    private static void checkWeaponryAdvancement(ServerPlayer player) {
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation("jaams_weaponry", "weaponry_ad"));
        if (advancement != null && !player.m_8960_().m_135996_(advancement).m_8193_()) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                ResourceLocation itemId;
                if (stack.m_41619_() || (itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())) == null || !itemId.m_135827_().equals("jaams_weaponry")) continue;
                AdvancementsHandler.grantAdvancement(player, "weaponry_ad");
                break;
            }
        }
    }

    private static void checkHunterAdvancement(ServerPlayer player) {
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation("jaams_weaponry", "the_hunter"));
        if (advancement == null) {
            return;
        }
        if (player.m_8960_().m_135996_(advancement).m_8193_()) {
            return;
        }
        boolean hasCrossbow = false;
        boolean hasBow = false;
        boolean hasBoomerang = false;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            ResourceLocation itemId;
            if (stack.m_41619_() || (itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())) == null || !itemId.m_135827_().equals("jaams_weaponry")) continue;
            String itemPath = itemId.m_135815_();
            if (itemPath.equals("hunters_crossbow")) {
                hasCrossbow = true;
                continue;
            }
            if (itemPath.equals("hunters_bow")) {
                hasBow = true;
                continue;
            }
            if (!itemPath.equals("hunters_boomerang")) continue;
            hasBoomerang = true;
        }
        if (hasCrossbow && hasBow && hasBoomerang) {
            AdvancementsHandler.grantAdvancement(player, "the_hunter");
        }
    }

    public static boolean hasAdvancement(ServerPlayer player, String advancementId) {
        ResourceLocation id = new ResourceLocation("jaams_weaponry", advancementId);
        Advancement advancement = player.m_20194_().m_129889_().m_136041_(id);
        if (advancement != null) {
            return player.m_8960_().m_135996_(advancement).m_8193_();
        }
        return false;
    }

    public static void grantAdvancement(ServerPlayer player, String advancementId) {
        AdvancementProgress progress;
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation("jaams_weaponry", advancementId));
        if (advancement != null && !(progress = player.m_8960_().m_135996_(advancement)).m_8193_()) {
            for (String criteria : progress.m_8219_()) {
                player.m_8960_().m_135988_(advancement, criteria);
            }
        }
    }

    public static void incrementCounterAndCheckAdvancement(ServerPlayer player, String counterKey, String advancementId, int threshold) {
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation("jaams_weaponry", advancementId));
        if (advancement == null) {
            return;
        }
        if (player.m_8960_().m_135996_(advancement).m_8193_()) {
            return;
        }
        CompoundTag persistentData = player.getPersistentData();
        ResourceLocation key = new ResourceLocation("jaams_weaponry", counterKey);
        int counter = persistentData.m_128451_(key.toString());
        persistentData.m_128405_(key.toString(), ++counter);
        if (counter >= threshold) {
            AdvancementsHandler.grantAdvancement(player, advancementId);
            persistentData.m_128405_(key.toString(), 0);
        }
    }

    public static void incrementEntityCounterAndCheckAdvancement(ServerPlayer player, LivingEntity entity, String counterKey, String advancementId, int threshold) {
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation("jaams_weaponry", advancementId));
        if (advancement == null) {
            return;
        }
        if (player.m_8960_().m_135996_(advancement).m_8193_()) {
            return;
        }
        CompoundTag entityData = entity.getPersistentData();
        ResourceLocation key = new ResourceLocation("jaams_weaponry", counterKey);
        int counter = entityData.m_128451_(key.toString());
        entityData.m_128405_(key.toString(), ++counter);
        if (counter >= threshold) {
            AdvancementsHandler.grantAdvancement(player, advancementId);
            entityData.m_128405_(key.toString(), 0);
        }
    }
}

