/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.events;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AttackTrackerHandler {
    private static final Map<UUID, Boolean> RECENT_ATTACK_MAP = new HashMap<UUID, Boolean>();

    @SubscribeEvent
    public static void onRecentLivingAttack(LivingAttackEvent event) {
        LivingEntity attacker;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && !((attacker = (LivingEntity)entity) instanceof Player)) {
            RECENT_ATTACK_MAP.put(attacker.m_20148_(), true);
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && !((entity = (LivingEntity)entity2) instanceof Player)) {
            RECENT_ATTACK_MAP.remove(entity.m_20148_());
        }
    }

    public static void clearRecentAttacks() {
        RECENT_ATTACK_MAP.clear();
    }

    public static boolean getAndClearRecentAttack(UUID entityId) {
        boolean wasAttacked = RECENT_ATTACK_MAP.getOrDefault(entityId, false);
        if (wasAttacked) {
            RECENT_ATTACK_MAP.put(entityId, false);
        }
        return wasAttacked;
    }
}

