/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.math.NumberUtils;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class AttributeTooltipHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onAttributeTooltip(ItemTooltipEvent e) {
        ItemStack itemStack = e.getItemStack();
        ResourceLocation registryName = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
        if (ModList.get().isLoaded("epicfight")) {
            return;
        }
        List lines = e.getToolTip();
        HashMap attributesBySlot = new HashMap();
        String currentSlot = null;
        HashMap<String, Integer> attributeOrder = new HashMap<String, Integer>();
        attributeOrder.put("attribute.name.generic.attack_damage", 1);
        attributeOrder.put("attribute.name.generic.attack_speed", 2);
        attributeOrder.put("attribute.name.generic.attack_knockback", 3);
        attributeOrder.put("forge.entity_reach", 4);
        attributeOrder.put("attribute.name.generic.armor", 5);
        attributeOrder.put("attribute.name.generic.armor_toughness", 6);
        attributeOrder.put("attribute.name.generic.max_health", 7);
        attributeOrder.put("attribute.name.generic.knockback_resistance", 8);
        attributeOrder.put("attribute.name.generic.movement_speed", 9);
        attributeOrder.put("attribute.name.generic.flying_speed", 10);
        attributeOrder.put("attribute.name.generic.jump_strength", 11);
        attributeOrder.put("attribute.name.generic.luck", 12);
        attributeOrder.put("attribute.name.generic.follow_range", 13);
        HashSet<String> greenAttributes = new HashSet<String>(Arrays.asList("attribute.name.generic.attack_damage", "attribute.name.generic.attack_speed"));
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            Object[] args;
            Component line = (Component)it.next();
            ComponentContents content = line.m_214077_();
            if (content instanceof TranslatableContents) {
                double value;
                String attrName;
                TranslatableContents ttc = (TranslatableContents)content;
                if (ttc.m_237508_().startsWith("item.modifiers")) {
                    currentSlot = ttc.m_237508_().substring(ttc.m_237508_().lastIndexOf(46) + 1);
                    attributesBySlot.putIfAbsent(currentSlot, new HashMap());
                    continue;
                }
                if (ttc.m_237508_().startsWith("attribute.modifier.plus.0") && currentSlot != null) {
                    args = ttc.m_237523_();
                    if (args.length < 2 || !NumberUtils.isCreatable((String)args[0].toString())) continue;
                    attrName = ((TranslatableContents)((MutableComponent)args[1]).m_214077_()).m_237508_();
                    value = Double.parseDouble(args[0].toString());
                    ((Map)attributesBySlot.get(currentSlot)).merge(attrName, value, Double::sum);
                    it.remove();
                    continue;
                }
                if (ttc.m_237508_().startsWith("attribute.modifier.take.0") && currentSlot != null) {
                    args = ttc.m_237523_();
                    if (args.length < 2 || !NumberUtils.isCreatable((String)args[0].toString())) continue;
                    attrName = ((TranslatableContents)((MutableComponent)args[1]).m_214077_()).m_237508_();
                    value = -Double.parseDouble(args[0].toString());
                    ((Map)attributesBySlot.get(currentSlot)).merge(attrName, value, Double::sum);
                    it.remove();
                    continue;
                }
                if (ttc.m_237508_().startsWith("attribute.modifier.plus.1") && currentSlot != null) {
                    args = ttc.m_237523_();
                    if (args.length < 2 || !NumberUtils.isCreatable((String)args[0].toString())) continue;
                    attrName = ((TranslatableContents)((MutableComponent)args[1]).m_214077_()).m_237508_();
                    value = Double.parseDouble(args[0].toString());
                    ((Map)attributesBySlot.get(currentSlot)).merge(attrName + "_percent", value, Double::sum);
                    it.remove();
                    continue;
                }
                if (!ttc.m_237508_().startsWith("attribute.modifier.take.1") || currentSlot == null || (args = ttc.m_237523_()).length < 2 || !NumberUtils.isCreatable((String)args[0].toString())) continue;
                attrName = ((TranslatableContents)((MutableComponent)args[1]).m_214077_()).m_237508_();
                value = -Double.parseDouble(args[0].toString());
                ((Map)attributesBySlot.get(currentSlot)).merge(attrName + "_percent", value, Double::sum);
                it.remove();
                continue;
            }
            args = line.m_7360_().iterator();
            while (args.hasNext()) {
                Object[] args2;
                TranslatableContents ttc;
                Component part = (Component)args.next();
                ComponentContents componentContents = part.m_214077_();
                if (!(componentContents instanceof TranslatableContents) || !(ttc = (TranslatableContents)componentContents).m_237508_().startsWith("attribute.modifier.equals.0") || currentSlot == null || (args2 = ttc.m_237523_()).length < 2 || !NumberUtils.isCreatable((String)args2[0].toString())) continue;
                String attrName = ((TranslatableContents)((MutableComponent)args2[1]).m_214077_()).m_237508_();
                double value = Double.parseDouble(args2[0].toString());
                ((Map)attributesBySlot.get(currentSlot)).merge(attrName, value, Double::sum);
                it.remove();
            }
        }
        for (Map.Entry slotEntry : attributesBySlot.entrySet()) {
            String slot = (String)slotEntry.getKey();
            Map slotAttributesMap = (Map)slotEntry.getValue();
            ArrayList<Component> greenAttrs = new ArrayList<Component>();
            ArrayList<Component> blueAttrs = new ArrayList<Component>();
            ArrayList<Component> redAttrs = new ArrayList<Component>();
            int insertIndex = -1;
            for (int j = 0; j < lines.size(); ++j) {
                TranslatableContents ttc;
                Component line = (Component)lines.get(j);
                ComponentContents componentContents = line.m_214077_();
                if (!(componentContents instanceof TranslatableContents) || !(ttc = (TranslatableContents)componentContents).m_237508_().equals("item.modifiers." + slot)) continue;
                insertIndex = j;
                break;
            }
            if (insertIndex == -1) continue;
            for (Map.Entry attrEntry : slotAttributesMap.entrySet()) {
                MutableComponent newLine;
                String attrKey = (String)attrEntry.getKey();
                double value = (Double)attrEntry.getValue();
                boolean isPercent = attrKey.endsWith("_percent");
                String attrName = isPercent ? attrKey.substring(0, attrKey.length() - "_percent".length()) : attrKey;
                String formattedValue = AttributeTooltipHandler.formatNumber(Math.abs(value)) + (isPercent ? "%" : "");
                if (!isPercent && greenAttributes.contains(attrName)) {
                    newLine = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)formattedValue).m_130940_(ChatFormatting.DARK_GREEN)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)attrName).m_130940_(ChatFormatting.DARK_GREEN));
                    greenAttrs.add((Component)newLine);
                    continue;
                }
                if (value >= 0.0) {
                    String prefix = isPercent ? "+" : "+";
                    newLine = Component.m_237113_((String)(prefix + formattedValue)).m_130940_(ChatFormatting.BLUE).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)attrName).m_130940_(ChatFormatting.BLUE));
                    blueAttrs.add((Component)newLine);
                    continue;
                }
                newLine = Component.m_237113_((String)("-" + formattedValue)).m_130940_(ChatFormatting.RED).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)attrName).m_130940_(ChatFormatting.RED));
                redAttrs.add((Component)newLine);
            }
            List<Component> orderedGreenAttrs = AttributeTooltipHandler.sortAttributes(greenAttrs, attributeOrder);
            List<Component> orderedBlueAttrs = AttributeTooltipHandler.sortAttributes(blueAttrs, attributeOrder);
            List<Component> orderedRedAttrs = AttributeTooltipHandler.sortAttributes(redAttrs, attributeOrder);
            ArrayList<Component> orderedAttributes = new ArrayList<Component>();
            orderedAttributes.addAll(orderedGreenAttrs);
            orderedAttributes.addAll(orderedBlueAttrs);
            orderedAttributes.addAll(orderedRedAttrs);
            for (int k = 0; k < orderedAttributes.size(); ++k) {
                lines.add(insertIndex + 1 + k, (Component)orderedAttributes.get(k));
            }
        }
    }

    private static List<Component> sortAttributes(List<Component> attributes, Map<String, Integer> order) {
        HashMap<String, Integer> dynamicOrder = new HashMap<String, Integer>(order);
        int nextPriority = order.values().stream().max(Integer::compare).orElse(12) + 1;
        for (Component attr : attributes) {
            String attrName = AttributeTooltipHandler.extractAttributeNameFromComponent(attr);
            if (dynamicOrder.containsKey(attrName)) continue;
            dynamicOrder.put(attrName, nextPriority++);
        }
        attributes.sort((a, b) -> {
            boolean isPercentB;
            String attrNameA = AttributeTooltipHandler.extractAttributeNameFromComponent(a);
            String attrNameB = AttributeTooltipHandler.extractAttributeNameFromComponent(b);
            boolean isPercentA = a.toString().contains("%");
            if (isPercentA != (isPercentB = b.toString().contains("%"))) {
                return isPercentA ? 1 : -1;
            }
            Integer priorityA = dynamicOrder.getOrDefault(attrNameA, Integer.MAX_VALUE);
            Integer priorityB = dynamicOrder.getOrDefault(attrNameB, Integer.MAX_VALUE);
            return priorityA.compareTo(priorityB);
        });
        return attributes;
    }

    private static String extractAttributeNameFromComponent(Component component) {
        for (Component sibling : component.m_7360_()) {
            ComponentContents componentContents = sibling.m_214077_();
            if (!(componentContents instanceof TranslatableContents)) continue;
            TranslatableContents ttc = (TranslatableContents)componentContents;
            return ttc.m_237508_();
        }
        ComponentContents componentContents = component.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents ttc = (TranslatableContents)componentContents;
            return ttc.m_237508_();
        }
        return component.toString();
    }

    private static String formatNumber(double value) {
        if (value % 1.0 == 0.0) {
            return String.format("%.0f", value);
        }
        String formatted = String.format("%.2f", value);
        while (formatted.endsWith("0") && formatted.contains(".") && !formatted.endsWith(".0")) {
            formatted = formatted.substring(0, formatted.length() - 1);
        }
        if (formatted.endsWith(".")) {
            formatted = formatted.substring(0, formatted.length() - 1);
        }
        return formatted;
    }
}

