/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.events;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEnchantments;
import net.jaams.jaams_weaponry.item.BokkenItem;
import net.jaams.jaams_weaponry.item.RoyalSpearItem;
import net.jaams.jaams_weaponry.item.RoyalSwordItem;
import net.jaams.jaams_weaponry.item.RusticWhipItem;
import net.jaams.jaams_weaponry.item.WarPickItem;
import net.jaams.jaams_weaponry.weapons.BroadswordItem;
import net.jaams.jaams_weaponry.weapons.BroomBaseItem;
import net.jaams.jaams_weaponry.weapons.BusterSwordItem;
import net.jaams.jaams_weaponry.weapons.ButterflySwordItem;
import net.jaams.jaams_weaponry.weapons.DaggerReverseItem;
import net.jaams.jaams_weaponry.weapons.GreathammerItem;
import net.jaams.jaams_weaponry.weapons.GreatswordItem;
import net.jaams.jaams_weaponry.weapons.HammerItem;
import net.jaams.jaams_weaponry.weapons.HookSwordItem;
import net.jaams.jaams_weaponry.weapons.KatanaItem;
import net.jaams.jaams_weaponry.weapons.LongswordItem;
import net.jaams.jaams_weaponry.weapons.SawCleaverUnfoldedItem;
import net.jaams.jaams_weaponry.weapons.ScytheItem;
import net.jaams.jaams_weaponry.weapons.SpearItem;
import net.jaams.jaams_weaponry.weapons.ZweihanderItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AttributesHandler {
    private static final Map<String, UUID> ATTRIBUTE_UUID_MAP = new ConcurrentHashMap<String, UUID>();
    public static final String MOVEMENT_PENALTY_MAINHAND = "Movement Penalty_MAINHAND";
    public static final String MOVEMENT_PENALTY_OFFHAND = "Movement Penalty_OFFHAND";
    public static final String BROOM_ATTACK_DAMAGE = "Broom Attack Damage";
    public static final String OVERDRIVE_ATTACK_SPEED = "Overdrive Attack Speed";
    public static final String GREATSWORD_ATTACK_DAMAGE = "Greatsword Attack Damage";

    @SubscribeEvent
    public static void onItemAttributeModifier(ItemAttributeModifierEvent event) {
        CompoundTag nbt;
        int hits;
        int overdriveLevel;
        EquipmentSlot slot = event.getSlotType();
        Item item = event.getItemStack().m_41720_();
        ItemStack itemStack = event.getItemStack();
        ArrayList<AttributeEntry> attributeEntries = new ArrayList<AttributeEntry>();
        event.getModifiers().entries().forEach(entry -> attributeEntries.add(new AttributeEntry((Attribute)entry.getKey(), (AttributeModifier)entry.getValue())));
        if (item instanceof GreathammerItem) {
            if (slot == EquipmentSlot.MAINHAND) {
                attributeEntries.add(AttributesHandler.createEntry(MOVEMENT_PENALTY_MAINHAND, Attributes.f_22279_, -0.03, AttributeModifier.Operation.ADDITION));
            } else if (slot == EquipmentSlot.OFFHAND) {
                attributeEntries.add(AttributesHandler.createEntry(MOVEMENT_PENALTY_OFFHAND, Attributes.f_22279_, -0.03, AttributeModifier.Operation.ADDITION));
            }
        }
        if (item instanceof HammerItem) {
            if (slot == EquipmentSlot.MAINHAND) {
                attributeEntries.add(AttributesHandler.createEntry(MOVEMENT_PENALTY_MAINHAND, Attributes.f_22279_, -0.02, AttributeModifier.Operation.ADDITION));
            } else if (slot == EquipmentSlot.OFFHAND) {
                attributeEntries.add(AttributesHandler.createEntry(MOVEMENT_PENALTY_OFFHAND, Attributes.f_22279_, -0.02, AttributeModifier.Operation.ADDITION));
            }
        }
        if (item instanceof BusterSwordItem) {
            if (slot == EquipmentSlot.MAINHAND) {
                attributeEntries.add(AttributesHandler.createEntry(MOVEMENT_PENALTY_MAINHAND, Attributes.f_22279_, -0.01, AttributeModifier.Operation.ADDITION));
            } else if (slot == EquipmentSlot.OFFHAND) {
                attributeEntries.add(AttributesHandler.createEntry(MOVEMENT_PENALTY_OFFHAND, Attributes.f_22279_, -0.01, AttributeModifier.Operation.ADDITION));
            }
        }
        if (slot == EquipmentSlot.MAINHAND && (overdriveLevel = itemStack.getEnchantmentLevel((Enchantment)JaamsWeaponryModEnchantments.OVERDRIVE.get())) > 0 && AttributesHandler.hasBaseAttackSpeed(event)) {
            double speedBonus = 0.2 * (double)overdriveLevel;
            attributeEntries.add(AttributesHandler.createEntry(OVERDRIVE_ATTACK_SPEED, Attributes.f_22283_, speedBonus, AttributeModifier.Operation.ADDITION));
        }
        if (item instanceof GreatswordItem && slot == EquipmentSlot.MAINHAND && (hits = (nbt = itemStack.m_41784_()).m_128451_(GreatswordItem.getNbtHitsKey())) > 0) {
            double damageBonus = 2.5 * (double)hits;
            attributeEntries.add(AttributesHandler.createEntry(GREATSWORD_ATTACK_DAMAGE, Attributes.f_22281_, damageBonus, AttributeModifier.Operation.ADDITION));
        }
        if (slot == EquipmentSlot.MAINHAND && !ModList.get().isLoaded("bettercombat")) {
            if (item instanceof LongswordItem) {
                attributeEntries.add(AttributesHandler.createEntry("Longsword Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 1.8, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof ZweihanderItem) {
                attributeEntries.add(AttributesHandler.createEntry("Zweihander Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 1.8, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof BusterSwordItem) {
                attributeEntries.add(AttributesHandler.createEntry("Buster Sword Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 1.5, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof GreatswordItem) {
                attributeEntries.add(AttributesHandler.createEntry("Greatsword Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 1.0, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof KatanaItem) {
                attributeEntries.add(AttributesHandler.createEntry("Katana Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 1.0, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof BokkenItem) {
                attributeEntries.add(AttributesHandler.createEntry("Bokken Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 1.0, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof HookSwordItem) {
                attributeEntries.add(AttributesHandler.createEntry("HookSword Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 1.0, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof ScytheItem) {
                attributeEntries.add(AttributesHandler.createEntry("Scythe Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 1.0, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof BroadswordItem) {
                attributeEntries.add(AttributesHandler.createEntry("Broadsword Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 0.5, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof RoyalSwordItem) {
                attributeEntries.add(AttributesHandler.createEntry("Royal Sword Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 0.5, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof RusticWhipItem) {
                attributeEntries.add(AttributesHandler.createEntry("Tamers Whip Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 0.5, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof BroomBaseItem) {
                attributeEntries.add(AttributesHandler.createEntry("Broom Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 0.5, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof GreathammerItem) {
                attributeEntries.add(AttributesHandler.createEntry("Greathammer Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 0.5, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof ButterflySwordItem) {
                attributeEntries.add(AttributesHandler.createEntry("Butterfly Sword Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 0.5, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof SpearItem) {
                attributeEntries.add(AttributesHandler.createEntry("Spear Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 1.5, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof RoyalSpearItem) {
                attributeEntries.add(AttributesHandler.createEntry("Royal Spear Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 1.0, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof WarPickItem) {
                attributeEntries.add(AttributesHandler.createEntry("War Pick Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 0.5, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof SawCleaverUnfoldedItem) {
                attributeEntries.add(AttributesHandler.createEntry("Saw Cleaver Unfold Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), 1.5, AttributeModifier.Operation.ADDITION));
            } else if (item instanceof DaggerReverseItem) {
                attributeEntries.add(AttributesHandler.createEntry("Dagger Reverse Reach Modifier", (Attribute)ForgeMod.ENTITY_REACH.get(), -0.5, AttributeModifier.Operation.ADDITION));
            }
        }
        for (AttributeEntry entry2 : attributeEntries) {
            event.addModifier(entry2.attribute, entry2.modifier);
        }
    }

    private static boolean hasBaseAttackSpeed(ItemAttributeModifierEvent event) {
        Multimap originalModifiers = event.getOriginalModifiers();
        return originalModifiers.containsKey((Object)Attributes.f_22283_);
    }

    private static AttributeEntry createEntry(String name, Attribute attribute, double value, AttributeModifier.Operation operation) {
        UUID uuid = ATTRIBUTE_UUID_MAP.computeIfAbsent(name, key -> UUID.randomUUID());
        AttributeModifier modifier = new AttributeModifier(uuid, name, value, operation);
        return new AttributeEntry(attribute, modifier);
    }

    private static class AttributeEntry {
        final Attribute attribute;
        final AttributeModifier modifier;

        AttributeEntry(Attribute attribute, AttributeModifier modifier) {
            this.attribute = attribute;
            this.modifier = modifier;
        }
    }
}

