/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.events;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModSounds;
import net.jaams.jaams_weaponry.item.BokkenItem;
import net.jaams.jaams_weaponry.item.GauntletItem;
import net.jaams.jaams_weaponry.item.RoyalSwordItem;
import net.jaams.jaams_weaponry.item.TessenItem;
import net.jaams.jaams_weaponry.particles.CustomSweepParticleData;
import net.jaams.jaams_weaponry.properties.BlockingProperties;
import net.jaams.jaams_weaponry.util.ModTags;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.jaams.jaams_weaponry.weapons.BroadswordItem;
import net.jaams.jaams_weaponry.weapons.ZweihanderItem;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class BlockingHandler {
    public static float PARTICLE_SIZE_DEFAULT = 1.0f;
    public static float PARTICLE_OFFSET_Y = 0.6f;
    public static float PARTICLE_COLOR_R_DEFAULT = 1.0f;
    private static final List<ResourceLocation> BANNED_ITEMS = BlockingHandler.buildBannedItems();

    private static List<ResourceLocation> buildBannedItems() {
        ArrayList<ResourceLocation> bannedItems = new ArrayList<ResourceLocation>();
        bannedItems.add(new ResourceLocation("minecraft", "shield"));
        bannedItems.add(new ResourceLocation("jaams_archaeology", "broken_sword_fragment"));
        bannedItems.add(new ResourceLocation("jaams_archaeology", "sword_of_undying"));
        return List.copyOf(bannedItems);
    }

    private static BlockingProperties getBlockingConfig(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof BroadswordItem) {
            return new BlockingProperties.Builder().cooldownTicks(30).areaDamageMultiplier(0.7).knockbackForce(0.5).areaRange(1.5).blockDamageReduction(1.0).damagePerBlock(1).damageOnStop(2).particleSize(1.2f).particleDistance(1.5f).build();
        }
        if (item instanceof ZweihanderItem) {
            return new BlockingProperties.Builder().cooldownTicks(25).areaDamageMultiplier(0.35).knockbackForce(0.4).areaRange(2.0).blockDamageReduction(0.75).damagePerBlock(2).damageOnStop(2).particleSize(1.2f).particleDistance(2.0f).build();
        }
        if (item instanceof TessenItem) {
            return new BlockingProperties.Builder().cooldownTicks(10).areaDamageMultiplier(0.25).knockbackForce(0.3).areaRange(1.5).blockDamageReduction(0.2).damagePerBlock(3).damageOnStop(1).particleSize(0.55f).particleDistance(1.5f).build();
        }
        if (item instanceof RoyalSwordItem) {
            return new BlockingProperties.Builder().cooldownTicks(20).areaDamageMultiplier(0.35).knockbackForce(0.4).areaRange(2.0).blockDamageReduction(0.0).damagePerBlock(2).damageOnStop(2).particleSize(1.0f).particleDistance(2.0f).build();
        }
        if (item instanceof GauntletItem) {
            return new BlockingProperties.Builder().cooldownTicks(15).areaDamageMultiplier(0.0).knockbackForce(0.3).areaRange(1.0).blockDamageReduction(1.0).damagePerBlock(1).damageOnStop(0).blockSound(SoundEvents.f_12316_).particleSize(0.0f).particleDistance(0.0f).build();
        }
        if (item instanceof BokkenItem) {
            return new BlockingProperties.Builder().cooldownTicks(15).areaDamageMultiplier(0.3).knockbackForce(0.35).areaRange(1.8).blockDamageReduction(0.5).damagePerBlock(3).damageOnStop(1).blockSound((SoundEvent)JaamsWeaponryModSounds.BOKKEN_HIT.get()).particleSize(1.0f).particleDistance(1.8f).build();
        }
        if (itemStack.m_204117_(ModTags.SWORDS)) {
            return new BlockingProperties.Builder().build();
        }
        return null;
    }

    public static boolean isProlongedBlocking(ServerPlayer player) {
        CompoundTag persistentData = player.getPersistentData();
        ResourceLocation prolongedKey = new ResourceLocation("jaams_weaponry", "prolonged_blocking");
        return persistentData.m_128471_(prolongedKey.toString());
    }

    @SubscribeEvent
    public static void onPlayerBlockingTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CompoundTag persistentData = player2.getPersistentData();
            ResourceLocation blockingTicksKey = new ResourceLocation("jaams_weaponry", "blocking_ticks");
            ResourceLocation prolongedKey = new ResourceLocation("jaams_weaponry", "prolonged_blocking");
            if (player2.m_21254_()) {
                int blockingTicks = persistentData.m_128451_(blockingTicksKey.toString());
                if (blockingTicks < 20) {
                    persistentData.m_128405_(blockingTicksKey.toString(), ++blockingTicks);
                    if (blockingTicks >= 20) {
                        persistentData.m_128379_(prolongedKey.toString(), true);
                    }
                }
            } else {
                persistentData.m_128473_(blockingTicksKey.toString());
                persistentData.m_128473_(prolongedKey.toString());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockingLivingAttack(LivingAttackEvent event) {
        LivingEntity attacker;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack itemStack = player.m_21211_();
        if (BlockingHandler.isBannedItem(itemStack.m_41720_()) || !BlockingHandler.isBlockingWeapon(itemStack)) {
            return;
        }
        BlockingProperties config = BlockingHandler.getBlockingConfig(itemStack);
        if (config == null || !BlockingHandler.isBlocking(player)) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (source instanceof LivingEntity && BlockingHandler.canDisableBlocking((attacker = (LivingEntity)source).m_21205_(), itemStack, player, attacker)) {
            BlockingHandler.disableBlockingWeapon(player, itemStack);
            event.setCanceled(true);
            return;
        }
        if (source != null && BlockingHandler.isInBlockingArea(player, source)) {
            player.f_20916_ = 0;
            player.f_20917_ = 0;
            player.f_19802_ = 0;
            player.m_20095_();
            Level level = player.m_9236_();
            player.m_6210_();
            if (config.blockSound != null) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), config.blockSound, player.m_5720_(), 1.0f, 1.0f);
            }
            float originalDamage = event.getAmount();
            int damage = Math.max(0, Math.round(originalDamage * (float)config.damageOnStop));
            itemStack.m_41622_(damage, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
            if (event.getSource().m_7640_() instanceof AbstractArrow) {
                event.setCanceled(true);
                if (itemStack.m_41720_() instanceof GauntletItem) {
                    player.m_36335_().m_41524_(itemStack.m_41720_(), config.cooldownTicks + 10);
                    player.m_5810_();
                }
                return;
            }
            if (config.blockDamageReduction >= 1.0) {
                event.setCanceled(true);
                if (itemStack.m_41720_() instanceof GauntletItem) {
                    player.m_36335_().m_41524_(itemStack.m_41720_(), config.cooldownTicks);
                    player.m_5810_();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockingLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack itemStack = player.m_21211_();
        if (BlockingHandler.isBannedItem(itemStack.m_41720_()) || !BlockingHandler.isBlockingWeapon(itemStack)) {
            return;
        }
        BlockingProperties config = BlockingHandler.getBlockingConfig(itemStack);
        if (config == null || !BlockingHandler.isBlocking(player)) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (source != null && BlockingHandler.isInBlockingArea(player, source)) {
            float originalDamage = event.getAmount();
            if (config.blockDamageReduction < 1.0) {
                event.setAmount(originalDamage * (1.0f - (float)config.blockDamageReduction));
            }
        }
    }

    @SubscribeEvent
    public static void onBlockingStopUsing(LivingEntityUseItemEvent.Stop event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack itemStack = event.getItem();
        if (BlockingHandler.isBannedItem(itemStack.m_41720_()) || !BlockingHandler.isBlockingWeapon(itemStack)) {
            return;
        }
        if (itemStack.m_41780_() != UseAnim.BLOCK) {
            return;
        }
        BlockingProperties config = BlockingHandler.getBlockingConfig(itemStack);
        if (config == null) {
            return;
        }
        Level level = player.m_9236_();
        if (player.m_6047_()) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12318_, player.m_5720_(), 1.0f, 1.0f);
            return;
        }
        player.m_36335_().m_41524_(itemStack.m_41720_(), config.cooldownTicks);
        double weaponDamage = 1.0;
        Multimap modifiers = itemStack.m_41638_(EquipmentSlot.MAINHAND);
        if (modifiers.containsKey((Object)Attributes.f_22281_)) {
            weaponDamage = modifiers.get((Object)Attributes.f_22281_).stream().mapToDouble(AttributeModifier::m_22218_).sum();
        }
        float areaDamage = (float)(weaponDamage * config.areaDamageMultiplier);
        if (!(itemStack.m_41720_() instanceof GauntletItem)) {
            BlockingHandler.applyAreaDamage(player, areaDamage, config.knockbackForce, config.areaRange);
        }
        itemStack.m_41622_(config.damageOnStop, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        SoundEvent sound = itemStack.m_41720_() instanceof GauntletItem ? SoundEvents.f_12318_ : SoundEvents.f_12317_;
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, player.m_5720_(), 1.0f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player.m_5842_()) {
                BlockingHandler.spawnBubbleSweep(serverLevel, player, (float)config.areaRange, config.particleSize);
            }
            if (!(itemStack.m_41720_() instanceof GauntletItem)) {
                BlockingHandler.spawnParticleInFront(serverLevel, (LivingEntity)player, new CustomSweepParticleData(PARTICLE_COLOR_R_DEFAULT, 1.0f, 1.0f, config.particleSize), config.particleSize, config.particleDistance, itemStack);
            }
        }
    }

    private static void applyAreaDamage(Player player, float areaDamage, double knockbackForce, double areaRange) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AABB area = player.m_20191_().m_82400_(areaRange);
        DamageSource damageSource = player.m_269291_().m_269075_(player);
        ItemStack mainHandItem = player.m_21205_();
        int smiteLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44978_, (ItemStack)mainHandItem);
        int baneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44979_, (ItemStack)mainHandItem);
        int fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)mainHandItem);
        int knockbackLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)mainHandItem);
        List targets = serverLevel.m_6443_(LivingEntity.class, area, entity -> !ModUtils.isAlliedEntity(player, (Entity)entity) && entity.m_6084_() && entity != player).stream().filter(target -> BlockingHandler.isInBlockingArea(player, (Entity)target)).collect(Collectors.toList());
        int targetCount = targets.size();
        float adjustedAreaDamage = targetCount > 1 ? areaDamage / (float)Math.sqrt(targetCount) : areaDamage;
        for (LivingEntity target2 : targets) {
            float adjustedDamage = adjustedAreaDamage;
            if (smiteLevel > 0 && target2.m_6336_() == MobType.f_21641_) {
                adjustedDamage += (float)smiteLevel * 1.5f;
            }
            if (baneLevel > 0 && target2.m_6336_() == MobType.f_21642_) {
                adjustedDamage += (float)baneLevel * 1.5f;
                target2.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
            }
            target2.m_6469_(damageSource, adjustedDamage);
            if (fireAspectLevel > 0) {
                target2.m_20254_(fireAspectLevel * 4);
            }
            Vec3 knockbackDirection = new Vec3(target2.m_20185_() - player.m_20185_(), 0.0, target2.m_20189_() - player.m_20189_()).m_82541_().m_82490_(-1.0);
            double knockbackX = knockbackDirection.f_82479_ * (1.0 + (double)knockbackLevel * 0.5);
            double knockbackZ = knockbackDirection.f_82481_ * (1.0 + (double)knockbackLevel * 0.5);
            target2.m_147240_(knockbackForce, knockbackX, knockbackZ);
            if (player.m_7500_() || !(target2 instanceof Mob)) continue;
            Mob mobTarget = (Mob)target2;
            mobTarget.m_6710_((LivingEntity)player);
        }
        serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 0.9f);
    }

    private static void spawnParticleInFront(ServerLevel serverLevel, LivingEntity entity, ParticleOptions particleType, float particleSize, float particleDistance, ItemStack weapon) {
        float b;
        float g;
        float r;
        if (entity == null || serverLevel.m_5776_() || particleType == null || particleSize <= 0.0f) {
            return;
        }
        Vec3 lookVec = entity.m_20154_().m_82541_();
        double startX = entity.m_20185_();
        double startY = entity.m_20186_() + (double)(entity.m_20192_() * PARTICLE_OFFSET_Y);
        double startZ = entity.m_20189_();
        Vec3 startPos = new Vec3(startX, startY, startZ);
        Vec3 endPos = startPos.m_82549_(lookVec.m_82490_((double)particleDistance));
        ClipContext clipContext = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        BlockHitResult blockHit = serverLevel.m_45547_(clipContext);
        EntityHitResult entityHit = BlockingHandler.getEntityHitResult(serverLevel, entity, startPos, endPos);
        double adjustedDistance = Math.max(particleDistance - 0.1f, 0.1f);
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(blockHit.m_82450_()));
        }
        if (entityHit != null) {
            adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(entityHit.m_82450_()));
        }
        double particleX = startX + lookVec.f_82479_ * adjustedDistance;
        double particleY = startY + lookVec.f_82480_ * adjustedDistance;
        double particleZ = startZ + lookVec.f_82481_ * adjustedDistance;
        RandomSource random = serverLevel.f_46441_;
        int fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)weapon);
        if (fireAspectLevel > 0) {
            r = 0.8f + random.m_188501_() * 0.2f;
            g = 0.3f + random.m_188501_() * 0.3f;
            b = random.m_188501_() * 0.2f;
        } else {
            float grayValue;
            g = b = (grayValue = 0.4f + random.m_188501_() * 0.6f);
            r = b;
        }
        serverLevel.m_8767_((ParticleOptions)new CustomSweepParticleData(r, g, b, particleSize), particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static void spawnBubbleSweep(ServerLevel serverLevel, Player player, float particleDistance, float particleSize) {
        if (serverLevel.m_5776_()) {
            return;
        }
        Vec3 lookVec = player.m_20154_().m_82541_();
        double startX = player.m_20185_();
        double startY = player.m_20186_() + (double)player.m_20192_() * 0.8;
        double startZ = player.m_20189_();
        Vec3 startPos = new Vec3(startX, startY, startZ);
        int particleCount = 8;
        float arcAngle = (float)Math.toRadians(60.0);
        float angleStep = arcAngle / (float)(particleCount - 1);
        RandomSource random = serverLevel.f_46441_;
        float pitch = player.m_146909_();
        float clampedPitch = Math.max(-80.0f, Math.min(80.0f, pitch));
        Vec3 adjustedLookVec = Vec3.m_82498_((float)clampedPitch, (float)player.m_146908_()).m_82541_();
        for (int i = 0; i < particleCount; ++i) {
            float angle = -arcAngle / 2.0f + (float)i * angleStep;
            Vec3 rightVec = adjustedLookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
            Vec3 rotatedVec = adjustedLookVec.m_82490_(Math.cos(angle)).m_82549_(rightVec.m_82490_(Math.sin(angle))).m_82541_();
            Vec3 endPos = startPos.m_82549_(rotatedVec.m_82490_((double)particleDistance));
            ClipContext clipContext = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult blockHit = serverLevel.m_45547_(clipContext);
            EntityHitResult entityHit = BlockingHandler.getEntityHitResult(serverLevel, (LivingEntity)player, startPos, endPos);
            double adjustedDistance = Math.max(particleDistance - 0.1f, 0.1f);
            if (blockHit.m_6662_() != HitResult.Type.MISS) {
                adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(blockHit.m_82450_()));
            }
            if (entityHit != null) {
                adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(entityHit.m_82450_()));
            }
            double particleX = startX + rotatedVec.f_82479_ * adjustedDistance;
            double particleY = startY + rotatedVec.f_82480_ * adjustedDistance;
            double particleZ = startZ + rotatedVec.f_82481_ * adjustedDistance;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, particleX + (random.m_188500_() - 0.5) * 0.1, particleY + (random.m_188500_() - 0.5) * 0.1, particleZ + (random.m_188500_() - 0.5) * 0.1, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static EntityHitResult getEntityHitResult(ServerLevel level, LivingEntity shooter, Vec3 startPos, Vec3 endPos) {
        AABB aabb = new AABB(startPos, endPos).m_82400_(1.0);
        for (Entity entity : level.m_6249_((Entity)shooter, aabb, e -> e instanceof LivingEntity && e.m_6087_())) {
            AABB entityBox = entity.m_20191_().m_82400_(0.3);
            Optional hit = entityBox.m_82371_(startPos, endPos);
            if (!hit.isPresent()) continue;
            return new EntityHitResult(entity, (Vec3)hit.get());
        }
        return null;
    }

    private static boolean isInBlockingArea(Player player, Entity source) {
        Direction playerFront = player.m_6350_();
        Direction attackerFacing = Direction.m_122366_((double)(source.m_20185_() - player.m_20185_()), (double)0.0, (double)(source.m_20189_() - player.m_20189_()));
        Direction leftSide = playerFront.m_122428_();
        Direction rightSide = playerFront.m_122427_();
        return attackerFacing == playerFront || attackerFacing == leftSide || attackerFacing == rightSide;
    }

    public static boolean isBlocking(Player player) {
        return player.m_6117_() && player.m_21211_().m_41780_() == UseAnim.BLOCK;
    }

    public static boolean isBlockingWeapon(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof BroadswordItem || itemStack.m_41720_() instanceof ZweihanderItem || itemStack.m_41720_() instanceof TessenItem || itemStack.m_41720_() instanceof RoyalSwordItem || itemStack.m_41720_() instanceof GauntletItem || itemStack.m_41720_() instanceof BokkenItem || itemStack.m_204117_(ModTags.SWORDS);
    }

    private static boolean canDisableBlocking(ItemStack attackerStack, ItemStack blockingStack, Player player, LivingEntity attacker) {
        return !attackerStack.m_41619_() && attackerStack.m_41720_().canDisableShield(attackerStack, blockingStack, (LivingEntity)player, attacker);
    }

    private static void disableBlockingWeapon(Player player, ItemStack itemStack) {
        if (!player.m_36335_().m_41519_(itemStack.m_41720_())) {
            player.m_36335_().m_41524_(itemStack.m_41720_(), 100);
        }
        itemStack.m_41622_(3, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        player.m_5810_();
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12346_, player.m_5720_(), 1.0f, 1.0f);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12347_, player.m_5720_(), 1.0f, 1.0f);
    }

    public static boolean isBannedItem(Item item) {
        return BANNED_ITEMS.contains(ForgeRegistries.ITEMS.getKey((Object)item));
    }
}

