/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.events;

import java.util.UUID;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.item.GauntletItem;
import net.jaams.jaams_weaponry.item.TessenFoldedItem;
import net.jaams.jaams_weaponry.item.TessenItem;
import net.jaams.jaams_weaponry.util.ModTags;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DualWieldBuffHandler {
    private static final UUID RING_SPEED_UUID = UUID.fromString("4e5fc601-cf54-499c-83f5-a24561cedfce");
    private static final UUID CLAW_DAMAGE_UUID = UUID.fromString("6a8b2d7e-9f12-4b3a-8c9d-b7f8e2c1d5a0");
    private static final UUID BROADSWORD_KNOCKBACK_UUID = UUID.fromString("15bbdb42-c789-4561-809c-c11d0d48d95b");
    private static final UUID BROADSWORD_TOUGHNESS_UUID = UUID.fromString("a7c9e3f2-5d6b-4a1c-9f3d-8e6a2b4c7d9e");
    private static final UUID GAUNTLET_DAMAGE_UUID = UUID.fromString("771dd983-93c2-46fa-bba9-493e6aabcfc3");
    private static final UUID GAUNTLET_SPEED_UUID = UUID.fromString("004bfcb4-b8a5-4249-ba7e-744895fad5ab");
    private static final UUID KNUCKLES_SPEED_UUID = UUID.fromString("b9e4f7a3-2c1d-4e9b-8a2c-5f6d3e8b7c4a");
    private static final UUID KAMA_SPEED_UUID = UUID.fromString("c8e4a9b2-3d2e-4f8c-9b3d-6f7e4c9a8d5b");
    private static final UUID HAMMER_KNOCKBACK_UUID = UUID.fromString("d2e3f4a5-6b7c-8d9e-0f1a-2b3c4d5e6f78");
    private static final UUID TESSEN_SPEED_UUID = UUID.fromString("e1f2a3b4-c5d6-7e8f-9a0b-1c2d3e4f5a6b");
    private static final UUID TESSEN_FOLDED_DAMAGE_UUID = UUID.fromString("f2a3b4c5-d6e7-4f89-0123-456789abcdef");

    @SubscribeEvent
    public static void onDualWeaponBlockingDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        ItemStack mainHand = entity.m_21205_();
        ItemStack offHand = entity.m_21206_();
        float originalDamage = event.getAmount();
        Entity source = event.getSource().m_7639_();
        if (source != null && ModUtils.isInFrontArea(entity, source)) {
            if (((Boolean)JaamsWeaponryCommonConfiguration.HAMMERBONUS.get()).booleanValue() && mainHand.m_204117_(ModTags.HAMMERS) && offHand.m_204117_(ModTags.HAMMERS)) {
                float reducedDamage = originalDamage * 0.7f;
                event.setAmount(reducedDamage);
            } else if (((Boolean)JaamsWeaponryCommonConfiguration.BROADSWORDBONUS.get()).booleanValue() && mainHand.m_204117_(ModTags.BROADSWORDS) && offHand.m_204117_(ModTags.BROADSWORDS)) {
                float reducedDamage = originalDamage * 0.8f;
                event.setAmount(reducedDamage);
            }
        }
    }

    @SubscribeEvent
    public static void onDualBonusLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        ItemStack mainHand = entity.m_21205_();
        ItemStack offHand = entity.m_21206_();
        AttributeInstance attackSpeed = entity.m_21051_(Attributes.f_22283_);
        AttributeInstance attackDamage = entity.m_21051_(Attributes.f_22281_);
        AttributeInstance knockbackResistance = entity.m_21051_(Attributes.f_22278_);
        AttributeInstance armorToughness = entity.m_21051_(Attributes.f_22285_);
        if (((Boolean)JaamsWeaponryCommonConfiguration.RINGBONUS.get()).booleanValue() && mainHand.m_204117_(ModTags.RINGS) && offHand.m_204117_(ModTags.RINGS)) {
            DualWieldBuffHandler.applyModifierIfAbsent(attackSpeed, RING_SPEED_UUID, "ring_speed", 0.5, AttributeModifier.Operation.ADDITION);
        } else {
            DualWieldBuffHandler.removeModifier(attackSpeed, RING_SPEED_UUID);
        }
        if (((Boolean)JaamsWeaponryCommonConfiguration.CLAWBONUS.get()).booleanValue() && mainHand.m_204117_(ModTags.CLAWS) && offHand.m_204117_(ModTags.CLAWS)) {
            DualWieldBuffHandler.applyModifierIfAbsent(attackDamage, CLAW_DAMAGE_UUID, "claw_damage", 2.0, AttributeModifier.Operation.ADDITION);
        } else {
            DualWieldBuffHandler.removeModifier(attackDamage, CLAW_DAMAGE_UUID);
        }
        if (((Boolean)JaamsWeaponryCommonConfiguration.HAMMERBONUS.get()).booleanValue() && mainHand.m_204117_(ModTags.HAMMERS) && offHand.m_204117_(ModTags.HAMMERS)) {
            DualWieldBuffHandler.applyModifierIfAbsent(knockbackResistance, HAMMER_KNOCKBACK_UUID, "hammer_knockback", 0.4, AttributeModifier.Operation.ADDITION);
        } else {
            DualWieldBuffHandler.removeModifier(knockbackResistance, HAMMER_KNOCKBACK_UUID);
        }
        if (((Boolean)JaamsWeaponryCommonConfiguration.GAUNTLETBONUS.get()).booleanValue() && mainHand.m_41720_() instanceof GauntletItem && offHand.m_41720_() instanceof GauntletItem) {
            DualWieldBuffHandler.applyModifierIfAbsent(attackDamage, GAUNTLET_DAMAGE_UUID, "gauntlet_damage", 2.0, AttributeModifier.Operation.ADDITION);
            DualWieldBuffHandler.applyModifierIfAbsent(attackSpeed, GAUNTLET_SPEED_UUID, "gauntlet_speed", 0.5, AttributeModifier.Operation.ADDITION);
        } else {
            DualWieldBuffHandler.removeModifier(attackDamage, GAUNTLET_DAMAGE_UUID);
            DualWieldBuffHandler.removeModifier(attackSpeed, GAUNTLET_SPEED_UUID);
        }
        if (((Boolean)JaamsWeaponryCommonConfiguration.KNUCKLESBONUS.get()).booleanValue() && mainHand.m_204117_(ModTags.KNUCKLES) && offHand.m_204117_(ModTags.KNUCKLES)) {
            DualWieldBuffHandler.applyModifierIfAbsent(attackSpeed, KNUCKLES_SPEED_UUID, "knuckle_speed", 0.3, AttributeModifier.Operation.ADDITION);
        } else {
            DualWieldBuffHandler.removeModifier(attackSpeed, KNUCKLES_SPEED_UUID);
        }
        if (((Boolean)JaamsWeaponryCommonConfiguration.KAMABONUS.get()).booleanValue() && mainHand.m_204117_(ModTags.KAMAS) && offHand.m_204117_(ModTags.KAMAS)) {
            DualWieldBuffHandler.applyModifierIfAbsent(attackSpeed, KAMA_SPEED_UUID, "kama_speed", 0.3, AttributeModifier.Operation.ADDITION);
        } else {
            DualWieldBuffHandler.removeModifier(attackSpeed, KAMA_SPEED_UUID);
        }
        if (((Boolean)JaamsWeaponryCommonConfiguration.TESSENBONUS.get()).booleanValue()) {
            boolean mainIsTessen = mainHand.m_41720_() instanceof TessenItem;
            boolean mainIsFolded = mainHand.m_41720_() instanceof TessenFoldedItem;
            boolean offIsTessen = offHand.m_41720_() instanceof TessenItem;
            boolean offIsFolded = offHand.m_41720_() instanceof TessenFoldedItem;
            if (mainIsTessen && offIsTessen) {
                DualWieldBuffHandler.applyModifierIfAbsent(attackSpeed, TESSEN_SPEED_UUID, "tessen_speed", 0.5, AttributeModifier.Operation.ADDITION);
            } else {
                DualWieldBuffHandler.removeModifier(attackSpeed, TESSEN_SPEED_UUID);
            }
            if (mainIsFolded && offIsFolded) {
                DualWieldBuffHandler.applyModifierIfAbsent(attackDamage, TESSEN_FOLDED_DAMAGE_UUID, "tessen_folded_damage", 2.0, AttributeModifier.Operation.ADDITION);
            } else {
                DualWieldBuffHandler.removeModifier(attackDamage, TESSEN_FOLDED_DAMAGE_UUID);
            }
        }
    }

    private static void applyModifierIfAbsent(AttributeInstance attribute, UUID uuid, String name, double amount, AttributeModifier.Operation operation) {
        AttributeModifier modifier;
        if (attribute != null && !attribute.m_22109_(modifier = new AttributeModifier(uuid, name, amount, operation))) {
            attribute.m_22118_(modifier);
        }
    }

    private static void removeModifier(AttributeInstance attribute, UUID uuid) {
        if (attribute != null) {
            attribute.m_22120_(uuid);
        }
    }
}

