/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.events;

import java.util.UUID;
import net.jaams.jaams_weaponry.util.ModTags;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DualWieldDebuffHandler {
    private static final UUID HEAVYHANDED_MOVEMENT_SPEED_UUID = UUID.fromString("f0a1b2c3-d4e5-4f6a-9b0c-1d2e3f4a5b6c");
    private static final UUID HEAVYHANDED_ATTACK_DAMAGE_UUID = UUID.fromString("a1b2c3d4-e5f6-4a7b-8c0d-2e3f4a5b6c7d");
    private static final UUID HEAVYHANDED_ATTACK_SPEED_UUID = UUID.fromString("b2c3d4e5-f6a7-4b8c-9d0e-3f4a5b6c7d8e");
    private static final UUID HEAVYHANDED_INVALID_OFFHAND_ATTACK_DAMAGE_UUID = UUID.fromString("d0e1f2a3-b4c5-4d6e-9f7a-1b2c3d4e5f6a");
    private static final UUID HEAVYHANDED_INVALID_OFFHAND_ATTACK_SPEED_UUID = UUID.fromString("e1f2a3b4-c5d6-4e7f-a0b8-2c3d4e5f6a7b");
    private static final UUID HEAVYHANDED_INVALID_MAINHAND_ATTACK_DAMAGE_UUID = UUID.fromString("a3b4c5d6-e7f8-4a9b-8c0d-4e5f6a7b8c9d");
    private static final UUID HEAVYHANDED_INVALID_MAINHAND_ATTACK_SPEED_UUID = UUID.fromString("b4c5d6e7-f8a9-4b0c-9d1e-5f6a7b8c9d0e");
    private static final UUID HEAVYHANDED_INVALID_OFFHAND_MOVEMENT_SPEED_UUID = UUID.fromString("c5d6e7f8-a9b0-4c1d-9e2f-6a7b8c9d0e1f");
    private static final UUID HEAVYHANDED_INVALID_MAINHAND_MOVEMENT_SPEED_UUID = UUID.fromString("d6e7f8a9-b0c1-4d2e-9f3a-7b8c9d0e1f2a");

    @SubscribeEvent
    public static void onDualHandDebuffLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        ItemStack mainHand = entity.m_21205_();
        ItemStack offHand = entity.m_21206_();
        AttributeInstance movementSpeed = entity.m_21051_(Attributes.f_22279_);
        AttributeInstance attackDamage = entity.m_21051_(Attributes.f_22281_);
        AttributeInstance attackSpeed = entity.m_21051_(Attributes.f_22283_);
        if (mainHand.m_204117_(ModTags.HEAVYHANDED) && offHand.m_204117_(ModTags.HEAVYHANDED)) {
            DualWieldDebuffHandler.applyModifierIfAbsent(attackDamage, HEAVYHANDED_ATTACK_DAMAGE_UUID, "heavyhanded_attack_damage_debuff", -0.7, AttributeModifier.Operation.MULTIPLY_TOTAL);
            DualWieldDebuffHandler.applyModifierIfAbsent(attackSpeed, HEAVYHANDED_ATTACK_SPEED_UUID, "heavyhanded_attack_speed_debuff", -0.7, AttributeModifier.Operation.MULTIPLY_TOTAL);
            DualWieldDebuffHandler.applyModifierIfAbsent(movementSpeed, HEAVYHANDED_MOVEMENT_SPEED_UUID, "heavyhanded_movement_debuff", -0.2, AttributeModifier.Operation.MULTIPLY_TOTAL);
        } else {
            DualWieldDebuffHandler.removeModifier(attackDamage, HEAVYHANDED_ATTACK_DAMAGE_UUID);
            DualWieldDebuffHandler.removeModifier(attackSpeed, HEAVYHANDED_ATTACK_SPEED_UUID);
            DualWieldDebuffHandler.removeModifier(movementSpeed, HEAVYHANDED_MOVEMENT_SPEED_UUID);
        }
        if (mainHand.m_204117_(ModTags.HEAVYHANDED) && ModUtils.isItemWeapon(offHand) && !offHand.m_204117_(ModTags.HEAVYHANDED) && !offHand.m_204117_(ModTags.GREATHAMMERS) && !offHand.m_204117_(ModTags.BUSTERS) && !offHand.m_204117_(ModTags.HAMMERS)) {
            DualWieldDebuffHandler.applyModifierIfAbsent(attackDamage, HEAVYHANDED_INVALID_OFFHAND_ATTACK_DAMAGE_UUID, "heavyhanded_invalid_offhand_attack_damage_debuff", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
            DualWieldDebuffHandler.applyModifierIfAbsent(attackSpeed, HEAVYHANDED_INVALID_OFFHAND_ATTACK_SPEED_UUID, "heavyhanded_invalid_offhand_attack_speed_debuff", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
            DualWieldDebuffHandler.applyModifierIfAbsent(movementSpeed, HEAVYHANDED_INVALID_OFFHAND_MOVEMENT_SPEED_UUID, "heavyhanded_invalid_offhand_movement_debuff", -0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
        } else {
            DualWieldDebuffHandler.removeModifier(attackDamage, HEAVYHANDED_INVALID_OFFHAND_ATTACK_DAMAGE_UUID);
            DualWieldDebuffHandler.removeModifier(attackSpeed, HEAVYHANDED_INVALID_OFFHAND_ATTACK_SPEED_UUID);
            DualWieldDebuffHandler.removeModifier(movementSpeed, HEAVYHANDED_INVALID_OFFHAND_MOVEMENT_SPEED_UUID);
        }
        if (offHand.m_204117_(ModTags.HEAVYHANDED) && ModUtils.isItemWeapon(mainHand) && !mainHand.m_204117_(ModTags.HEAVYHANDED) && !mainHand.m_204117_(ModTags.GREATHAMMERS) && !mainHand.m_204117_(ModTags.BUSTERS) && !mainHand.m_204117_(ModTags.HAMMERS)) {
            DualWieldDebuffHandler.applyModifierIfAbsent(attackDamage, HEAVYHANDED_INVALID_MAINHAND_ATTACK_DAMAGE_UUID, "heavyhanded_invalid_mainhand_attack_damage_debuff", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
            DualWieldDebuffHandler.applyModifierIfAbsent(attackSpeed, HEAVYHANDED_INVALID_MAINHAND_ATTACK_SPEED_UUID, "heavyhanded_invalid_mainhand_attack_speed_debuff", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
            DualWieldDebuffHandler.applyModifierIfAbsent(movementSpeed, HEAVYHANDED_INVALID_MAINHAND_MOVEMENT_SPEED_UUID, "heavyhanded_invalid_mainhand_movement_debuff", -0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
        } else {
            DualWieldDebuffHandler.removeModifier(attackDamage, HEAVYHANDED_INVALID_MAINHAND_ATTACK_DAMAGE_UUID);
            DualWieldDebuffHandler.removeModifier(attackSpeed, HEAVYHANDED_INVALID_MAINHAND_ATTACK_SPEED_UUID);
            DualWieldDebuffHandler.removeModifier(movementSpeed, HEAVYHANDED_INVALID_MAINHAND_MOVEMENT_SPEED_UUID);
        }
    }

    private static void applyModifierIfAbsent(AttributeInstance attribute, UUID uuid, String name, double amount, AttributeModifier.Operation operation) {
        if (attribute != null) {
            AttributeModifier modifier = new AttributeModifier(uuid, name, amount, operation);
            if (attribute.m_22111_(uuid) == null) {
                attribute.m_22118_(modifier);
            }
        }
    }

    private static void removeModifier(AttributeInstance attribute, UUID uuid) {
        if (attribute != null) {
            attribute.m_22120_(uuid);
        }
    }
}

