/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.handler.events;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import net.jaams.jaams_weaponry.JaamsWeaponryMod;
import net.jaams.jaams_weaponry.capability.dualwield.DualWieldProvider;
import net.jaams.jaams_weaponry.capability.dualwield.IDualWield;
import net.jaams.jaams_weaponry.packets.DualWieldPacket;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="jaams_weaponry", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DualWieldHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDualWieldAttackEntity(AttackEntityEvent event) {
        boolean newOffhandTurn;
        ItemStack offhandItem;
        Player player = event.getEntity();
        Entity target = event.getTarget();
        if (player == null || target == null || player.m_9236_().m_5776_() || !target.m_6097_() || target.m_7313_((Entity)player)) {
            return;
        }
        if (ModList.get().isLoaded("bettercombat") || ModUtils.isEntityInBattleMode((Entity)player)) {
            return;
        }
        ItemStack mainhandItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!DualWieldHandler.areSameWeaponType(mainhandItem, offhandItem = player.m_21120_(InteractionHand.OFF_HAND))) {
            event.setCanceled(false);
            return;
        }
        LazyOptional stateCap = player.getCapability(DualWieldProvider.DUAL_WIELD);
        IDualWield state = (IDualWield)stateCap.orElseThrow(() -> new IllegalStateException("DualWield capability not found for player: " + player.m_7755_().getString()));
        boolean bl = newOffhandTurn = !state.isOffhandTurn();
        if (state.isOffhandTurn()) {
            event.setCanceled(true);
            DualWieldHandler.processOffhandAttack(player, target, offhandItem);
        } else {
            event.setCanceled(false);
        }
        state.setOffhandTurn(newOffhandTurn);
        if (!player.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new DualWieldPacket(player.m_19879_(), newOffhandTurn));
        }
    }

    @SubscribeEvent
    public static void onDualWieldLivingTick(LivingEvent.LivingTickEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_9236_().m_5776_()) {
            return;
        }
        if (ModList.get().isLoaded("bettercombat") || ModUtils.isEntityInBattleMode((Entity)player)) {
            return;
        }
        ItemStack mainhandItem = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offhandItem = player.m_21120_(InteractionHand.OFF_HAND);
        boolean canDualWield = DualWieldHandler.areSameWeaponType(mainhandItem, offhandItem);
        LazyOptional stateCap = player.getCapability(DualWieldProvider.DUAL_WIELD);
        if (stateCap.isPresent()) {
            stateCap.ifPresent(state -> {
                if (!canDualWield) {
                    state.setOffhandTurn(false);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new DualWieldPacket(player.m_19879_(), false));
                    }
                }
            });
        }
    }

    public static boolean areSameWeaponType(ItemStack mainhand, ItemStack offhand) {
        if (mainhand.m_41619_() || offhand.m_41619_()) {
            return false;
        }
        ResourceLocation mainId = mainhand.m_41720_().m_204114_().m_205785_().m_135782_();
        ResourceLocation offId = offhand.m_41720_().m_204114_().m_205785_().m_135782_();
        if (mainId == null || offId == null || !mainId.m_135827_().contains("jaams") || !offId.m_135827_().contains("jaams")) {
            return false;
        }
        String[] weaponTypes = new String[]{"claw", "knuckle", "ring", "gauntlet", "kama", "katana", "broadsword", "butterfly_sword", "hammer", "dagger", "nunchaku", "sickle", "pistol"};
        HashSet<String> mainWeaponTypes = new HashSet<String>();
        HashSet<String> offWeaponTypes = new HashSet<String>();
        for (String weaponType : weaponTypes) {
            if (weaponType.equals("hammer")) {
                if (mainId.m_135815_().contains("hammer") && !mainId.m_135815_().contains("greathammer")) {
                    mainWeaponTypes.add(weaponType);
                }
                if (!offId.m_135815_().contains("hammer") || offId.m_135815_().contains("greathammer")) continue;
                offWeaponTypes.add(weaponType);
                continue;
            }
            if (mainId.m_135815_().contains(weaponType)) {
                mainWeaponTypes.add(weaponType);
            }
            if (!offId.m_135815_().contains(weaponType)) continue;
            offWeaponTypes.add(weaponType);
        }
        for (String weaponType : mainWeaponTypes) {
            if (!offWeaponTypes.contains(weaponType)) continue;
            return true;
        }
        return mainWeaponTypes.contains("claw") && offWeaponTypes.contains("knuckle") || mainWeaponTypes.contains("knuckle") && offWeaponTypes.contains("claw");
    }

    private static void processOffhandAttack(Player player, Entity target, ItemStack offhandItem) {
        float f;
        float baseDamage = (float)player.m_21133_(Attributes.f_22281_);
        float itemDamage = (float)DualWieldHandler.getAttributeFromItem(offhandItem, Attributes.f_22281_, 0.0f);
        float mainhandDamage = (float)DualWieldHandler.getAttributeFromItem(player.m_21120_(InteractionHand.MAIN_HAND), Attributes.f_22281_, 0.0f);
        float damage = baseDamage + itemDamage - mainhandDamage;
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            f = EnchantmentHelper.m_44833_((ItemStack)offhandItem, (MobType)livingTarget.m_6336_());
        } else {
            f = EnchantmentHelper.m_44833_((ItemStack)offhandItem, (MobType)MobType.f_21640_);
        }
        float enchantmentBonus = f;
        float attackStrength = player.m_36403_(0.5f);
        damage *= 0.2f + attackStrength * attackStrength * 0.8f;
        enchantmentBonus *= attackStrength;
        if (damage <= 0.0f && enchantmentBonus <= 0.0f) {
            return;
        }
        boolean isFullStrength = attackStrength > 0.9f;
        boolean sprintKnockback = false;
        float knockback = (float)DualWieldHandler.getAttributeFromItem(offhandItem, Attributes.f_22282_, 0.0f);
        knockback += (float)offhandItem.getEnchantmentLevel(Enchantments.f_44980_);
        if (player.m_20142_() && isFullStrength) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12314_, player.m_5720_(), 1.0f, 1.0f);
            knockback += 1.0f;
            sprintKnockback = true;
        }
        boolean isCritical = isFullStrength && player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_() && target instanceof LivingEntity && !player.m_20142_();
        CriticalHitEvent critEvent = ForgeHooks.getCriticalHit((Player)player, (Entity)target, (boolean)isCritical, (float)(isCritical ? 1.5f : 1.0f));
        boolean isCrit = critEvent != null && critEvent.isVanillaCritical();
        damage += enchantmentBonus;
        if (isCrit) {
            damage *= critEvent.getDamageModifier();
        }
        boolean isSweep = false;
        double walkDistDelta = player.f_19787_ - player.f_19867_;
        if (isFullStrength && !isCrit && !sprintKnockback && player.m_20096_() && walkDistDelta < (double)player.m_6113_()) {
            isSweep = offhandItem.canPerformAction(ToolActions.SWORD_SWEEP);
        }
        float targetHealth = 0.0f;
        boolean fireApplied = false;
        int fireAspectLevel = offhandItem.getEnchantmentLevel(Enchantments.f_44981_);
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            targetHealth = livingTarget.m_21223_();
            if (fireAspectLevel > 0 && !target.m_6060_()) {
                fireApplied = true;
                target.m_20254_(1);
            }
        }
        Vec3 targetMotion = target.m_20184_();
        boolean attackSuccessful = target.m_6469_(player.m_269291_().m_269075_(player), damage);
        if (attackSuccessful) {
            Level sweepDamage2;
            ServerLevel serverLevel;
            Level level;
            LivingEntity livingTarget;
            if (knockback > 0.0f) {
                if (target instanceof LivingEntity) {
                    livingTarget = (LivingEntity)target;
                    livingTarget.m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                } else {
                    target.m_5997_((double)(-Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))) * knockback * 0.5f), 0.1, (double)(Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180))) * knockback * 0.5f));
                }
                player.m_20256_(player.m_20184_().m_82542_(0.6, 1.0, 0.6));
                player.m_6858_(false);
            }
            if (isSweep && (level = player.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                float sweepDamage2 = 1.0f + (float)offhandItem.getEnchantmentLevel(Enchantments.f_44983_) / (float)(offhandItem.getEnchantmentLevel(Enchantments.f_44983_) + 1) * damage;
                for (LivingEntity nearbyEntity : player.m_9236_().m_45976_(LivingEntity.class, offhandItem.getSweepHitBox(player, target))) {
                    ArmorStand armorStand;
                    if (nearbyEntity == player || nearbyEntity == target || player.m_7307_((Entity)nearbyEntity) || nearbyEntity instanceof ArmorStand && (armorStand = (ArmorStand)nearbyEntity).m_31677_() || !(player.m_20280_((Entity)nearbyEntity) < Mth.m_144952_((double)player.getEntityReach()))) continue;
                    nearbyEntity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                    nearbyEntity.m_6469_(player.m_269291_().m_269075_(player), sweepDamage2);
                }
                serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
                double xOffset = -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                double zOffset = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, player.m_20185_() + xOffset, player.m_20186_() + (double)player.m_20206_() * 0.5, player.m_20189_() + zOffset, 0, xOffset, 0.0, zOffset, 0.0);
            }
            if (target instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)target;
                if (target.f_19864_) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(target));
                    target.f_19864_ = false;
                    target.m_20256_(targetMotion);
                }
            }
            if (isCrit && (sweepDamage2 = player.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)sweepDamage2;
                serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12313_, player.m_5720_(), 1.0f, 1.0f);
                player.m_5704_(target);
            } else if (!isSweep) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), isFullStrength ? SoundEvents.f_12316_ : SoundEvents.f_12318_, player.m_5720_(), 1.0f, 1.0f);
            }
            if (enchantmentBonus > 0.0f) {
                player.m_5700_(target);
            }
            player.m_21335_(target);
            if (target instanceof LivingEntity) {
                livingTarget = (LivingEntity)target;
                EnchantmentHelper.m_44823_((LivingEntity)livingTarget, (Entity)player);
            }
            if (target instanceof LivingEntity) {
                livingTarget = (LivingEntity)target;
                offhandItem.m_41640_(livingTarget, player);
                EnchantmentHelper.m_44896_((LivingEntity)player, (Entity)target);
            }
            if (target instanceof LivingEntity) {
                livingTarget = (LivingEntity)target;
                ItemStack copy = offhandItem.m_41777_();
                if (offhandItem.m_41619_()) {
                    ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)InteractionHand.OFF_HAND);
                    player.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                }
            }
            if (target instanceof LivingEntity) {
                livingTarget = (LivingEntity)target;
                Level xOffset = player.m_9236_();
                if (xOffset instanceof ServerLevel) {
                    ServerLevel serverLevel2 = (ServerLevel)xOffset;
                    float damageDealt = targetHealth - livingTarget.m_21223_();
                    player.m_36222_(Stats.f_12928_, Math.round(damageDealt * 10.0f));
                    if (fireAspectLevel > 0) {
                        target.m_20254_(fireAspectLevel * 4);
                    }
                    if (damageDealt > 2.0f) {
                        int particleCount = (int)((double)damageDealt * 0.5);
                        serverLevel2.m_8767_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), particleCount, 0.1, 0.0, 0.1, 0.2);
                    }
                }
            }
            player.m_36399_(0.1f);
        } else {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12315_, player.m_5720_(), 1.0f, 1.0f);
            if (fireApplied) {
                target.m_20095_();
            }
        }
        player.m_36334_();
    }

    private static double getAttributeFromItem(ItemStack stack, Attribute attribute, float defaultValue) {
        Multimap attributes = stack.m_41638_(EquipmentSlot.MAINHAND);
        Collection modifier = attributes.get((Object)attribute);
        return !modifier.isEmpty() ? modifier.stream().mapToDouble(AttributeModifier::m_22218_).sum() : (double)defaultValue;
    }
}

